/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of the <a>ModifyHsm</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyHsmResponse extends CloudHsmResponse implements
        ToCopyableBuilder<ModifyHsmResponse.Builder, ModifyHsmResponse> {
    private static final SdkField<String> HSM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HsmArn")
            .getter(getter(ModifyHsmResponse::hsmArn)).setter(setter(Builder::hsmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hsmArn;

    private ModifyHsmResponse(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
    }

    /**
     * <p>
     * The ARN of the HSM.
     * </p>
     * 
     * @return The ARN of the HSM.
     */
    public final String hsmArn() {
        return hsmArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hsmArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHsmResponse)) {
            return false;
        }
        ModifyHsmResponse other = (ModifyHsmResponse) obj;
        return Objects.equals(hsmArn(), other.hsmArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyHsmResponse").add("HsmArn", hsmArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmArn":
            return Optional.ofNullable(clazz.cast(hsmArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HsmArn", HSM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyHsmResponse, T> g) {
        return obj -> g.apply((ModifyHsmResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyHsmResponse> {
        /**
         * <p>
         * The ARN of the HSM.
         * </p>
         * 
         * @param hsmArn
         *        The ARN of the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmArn(String hsmArn);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private String hsmArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHsmResponse model) {
            super(model);
            hsmArn(model.hsmArn);
        }

        public final String getHsmArn() {
            return hsmArn;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        @Override
        public ModifyHsmResponse build() {
            return new ModifyHsmResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
