/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a string schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringSchemaConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<StringSchemaConfig.Builder, StringSchemaConfig> {
    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(StringSchemaConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue")
            .getter(getter(StringSchemaConfig::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue")
                    .unmarshallLocationName("DefaultValue").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Required")
            .getter(getter(StringSchemaConfig::required))
            .setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required")
                    .unmarshallLocationName("Required").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD,
            DEFAULT_VALUE_FIELD, REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String comment;

    private final String defaultValue;

    private final Boolean required;

    private StringSchemaConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.defaultValue = builder.defaultValue;
        this.required = builder.required;
    }

    /**
     * <p>
     * A comment to describe the parameter.
     * </p>
     * 
     * @return A comment to describe the parameter.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The default value of the parameter.
     * </p>
     * 
     * @return The default value of the parameter.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * Whether the defined parameter is required.
     * </p>
     * 
     * @return Whether the defined parameter is required.
     */
    public final Boolean required() {
        return required;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringSchemaConfig)) {
            return false;
        }
        StringSchemaConfig other = (StringSchemaConfig) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(required(), other.required());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringSchemaConfig")
                .add("Comment", comment() == null ? null : "*** Sensitive Data Redacted ***").add("DefaultValue", defaultValue())
                .add("Required", required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Required":
            return Optional.ofNullable(clazz.cast(required()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Comment", COMMENT_FIELD);
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("Required", REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringSchemaConfig, T> g) {
        return obj -> g.apply((StringSchemaConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringSchemaConfig> {
        /**
         * <p>
         * A comment to describe the parameter.
         * </p>
         * 
         * @param comment
         *        A comment to describe the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The default value of the parameter.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * Whether the defined parameter is required.
         * </p>
         * 
         * @param required
         *        Whether the defined parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private String defaultValue;

        private Boolean required;

        private BuilderImpl() {
        }

        private BuilderImpl(StringSchemaConfig model) {
            comment(model.comment);
            defaultValue(model.defaultValue);
            required(model.required);
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public StringSchemaConfig build() {
            return new StringSchemaConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
