/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the parameter definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterDefinitionSchema implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterDefinitionSchema.Builder, ParameterDefinitionSchema> {
    private static final SdkField<StringSchemaConfig> STRING_SCHEMA_FIELD = SdkField
            .<StringSchemaConfig> builder(MarshallingType.SDK_POJO)
            .memberName("StringSchema")
            .getter(getter(ParameterDefinitionSchema::stringSchema))
            .setter(setter(Builder::stringSchema))
            .constructor(StringSchemaConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringSchema")
                    .unmarshallLocationName("StringSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StringSchemaConfig stringSchema;

    private ParameterDefinitionSchema(BuilderImpl builder) {
        this.stringSchema = builder.stringSchema;
    }

    /**
     * <p>
     * An object that contains information about the string schema.
     * </p>
     * 
     * @return An object that contains information about the string schema.
     */
    public final StringSchemaConfig stringSchema() {
        return stringSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDefinitionSchema)) {
            return false;
        }
        ParameterDefinitionSchema other = (ParameterDefinitionSchema) obj;
        return Objects.equals(stringSchema(), other.stringSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterDefinitionSchema").add("StringSchema", stringSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringSchema":
            return Optional.ofNullable(clazz.cast(stringSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringSchema", STRING_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterDefinitionSchema, T> g) {
        return obj -> g.apply((ParameterDefinitionSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterDefinitionSchema> {
        /**
         * <p>
         * An object that contains information about the string schema.
         * </p>
         * 
         * @param stringSchema
         *        An object that contains information about the string schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringSchema(StringSchemaConfig stringSchema);

        /**
         * <p>
         * An object that contains information about the string schema.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringSchemaConfig.Builder} avoiding the
         * need to create one manually via {@link StringSchemaConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringSchemaConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #stringSchema(StringSchemaConfig)}.
         * 
         * @param stringSchema
         *        a consumer that will call methods on {@link StringSchemaConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringSchema(StringSchemaConfig)
         */
        default Builder stringSchema(Consumer<StringSchemaConfig.Builder> stringSchema) {
            return stringSchema(StringSchemaConfig.builder().applyMutation(stringSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StringSchemaConfig stringSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDefinitionSchema model) {
            stringSchema(model.stringSchema);
        }

        public final StringSchemaConfig.Builder getStringSchema() {
            return stringSchema != null ? stringSchema.toBuilder() : null;
        }

        public final void setStringSchema(StringSchemaConfig.BuilderImpl stringSchema) {
            this.stringSchema = stringSchema != null ? stringSchema.build() : null;
        }

        @Override
        public final Builder stringSchema(StringSchemaConfig stringSchema) {
            this.stringSchema = stringSchema;
            return this;
        }

        @Override
        public ParameterDefinitionSchema build() {
            return new ParameterDefinitionSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
