/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVpcOriginsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListVpcOriginsResponse.Builder, ListVpcOriginsResponse> {
    private static final SdkField<VpcOriginList> VPC_ORIGIN_LIST_FIELD = SdkField
            .<VpcOriginList> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOriginList")
            .getter(getter(ListVpcOriginsResponse::vpcOriginList))
            .setter(setter(Builder::vpcOriginList))
            .constructor(VpcOriginList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOriginList")
                    .unmarshallLocationName("VpcOriginList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ORIGIN_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcOriginList vpcOriginList;

    private ListVpcOriginsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcOriginList = builder.vpcOriginList;
    }

    /**
     * <p>
     * List of VPC origins.
     * </p>
     * 
     * @return List of VPC origins.
     */
    public final VpcOriginList vpcOriginList() {
        return vpcOriginList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcOriginList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcOriginsResponse)) {
            return false;
        }
        ListVpcOriginsResponse other = (ListVpcOriginsResponse) obj;
        return Objects.equals(vpcOriginList(), other.vpcOriginList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVpcOriginsResponse").add("VpcOriginList", vpcOriginList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcOriginList":
            return Optional.ofNullable(clazz.cast(vpcOriginList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcOriginList", VPC_ORIGIN_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpcOriginsResponse, T> g) {
        return obj -> g.apply((ListVpcOriginsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVpcOriginsResponse> {
        /**
         * <p>
         * List of VPC origins.
         * </p>
         * 
         * @param vpcOriginList
         *        List of VPC origins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOriginList(VpcOriginList vpcOriginList);

        /**
         * <p>
         * List of VPC origins.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOriginList.Builder} avoiding the need
         * to create one manually via {@link VpcOriginList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcOriginList.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcOriginList(VpcOriginList)}.
         * 
         * @param vpcOriginList
         *        a consumer that will call methods on {@link VpcOriginList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOriginList(VpcOriginList)
         */
        default Builder vpcOriginList(Consumer<VpcOriginList.Builder> vpcOriginList) {
            return vpcOriginList(VpcOriginList.builder().applyMutation(vpcOriginList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private VpcOriginList vpcOriginList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcOriginsResponse model) {
            super(model);
            vpcOriginList(model.vpcOriginList);
        }

        public final VpcOriginList.Builder getVpcOriginList() {
            return vpcOriginList != null ? vpcOriginList.toBuilder() : null;
        }

        public final void setVpcOriginList(VpcOriginList.BuilderImpl vpcOriginList) {
            this.vpcOriginList = vpcOriginList != null ? vpcOriginList.build() : null;
        }

        @Override
        public final Builder vpcOriginList(VpcOriginList vpcOriginList) {
            this.vpcOriginList = vpcOriginList;
            return this;
        }

        @Override
        public ListVpcOriginsResponse build() {
            return new ListVpcOriginsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
