/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Hook invocation, its status, and the reason for its status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HookResultSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HookResultSummary.Builder, HookResultSummary> {
    private static final SdkField<String> HOOK_RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookResultId").getter(getter(HookResultSummary::hookResultId)).setter(setter(Builder::hookResultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookResultId").build()).build();

    private static final SdkField<String> INVOCATION_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationPoint").getter(getter(HookResultSummary::invocationPointAsString))
            .setter(setter(Builder::invocationPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPoint").build()).build();

    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMode").getter(getter(HookResultSummary::failureModeAsString))
            .setter(setter(Builder::failureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(HookResultSummary::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersionId").getter(getter(HookResultSummary::typeVersionId)).setter(setter(Builder::typeVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()).build();

    private static final SdkField<String> TYPE_CONFIGURATION_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TypeConfigurationVersionId")
            .getter(getter(HookResultSummary::typeConfigurationVersionId))
            .setter(setter(Builder::typeConfigurationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationVersionId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(HookResultSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatusReason").getter(getter(HookResultSummary::hookStatusReason))
            .setter(setter(Builder::hookStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()).build();

    private static final SdkField<Instant> INVOKED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvokedAt").getter(getter(HookResultSummary::invokedAt)).setter(setter(Builder::invokedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokedAt").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(HookResultSummary::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(HookResultSummary::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeArn").getter(getter(HookResultSummary::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<String> HOOK_EXECUTION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookExecutionTarget").getter(getter(HookResultSummary::hookExecutionTarget))
            .setter(setter(Builder::hookExecutionTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookExecutionTarget").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOOK_RESULT_ID_FIELD,
            INVOCATION_POINT_FIELD, FAILURE_MODE_FIELD, TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD,
            TYPE_CONFIGURATION_VERSION_ID_FIELD, STATUS_FIELD, HOOK_STATUS_REASON_FIELD, INVOKED_AT_FIELD, TARGET_TYPE_FIELD,
            TARGET_ID_FIELD, TYPE_ARN_FIELD, HOOK_EXECUTION_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hookResultId;

    private final String invocationPoint;

    private final String failureMode;

    private final String typeName;

    private final String typeVersionId;

    private final String typeConfigurationVersionId;

    private final String status;

    private final String hookStatusReason;

    private final Instant invokedAt;

    private final String targetType;

    private final String targetId;

    private final String typeArn;

    private final String hookExecutionTarget;

    private HookResultSummary(BuilderImpl builder) {
        this.hookResultId = builder.hookResultId;
        this.invocationPoint = builder.invocationPoint;
        this.failureMode = builder.failureMode;
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.typeConfigurationVersionId = builder.typeConfigurationVersionId;
        this.status = builder.status;
        this.hookStatusReason = builder.hookStatusReason;
        this.invokedAt = builder.invokedAt;
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.typeArn = builder.typeArn;
        this.hookExecutionTarget = builder.hookExecutionTarget;
    }

    /**
     * <p>
     * The unique identifier for this Hook invocation result.
     * </p>
     * 
     * @return The unique identifier for this Hook invocation result.
     */
    public final String hookResultId() {
        return hookResultId;
    }

    /**
     * <p>
     * The specific point in the provisioning process where the Hook is invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationPoint}
     * will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationPointAsString}.
     * </p>
     * 
     * @return The specific point in the provisioning process where the Hook is invoked.
     * @see HookInvocationPoint
     */
    public final HookInvocationPoint invocationPoint() {
        return HookInvocationPoint.fromValue(invocationPoint);
    }

    /**
     * <p>
     * The specific point in the provisioning process where the Hook is invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationPoint}
     * will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationPointAsString}.
     * </p>
     * 
     * @return The specific point in the provisioning process where the Hook is invoked.
     * @see HookInvocationPoint
     */
    public final String invocationPointAsString() {
        return invocationPoint;
    }

    /**
     * <p>
     * The failure mode of the invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureModeAsString}.
     * </p>
     * 
     * @return The failure mode of the invocation.
     * @see HookFailureMode
     */
    public final HookFailureMode failureMode() {
        return HookFailureMode.fromValue(failureMode);
    }

    /**
     * <p>
     * The failure mode of the invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureModeAsString}.
     * </p>
     * 
     * @return The failure mode of the invocation.
     * @see HookFailureMode
     */
    public final String failureModeAsString() {
        return failureMode;
    }

    /**
     * <p>
     * The name of the Hook that was invoked.
     * </p>
     * 
     * @return The name of the Hook that was invoked.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The version of the Hook that was invoked.
     * </p>
     * 
     * @return The version of the Hook that was invoked.
     */
    public final String typeVersionId() {
        return typeVersionId;
    }

    /**
     * <p>
     * The version of the Hook configuration.
     * </p>
     * 
     * @return The version of the Hook configuration.
     */
    public final String typeConfigurationVersionId() {
        return typeConfigurationVersionId;
    }

    /**
     * <p>
     * The status of the Hook invocation. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Hook invocation. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
     *         </p>
     *         </li>
     * @see HookStatus
     */
    public final HookStatus status() {
        return HookStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Hook invocation. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Hook invocation. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
     *         </p>
     *         </li>
     * @see HookStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the Hook results status. For example, if the Hook result is in a failed state, this may contain
     * additional information for the failed state.
     * </p>
     * 
     * @return A description of the Hook results status. For example, if the Hook result is in a failed state, this may
     *         contain additional information for the failed state.
     */
    public final String hookStatusReason() {
        return hookStatusReason;
    }

    /**
     * <p>
     * The timestamp when the Hook was invoked.
     * </p>
     * <p>
     * Only shown in responses when the request does not specify <code>TargetType</code> and <code>TargetId</code>
     * filters.
     * </p>
     * 
     * @return The timestamp when the Hook was invoked.</p>
     *         <p>
     *         Only shown in responses when the request does not specify <code>TargetType</code> and
     *         <code>TargetId</code> filters.
     */
    public final Instant invokedAt() {
        return invokedAt;
    }

    /**
     * <p>
     * The target type that the Hook was invoked against.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link ListHookResultsTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type that the Hook was invoked against.
     * @see ListHookResultsTargetType
     */
    public final ListHookResultsTargetType targetType() {
        return ListHookResultsTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The target type that the Hook was invoked against.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link ListHookResultsTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type that the Hook was invoked against.
     * @see ListHookResultsTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The unique identifier of the Hook invocation target.
     * </p>
     * 
     * @return The unique identifier of the Hook invocation target.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The ARN of the Hook that was invoked.
     * </p>
     * 
     * @return The ARN of the Hook that was invoked.
     */
    public final String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * The ARN of the target stack or request token of the Cloud Control API operation.
     * </p>
     * <p>
     * Only shown in responses when the request does not specify <code>TargetType</code> and <code>TargetId</code>
     * filters.
     * </p>
     * 
     * @return The ARN of the target stack or request token of the Cloud Control API operation.</p>
     *         <p>
     *         Only shown in responses when the request does not specify <code>TargetType</code> and
     *         <code>TargetId</code> filters.
     */
    public final String hookExecutionTarget() {
        return hookExecutionTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hookResultId());
        hashCode = 31 * hashCode + Objects.hashCode(invocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeConfigurationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(invokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(hookExecutionTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HookResultSummary)) {
            return false;
        }
        HookResultSummary other = (HookResultSummary) obj;
        return Objects.equals(hookResultId(), other.hookResultId())
                && Objects.equals(invocationPointAsString(), other.invocationPointAsString())
                && Objects.equals(failureModeAsString(), other.failureModeAsString())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(typeVersionId(), other.typeVersionId())
                && Objects.equals(typeConfigurationVersionId(), other.typeConfigurationVersionId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(hookStatusReason(), other.hookStatusReason()) && Objects.equals(invokedAt(), other.invokedAt())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(targetId(), other.targetId()) && Objects.equals(typeArn(), other.typeArn())
                && Objects.equals(hookExecutionTarget(), other.hookExecutionTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HookResultSummary").add("HookResultId", hookResultId())
                .add("InvocationPoint", invocationPointAsString()).add("FailureMode", failureModeAsString())
                .add("TypeName", typeName()).add("TypeVersionId", typeVersionId())
                .add("TypeConfigurationVersionId", typeConfigurationVersionId()).add("Status", statusAsString())
                .add("HookStatusReason", hookStatusReason()).add("InvokedAt", invokedAt())
                .add("TargetType", targetTypeAsString()).add("TargetId", targetId()).add("TypeArn", typeArn())
                .add("HookExecutionTarget", hookExecutionTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HookResultId":
            return Optional.ofNullable(clazz.cast(hookResultId()));
        case "InvocationPoint":
            return Optional.ofNullable(clazz.cast(invocationPointAsString()));
        case "FailureMode":
            return Optional.ofNullable(clazz.cast(failureModeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "TypeVersionId":
            return Optional.ofNullable(clazz.cast(typeVersionId()));
        case "TypeConfigurationVersionId":
            return Optional.ofNullable(clazz.cast(typeConfigurationVersionId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "HookStatusReason":
            return Optional.ofNullable(clazz.cast(hookStatusReason()));
        case "InvokedAt":
            return Optional.ofNullable(clazz.cast(invokedAt()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "HookExecutionTarget":
            return Optional.ofNullable(clazz.cast(hookExecutionTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HookResultId", HOOK_RESULT_ID_FIELD);
        map.put("InvocationPoint", INVOCATION_POINT_FIELD);
        map.put("FailureMode", FAILURE_MODE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
        map.put("TypeConfigurationVersionId", TYPE_CONFIGURATION_VERSION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("HookStatusReason", HOOK_STATUS_REASON_FIELD);
        map.put("InvokedAt", INVOKED_AT_FIELD);
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("TypeArn", TYPE_ARN_FIELD);
        map.put("HookExecutionTarget", HOOK_EXECUTION_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HookResultSummary, T> g) {
        return obj -> g.apply((HookResultSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HookResultSummary> {
        /**
         * <p>
         * The unique identifier for this Hook invocation result.
         * </p>
         * 
         * @param hookResultId
         *        The unique identifier for this Hook invocation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookResultId(String hookResultId);

        /**
         * <p>
         * The specific point in the provisioning process where the Hook is invoked.
         * </p>
         * 
         * @param invocationPoint
         *        The specific point in the provisioning process where the Hook is invoked.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder invocationPoint(String invocationPoint);

        /**
         * <p>
         * The specific point in the provisioning process where the Hook is invoked.
         * </p>
         * 
         * @param invocationPoint
         *        The specific point in the provisioning process where the Hook is invoked.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder invocationPoint(HookInvocationPoint invocationPoint);

        /**
         * <p>
         * The failure mode of the invocation.
         * </p>
         * 
         * @param failureMode
         *        The failure mode of the invocation.
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder failureMode(String failureMode);

        /**
         * <p>
         * The failure mode of the invocation.
         * </p>
         * 
         * @param failureMode
         *        The failure mode of the invocation.
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder failureMode(HookFailureMode failureMode);

        /**
         * <p>
         * The name of the Hook that was invoked.
         * </p>
         * 
         * @param typeName
         *        The name of the Hook that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The version of the Hook that was invoked.
         * </p>
         * 
         * @param typeVersionId
         *        The version of the Hook that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionId(String typeVersionId);

        /**
         * <p>
         * The version of the Hook configuration.
         * </p>
         * 
         * @param typeConfigurationVersionId
         *        The version of the Hook configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurationVersionId(String typeConfigurationVersionId);

        /**
         * <p>
         * The status of the Hook invocation. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Hook invocation. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
         *        </p>
         *        </li>
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Hook invocation. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Hook invocation. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
         *        </p>
         *        </li>
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder status(HookStatus status);

        /**
         * <p>
         * A description of the Hook results status. For example, if the Hook result is in a failed state, this may
         * contain additional information for the failed state.
         * </p>
         * 
         * @param hookStatusReason
         *        A description of the Hook results status. For example, if the Hook result is in a failed state, this
         *        may contain additional information for the failed state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookStatusReason(String hookStatusReason);

        /**
         * <p>
         * The timestamp when the Hook was invoked.
         * </p>
         * <p>
         * Only shown in responses when the request does not specify <code>TargetType</code> and <code>TargetId</code>
         * filters.
         * </p>
         * 
         * @param invokedAt
         *        The timestamp when the Hook was invoked.</p>
         *        <p>
         *        Only shown in responses when the request does not specify <code>TargetType</code> and
         *        <code>TargetId</code> filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedAt(Instant invokedAt);

        /**
         * <p>
         * The target type that the Hook was invoked against.
         * </p>
         * 
         * @param targetType
         *        The target type that the Hook was invoked against.
         * @see ListHookResultsTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListHookResultsTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The target type that the Hook was invoked against.
         * </p>
         * 
         * @param targetType
         *        The target type that the Hook was invoked against.
         * @see ListHookResultsTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListHookResultsTargetType
         */
        Builder targetType(ListHookResultsTargetType targetType);

        /**
         * <p>
         * The unique identifier of the Hook invocation target.
         * </p>
         * 
         * @param targetId
         *        The unique identifier of the Hook invocation target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The ARN of the Hook that was invoked.
         * </p>
         * 
         * @param typeArn
         *        The ARN of the Hook that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * The ARN of the target stack or request token of the Cloud Control API operation.
         * </p>
         * <p>
         * Only shown in responses when the request does not specify <code>TargetType</code> and <code>TargetId</code>
         * filters.
         * </p>
         * 
         * @param hookExecutionTarget
         *        The ARN of the target stack or request token of the Cloud Control API operation.</p>
         *        <p>
         *        Only shown in responses when the request does not specify <code>TargetType</code> and
         *        <code>TargetId</code> filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookExecutionTarget(String hookExecutionTarget);
    }

    static final class BuilderImpl implements Builder {
        private String hookResultId;

        private String invocationPoint;

        private String failureMode;

        private String typeName;

        private String typeVersionId;

        private String typeConfigurationVersionId;

        private String status;

        private String hookStatusReason;

        private Instant invokedAt;

        private String targetType;

        private String targetId;

        private String typeArn;

        private String hookExecutionTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(HookResultSummary model) {
            hookResultId(model.hookResultId);
            invocationPoint(model.invocationPoint);
            failureMode(model.failureMode);
            typeName(model.typeName);
            typeVersionId(model.typeVersionId);
            typeConfigurationVersionId(model.typeConfigurationVersionId);
            status(model.status);
            hookStatusReason(model.hookStatusReason);
            invokedAt(model.invokedAt);
            targetType(model.targetType);
            targetId(model.targetId);
            typeArn(model.typeArn);
            hookExecutionTarget(model.hookExecutionTarget);
        }

        public final String getHookResultId() {
            return hookResultId;
        }

        public final void setHookResultId(String hookResultId) {
            this.hookResultId = hookResultId;
        }

        @Override
        public final Builder hookResultId(String hookResultId) {
            this.hookResultId = hookResultId;
            return this;
        }

        public final String getInvocationPoint() {
            return invocationPoint;
        }

        public final void setInvocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
        }

        @Override
        public final Builder invocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
            return this;
        }

        @Override
        public final Builder invocationPoint(HookInvocationPoint invocationPoint) {
            this.invocationPoint(invocationPoint == null ? null : invocationPoint.toString());
            return this;
        }

        public final String getFailureMode() {
            return failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public final Builder failureMode(HookFailureMode failureMode) {
            this.failureMode(failureMode == null ? null : failureMode.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getTypeConfigurationVersionId() {
            return typeConfigurationVersionId;
        }

        public final void setTypeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
        }

        @Override
        public final Builder typeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HookStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        public final Instant getInvokedAt() {
            return invokedAt;
        }

        public final void setInvokedAt(Instant invokedAt) {
            this.invokedAt = invokedAt;
        }

        @Override
        public final Builder invokedAt(Instant invokedAt) {
            this.invokedAt = invokedAt;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(ListHookResultsTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTypeArn() {
            return typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getHookExecutionTarget() {
            return hookExecutionTarget;
        }

        public final void setHookExecutionTarget(String hookExecutionTarget) {
            this.hookExecutionTarget = hookExecutionTarget;
        }

        @Override
        public final Builder hookExecutionTarget(String hookExecutionTarget) {
            this.hookExecutionTarget = hookExecutionTarget;
            return this;
        }

        @Override
        public HookResultSummary build() {
            return new HookResultSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
