/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for <a>GetTemplate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateResponse extends CloudFormationResponse implements
        ToCopyableBuilder<GetTemplateResponse.Builder, GetTemplateResponse> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(GetTemplateResponse::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<List<String>> STAGES_AVAILABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StagesAvailable")
            .getter(getter(GetTemplateResponse::stagesAvailableAsStrings))
            .setter(setter(Builder::stagesAvailableWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagesAvailable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD,
            STAGES_AVAILABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateBody;

    private final List<String> stagesAvailable;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.stagesAvailable = builder.stagesAvailable;
    }

    /**
     * <p>
     * Structure that contains the template body.
     * </p>
     * <p>
     * CloudFormation returns the same template that was used when the stack was created.
     * </p>
     * 
     * @return Structure that contains the template body.</p>
     *         <p>
     *         CloudFormation returns the same template that was used when the stack was created.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and <code>Processed</code>
     * templates are always available. For change sets, the <code>Original</code> template is always available. After
     * CloudFormation finishes creating the change set, the <code>Processed</code> template becomes available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStagesAvailable} method.
     * </p>
     * 
     * @return The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
     *         <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
     *         template is always available. After CloudFormation finishes creating the change set, the
     *         <code>Processed</code> template becomes available.
     */
    public final List<TemplateStage> stagesAvailable() {
        return StageListCopier.copyStringToEnum(stagesAvailable);
    }

    /**
     * For responses, this returns true if the service returned a value for the StagesAvailable property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStagesAvailable() {
        return stagesAvailable != null && !(stagesAvailable instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and <code>Processed</code>
     * templates are always available. For change sets, the <code>Original</code> template is always available. After
     * CloudFormation finishes creating the change set, the <code>Processed</code> template becomes available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStagesAvailable} method.
     * </p>
     * 
     * @return The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
     *         <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
     *         template is always available. After CloudFormation finishes creating the change set, the
     *         <code>Processed</code> template becomes available.
     */
    public final List<String> stagesAvailableAsStrings() {
        return stagesAvailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(hasStagesAvailable() ? stagesAvailableAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse) obj;
        return Objects.equals(templateBody(), other.templateBody()) && hasStagesAvailable() == other.hasStagesAvailable()
                && Objects.equals(stagesAvailableAsStrings(), other.stagesAvailableAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemplateResponse").add("TemplateBody", templateBody())
                .add("StagesAvailable", hasStagesAvailable() ? stagesAvailableAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "StagesAvailable":
            return Optional.ofNullable(clazz.cast(stagesAvailableAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateBody", TEMPLATE_BODY_FIELD);
        map.put("StagesAvailable", STAGES_AVAILABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateResponse, T> g) {
        return obj -> g.apply((GetTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTemplateResponse> {
        /**
         * <p>
         * Structure that contains the template body.
         * </p>
         * <p>
         * CloudFormation returns the same template that was used when the stack was created.
         * </p>
         * 
         * @param templateBody
         *        Structure that contains the template body.</p>
         *        <p>
         *        CloudFormation returns the same template that was used when the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After CloudFormation finishes creating the change set, the <code>Processed</code> template
         * becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailableWithStrings(Collection<String> stagesAvailable);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After CloudFormation finishes creating the change set, the <code>Processed</code> template
         * becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailableWithStrings(String... stagesAvailable);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After CloudFormation finishes creating the change set, the <code>Processed</code> template
         * becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailable(Collection<TemplateStage> stagesAvailable);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After CloudFormation finishes creating the change set, the <code>Processed</code> template
         * becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailable(TemplateStage... stagesAvailable);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String templateBody;

        private List<String> stagesAvailable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            templateBody(model.templateBody);
            stagesAvailableWithStrings(model.stagesAvailable);
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final Collection<String> getStagesAvailable() {
            if (stagesAvailable instanceof SdkAutoConstructList) {
                return null;
            }
            return stagesAvailable;
        }

        public final void setStagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
        }

        @Override
        public final Builder stagesAvailableWithStrings(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailableWithStrings(String... stagesAvailable) {
            stagesAvailableWithStrings(Arrays.asList(stagesAvailable));
            return this;
        }

        @Override
        public final Builder stagesAvailable(Collection<TemplateStage> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copyEnumToString(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailable(TemplateStage... stagesAvailable) {
            stagesAvailable(Arrays.asList(stagesAvailable));
            return this;
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
