/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure that contains attribute update information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkAttributeUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<LinkAttributeUpdate.Builder, LinkAttributeUpdate> {
    private static final SdkField<AttributeKey> ATTRIBUTE_KEY_FIELD = SdkField.<AttributeKey> builder(MarshallingType.SDK_POJO)
            .memberName("AttributeKey").getter(getter(LinkAttributeUpdate::attributeKey)).setter(setter(Builder::attributeKey))
            .constructor(AttributeKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeKey").build()).build();

    private static final SdkField<LinkAttributeAction> ATTRIBUTE_ACTION_FIELD = SdkField
            .<LinkAttributeAction> builder(MarshallingType.SDK_POJO).memberName("AttributeAction")
            .getter(getter(LinkAttributeUpdate::attributeAction)).setter(setter(Builder::attributeAction))
            .constructor(LinkAttributeAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_KEY_FIELD,
            ATTRIBUTE_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AttributeKey attributeKey;

    private final LinkAttributeAction attributeAction;

    private LinkAttributeUpdate(BuilderImpl builder) {
        this.attributeKey = builder.attributeKey;
        this.attributeAction = builder.attributeAction;
    }

    /**
     * <p>
     * The key of the attribute being updated.
     * </p>
     * 
     * @return The key of the attribute being updated.
     */
    public final AttributeKey attributeKey() {
        return attributeKey;
    }

    /**
     * <p>
     * The action to perform as part of the attribute update.
     * </p>
     * 
     * @return The action to perform as part of the attribute update.
     */
    public final LinkAttributeAction attributeAction() {
        return attributeAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(attributeAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkAttributeUpdate)) {
            return false;
        }
        LinkAttributeUpdate other = (LinkAttributeUpdate) obj;
        return Objects.equals(attributeKey(), other.attributeKey()) && Objects.equals(attributeAction(), other.attributeAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinkAttributeUpdate").add("AttributeKey", attributeKey())
                .add("AttributeAction", attributeAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeKey":
            return Optional.ofNullable(clazz.cast(attributeKey()));
        case "AttributeAction":
            return Optional.ofNullable(clazz.cast(attributeAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeKey", ATTRIBUTE_KEY_FIELD);
        map.put("AttributeAction", ATTRIBUTE_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkAttributeUpdate, T> g) {
        return obj -> g.apply((LinkAttributeUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkAttributeUpdate> {
        /**
         * <p>
         * The key of the attribute being updated.
         * </p>
         * 
         * @param attributeKey
         *        The key of the attribute being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeKey(AttributeKey attributeKey);

        /**
         * <p>
         * The key of the attribute being updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeKey.Builder} avoiding the need
         * to create one manually via {@link AttributeKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeKey.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeKey(AttributeKey)}.
         * 
         * @param attributeKey
         *        a consumer that will call methods on {@link AttributeKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeKey(AttributeKey)
         */
        default Builder attributeKey(Consumer<AttributeKey.Builder> attributeKey) {
            return attributeKey(AttributeKey.builder().applyMutation(attributeKey).build());
        }

        /**
         * <p>
         * The action to perform as part of the attribute update.
         * </p>
         * 
         * @param attributeAction
         *        The action to perform as part of the attribute update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeAction(LinkAttributeAction attributeAction);

        /**
         * <p>
         * The action to perform as part of the attribute update.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkAttributeAction.Builder} avoiding the
         * need to create one manually via {@link LinkAttributeAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkAttributeAction.Builder#build()} is called immediately and
         * its result is passed to {@link #attributeAction(LinkAttributeAction)}.
         * 
         * @param attributeAction
         *        a consumer that will call methods on {@link LinkAttributeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeAction(LinkAttributeAction)
         */
        default Builder attributeAction(Consumer<LinkAttributeAction.Builder> attributeAction) {
            return attributeAction(LinkAttributeAction.builder().applyMutation(attributeAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AttributeKey attributeKey;

        private LinkAttributeAction attributeAction;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkAttributeUpdate model) {
            attributeKey(model.attributeKey);
            attributeAction(model.attributeAction);
        }

        public final AttributeKey.Builder getAttributeKey() {
            return attributeKey != null ? attributeKey.toBuilder() : null;
        }

        public final void setAttributeKey(AttributeKey.BuilderImpl attributeKey) {
            this.attributeKey = attributeKey != null ? attributeKey.build() : null;
        }

        @Override
        public final Builder attributeKey(AttributeKey attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        public final LinkAttributeAction.Builder getAttributeAction() {
            return attributeAction != null ? attributeAction.toBuilder() : null;
        }

        public final void setAttributeAction(LinkAttributeAction.BuilderImpl attributeAction) {
            this.attributeAction = attributeAction != null ? attributeAction.build() : null;
        }

        @Override
        public final Builder attributeAction(LinkAttributeAction attributeAction) {
            this.attributeAction = attributeAction;
            return this;
        }

        @Override
        public LinkAttributeUpdate build() {
            return new LinkAttributeUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
