/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSigninDelegateGroupsWithAccountRequest extends ChimeRequest
        implements
        ToCopyableBuilder<AssociateSigninDelegateGroupsWithAccountRequest.Builder, AssociateSigninDelegateGroupsWithAccountRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AssociateSigninDelegateGroupsWithAccountRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<List<SigninDelegateGroup>> SIGNIN_DELEGATE_GROUPS_FIELD = SdkField
            .<List<SigninDelegateGroup>> builder(MarshallingType.LIST)
            .memberName("SigninDelegateGroups")
            .getter(getter(AssociateSigninDelegateGroupsWithAccountRequest::signinDelegateGroups))
            .setter(setter(Builder::signinDelegateGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigninDelegateGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SigninDelegateGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SigninDelegateGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            SIGNIN_DELEGATE_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final List<SigninDelegateGroup> signinDelegateGroups;

    private AssociateSigninDelegateGroupsWithAccountRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.signinDelegateGroups = builder.signinDelegateGroups;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SigninDelegateGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSigninDelegateGroups() {
        return signinDelegateGroups != null && !(signinDelegateGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sign-in delegate groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSigninDelegateGroups} method.
     * </p>
     * 
     * @return The sign-in delegate groups.
     */
    public final List<SigninDelegateGroup> signinDelegateGroups() {
        return signinDelegateGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSigninDelegateGroups() ? signinDelegateGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSigninDelegateGroupsWithAccountRequest)) {
            return false;
        }
        AssociateSigninDelegateGroupsWithAccountRequest other = (AssociateSigninDelegateGroupsWithAccountRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && hasSigninDelegateGroups() == other.hasSigninDelegateGroups()
                && Objects.equals(signinDelegateGroups(), other.signinDelegateGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSigninDelegateGroupsWithAccountRequest").add("AccountId", accountId())
                .add("SigninDelegateGroups", hasSigninDelegateGroups() ? signinDelegateGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "SigninDelegateGroups":
            return Optional.ofNullable(clazz.cast(signinDelegateGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("SigninDelegateGroups", SIGNIN_DELEGATE_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSigninDelegateGroupsWithAccountRequest, T> g) {
        return obj -> g.apply((AssociateSigninDelegateGroupsWithAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateSigninDelegateGroupsWithAccountRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The sign-in delegate groups.
         * </p>
         * 
         * @param signinDelegateGroups
         *        The sign-in delegate groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signinDelegateGroups(Collection<SigninDelegateGroup> signinDelegateGroups);

        /**
         * <p>
         * The sign-in delegate groups.
         * </p>
         * 
         * @param signinDelegateGroups
         *        The sign-in delegate groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signinDelegateGroups(SigninDelegateGroup... signinDelegateGroups);

        /**
         * <p>
         * The sign-in delegate groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chime.model.SigninDelegateGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.chime.model.SigninDelegateGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chime.model.SigninDelegateGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #signinDelegateGroups(List<SigninDelegateGroup>)}.
         * 
         * @param signinDelegateGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chime.model.SigninDelegateGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signinDelegateGroups(java.util.Collection<SigninDelegateGroup>)
         */
        Builder signinDelegateGroups(Consumer<SigninDelegateGroup.Builder>... signinDelegateGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private List<SigninDelegateGroup> signinDelegateGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSigninDelegateGroupsWithAccountRequest model) {
            super(model);
            accountId(model.accountId);
            signinDelegateGroups(model.signinDelegateGroups);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<SigninDelegateGroup.Builder> getSigninDelegateGroups() {
            List<SigninDelegateGroup.Builder> result = SigninDelegateGroupListCopier.copyToBuilder(this.signinDelegateGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSigninDelegateGroups(Collection<SigninDelegateGroup.BuilderImpl> signinDelegateGroups) {
            this.signinDelegateGroups = SigninDelegateGroupListCopier.copyFromBuilder(signinDelegateGroups);
        }

        @Override
        public final Builder signinDelegateGroups(Collection<SigninDelegateGroup> signinDelegateGroups) {
            this.signinDelegateGroups = SigninDelegateGroupListCopier.copy(signinDelegateGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signinDelegateGroups(SigninDelegateGroup... signinDelegateGroups) {
            signinDelegateGroups(Arrays.asList(signinDelegateGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signinDelegateGroups(Consumer<SigninDelegateGroup.Builder>... signinDelegateGroups) {
            signinDelegateGroups(Stream.of(signinDelegateGroups).map(c -> SigninDelegateGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSigninDelegateGroupsWithAccountRequest build() {
            return new AssociateSigninDelegateGroupsWithAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
