/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The types of cost that are included in a <code>COST</code> budget, such as tax and subscriptions.
 * </p>
 * <p>
 * <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>,
 * and <code>SAVINGS_PLANS_COVERAGE</code> budgets don't have <code>CostTypes</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostTypes implements SdkPojo, Serializable, ToCopyableBuilder<CostTypes.Builder, CostTypes> {
    private static final SdkField<Boolean> INCLUDE_TAX_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeTax").getter(getter(CostTypes::includeTax)).setter(setter(Builder::includeTax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTax").build()).build();

    private static final SdkField<Boolean> INCLUDE_SUBSCRIPTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeSubscription").getter(getter(CostTypes::includeSubscription))
            .setter(setter(Builder::includeSubscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeSubscription").build())
            .build();

    private static final SdkField<Boolean> USE_BLENDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseBlended").getter(getter(CostTypes::useBlended)).setter(setter(Builder::useBlended))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBlended").build()).build();

    private static final SdkField<Boolean> INCLUDE_REFUND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeRefund").getter(getter(CostTypes::includeRefund)).setter(setter(Builder::includeRefund))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeRefund").build()).build();

    private static final SdkField<Boolean> INCLUDE_CREDIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeCredit").getter(getter(CostTypes::includeCredit)).setter(setter(Builder::includeCredit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCredit").build()).build();

    private static final SdkField<Boolean> INCLUDE_UPFRONT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeUpfront").getter(getter(CostTypes::includeUpfront)).setter(setter(Builder::includeUpfront))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeUpfront").build()).build();

    private static final SdkField<Boolean> INCLUDE_RECURRING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeRecurring").getter(getter(CostTypes::includeRecurring)).setter(setter(Builder::includeRecurring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeRecurring").build()).build();

    private static final SdkField<Boolean> INCLUDE_OTHER_SUBSCRIPTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeOtherSubscription").getter(getter(CostTypes::includeOtherSubscription))
            .setter(setter(Builder::includeOtherSubscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeOtherSubscription").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_SUPPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeSupport").getter(getter(CostTypes::includeSupport)).setter(setter(Builder::includeSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeSupport").build()).build();

    private static final SdkField<Boolean> INCLUDE_DISCOUNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeDiscount").getter(getter(CostTypes::includeDiscount)).setter(setter(Builder::includeDiscount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDiscount").build()).build();

    private static final SdkField<Boolean> USE_AMORTIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseAmortized").getter(getter(CostTypes::useAmortized)).setter(setter(Builder::useAmortized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseAmortized").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_TAX_FIELD,
            INCLUDE_SUBSCRIPTION_FIELD, USE_BLENDED_FIELD, INCLUDE_REFUND_FIELD, INCLUDE_CREDIT_FIELD, INCLUDE_UPFRONT_FIELD,
            INCLUDE_RECURRING_FIELD, INCLUDE_OTHER_SUBSCRIPTION_FIELD, INCLUDE_SUPPORT_FIELD, INCLUDE_DISCOUNT_FIELD,
            USE_AMORTIZED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean includeTax;

    private final Boolean includeSubscription;

    private final Boolean useBlended;

    private final Boolean includeRefund;

    private final Boolean includeCredit;

    private final Boolean includeUpfront;

    private final Boolean includeRecurring;

    private final Boolean includeOtherSubscription;

    private final Boolean includeSupport;

    private final Boolean includeDiscount;

    private final Boolean useAmortized;

    private CostTypes(BuilderImpl builder) {
        this.includeTax = builder.includeTax;
        this.includeSubscription = builder.includeSubscription;
        this.useBlended = builder.useBlended;
        this.includeRefund = builder.includeRefund;
        this.includeCredit = builder.includeCredit;
        this.includeUpfront = builder.includeUpfront;
        this.includeRecurring = builder.includeRecurring;
        this.includeOtherSubscription = builder.includeOtherSubscription;
        this.includeSupport = builder.includeSupport;
        this.includeDiscount = builder.includeDiscount;
        this.useAmortized = builder.useAmortized;
    }

    /**
     * <p>
     * Specifies whether a budget includes taxes.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes taxes.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeTax() {
        return includeTax;
    }

    /**
     * <p>
     * Specifies whether a budget includes subscriptions.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes subscriptions.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeSubscription() {
        return includeSubscription;
    }

    /**
     * <p>
     * Specifies whether a budget uses a blended rate.
     * </p>
     * <p>
     * The default value is <code>false</code>.
     * </p>
     * 
     * @return Specifies whether a budget uses a blended rate.</p>
     *         <p>
     *         The default value is <code>false</code>.
     */
    public final Boolean useBlended() {
        return useBlended;
    }

    /**
     * <p>
     * Specifies whether a budget includes refunds.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes refunds.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeRefund() {
        return includeRefund;
    }

    /**
     * <p>
     * Specifies whether a budget includes credits.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes credits.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeCredit() {
        return includeCredit;
    }

    /**
     * <p>
     * Specifies whether a budget includes upfront RI costs.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes upfront RI costs.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeUpfront() {
        return includeUpfront;
    }

    /**
     * <p>
     * Specifies whether a budget includes recurring fees such as monthly RI fees.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes recurring fees such as monthly RI fees.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeRecurring() {
        return includeRecurring;
    }

    /**
     * <p>
     * Specifies whether a budget includes non-RI subscription costs.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes non-RI subscription costs.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeOtherSubscription() {
        return includeOtherSubscription;
    }

    /**
     * <p>
     * Specifies whether a budget includes support subscription fees.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes support subscription fees.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeSupport() {
        return includeSupport;
    }

    /**
     * <p>
     * Specifies whether a budget includes discounts.
     * </p>
     * <p>
     * The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether a budget includes discounts.</p>
     *         <p>
     *         The default value is <code>true</code>.
     */
    public final Boolean includeDiscount() {
        return includeDiscount;
    }

    /**
     * <p>
     * Specifies whether a budget uses the amortized rate.
     * </p>
     * <p>
     * The default value is <code>false</code>.
     * </p>
     * 
     * @return Specifies whether a budget uses the amortized rate.</p>
     *         <p>
     *         The default value is <code>false</code>.
     */
    public final Boolean useAmortized() {
        return useAmortized;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeTax());
        hashCode = 31 * hashCode + Objects.hashCode(includeSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(useBlended());
        hashCode = 31 * hashCode + Objects.hashCode(includeRefund());
        hashCode = 31 * hashCode + Objects.hashCode(includeCredit());
        hashCode = 31 * hashCode + Objects.hashCode(includeUpfront());
        hashCode = 31 * hashCode + Objects.hashCode(includeRecurring());
        hashCode = 31 * hashCode + Objects.hashCode(includeOtherSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(includeSupport());
        hashCode = 31 * hashCode + Objects.hashCode(includeDiscount());
        hashCode = 31 * hashCode + Objects.hashCode(useAmortized());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostTypes)) {
            return false;
        }
        CostTypes other = (CostTypes) obj;
        return Objects.equals(includeTax(), other.includeTax())
                && Objects.equals(includeSubscription(), other.includeSubscription())
                && Objects.equals(useBlended(), other.useBlended()) && Objects.equals(includeRefund(), other.includeRefund())
                && Objects.equals(includeCredit(), other.includeCredit())
                && Objects.equals(includeUpfront(), other.includeUpfront())
                && Objects.equals(includeRecurring(), other.includeRecurring())
                && Objects.equals(includeOtherSubscription(), other.includeOtherSubscription())
                && Objects.equals(includeSupport(), other.includeSupport())
                && Objects.equals(includeDiscount(), other.includeDiscount())
                && Objects.equals(useAmortized(), other.useAmortized());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostTypes").add("IncludeTax", includeTax()).add("IncludeSubscription", includeSubscription())
                .add("UseBlended", useBlended()).add("IncludeRefund", includeRefund()).add("IncludeCredit", includeCredit())
                .add("IncludeUpfront", includeUpfront()).add("IncludeRecurring", includeRecurring())
                .add("IncludeOtherSubscription", includeOtherSubscription()).add("IncludeSupport", includeSupport())
                .add("IncludeDiscount", includeDiscount()).add("UseAmortized", useAmortized()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludeTax":
            return Optional.ofNullable(clazz.cast(includeTax()));
        case "IncludeSubscription":
            return Optional.ofNullable(clazz.cast(includeSubscription()));
        case "UseBlended":
            return Optional.ofNullable(clazz.cast(useBlended()));
        case "IncludeRefund":
            return Optional.ofNullable(clazz.cast(includeRefund()));
        case "IncludeCredit":
            return Optional.ofNullable(clazz.cast(includeCredit()));
        case "IncludeUpfront":
            return Optional.ofNullable(clazz.cast(includeUpfront()));
        case "IncludeRecurring":
            return Optional.ofNullable(clazz.cast(includeRecurring()));
        case "IncludeOtherSubscription":
            return Optional.ofNullable(clazz.cast(includeOtherSubscription()));
        case "IncludeSupport":
            return Optional.ofNullable(clazz.cast(includeSupport()));
        case "IncludeDiscount":
            return Optional.ofNullable(clazz.cast(includeDiscount()));
        case "UseAmortized":
            return Optional.ofNullable(clazz.cast(useAmortized()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IncludeTax", INCLUDE_TAX_FIELD);
        map.put("IncludeSubscription", INCLUDE_SUBSCRIPTION_FIELD);
        map.put("UseBlended", USE_BLENDED_FIELD);
        map.put("IncludeRefund", INCLUDE_REFUND_FIELD);
        map.put("IncludeCredit", INCLUDE_CREDIT_FIELD);
        map.put("IncludeUpfront", INCLUDE_UPFRONT_FIELD);
        map.put("IncludeRecurring", INCLUDE_RECURRING_FIELD);
        map.put("IncludeOtherSubscription", INCLUDE_OTHER_SUBSCRIPTION_FIELD);
        map.put("IncludeSupport", INCLUDE_SUPPORT_FIELD);
        map.put("IncludeDiscount", INCLUDE_DISCOUNT_FIELD);
        map.put("UseAmortized", USE_AMORTIZED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostTypes, T> g) {
        return obj -> g.apply((CostTypes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostTypes> {
        /**
         * <p>
         * Specifies whether a budget includes taxes.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeTax
         *        Specifies whether a budget includes taxes.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTax(Boolean includeTax);

        /**
         * <p>
         * Specifies whether a budget includes subscriptions.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeSubscription
         *        Specifies whether a budget includes subscriptions.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSubscription(Boolean includeSubscription);

        /**
         * <p>
         * Specifies whether a budget uses a blended rate.
         * </p>
         * <p>
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param useBlended
         *        Specifies whether a budget uses a blended rate.</p>
         *        <p>
         *        The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBlended(Boolean useBlended);

        /**
         * <p>
         * Specifies whether a budget includes refunds.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeRefund
         *        Specifies whether a budget includes refunds.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRefund(Boolean includeRefund);

        /**
         * <p>
         * Specifies whether a budget includes credits.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeCredit
         *        Specifies whether a budget includes credits.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCredit(Boolean includeCredit);

        /**
         * <p>
         * Specifies whether a budget includes upfront RI costs.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeUpfront
         *        Specifies whether a budget includes upfront RI costs.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeUpfront(Boolean includeUpfront);

        /**
         * <p>
         * Specifies whether a budget includes recurring fees such as monthly RI fees.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeRecurring
         *        Specifies whether a budget includes recurring fees such as monthly RI fees.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRecurring(Boolean includeRecurring);

        /**
         * <p>
         * Specifies whether a budget includes non-RI subscription costs.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeOtherSubscription
         *        Specifies whether a budget includes non-RI subscription costs.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOtherSubscription(Boolean includeOtherSubscription);

        /**
         * <p>
         * Specifies whether a budget includes support subscription fees.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeSupport
         *        Specifies whether a budget includes support subscription fees.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSupport(Boolean includeSupport);

        /**
         * <p>
         * Specifies whether a budget includes discounts.
         * </p>
         * <p>
         * The default value is <code>true</code>.
         * </p>
         * 
         * @param includeDiscount
         *        Specifies whether a budget includes discounts.</p>
         *        <p>
         *        The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDiscount(Boolean includeDiscount);

        /**
         * <p>
         * Specifies whether a budget uses the amortized rate.
         * </p>
         * <p>
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param useAmortized
         *        Specifies whether a budget uses the amortized rate.</p>
         *        <p>
         *        The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useAmortized(Boolean useAmortized);
    }

    static final class BuilderImpl implements Builder {
        private Boolean includeTax;

        private Boolean includeSubscription;

        private Boolean useBlended;

        private Boolean includeRefund;

        private Boolean includeCredit;

        private Boolean includeUpfront;

        private Boolean includeRecurring;

        private Boolean includeOtherSubscription;

        private Boolean includeSupport;

        private Boolean includeDiscount;

        private Boolean useAmortized;

        private BuilderImpl() {
        }

        private BuilderImpl(CostTypes model) {
            includeTax(model.includeTax);
            includeSubscription(model.includeSubscription);
            useBlended(model.useBlended);
            includeRefund(model.includeRefund);
            includeCredit(model.includeCredit);
            includeUpfront(model.includeUpfront);
            includeRecurring(model.includeRecurring);
            includeOtherSubscription(model.includeOtherSubscription);
            includeSupport(model.includeSupport);
            includeDiscount(model.includeDiscount);
            useAmortized(model.useAmortized);
        }

        public final Boolean getIncludeTax() {
            return includeTax;
        }

        public final void setIncludeTax(Boolean includeTax) {
            this.includeTax = includeTax;
        }

        @Override
        public final Builder includeTax(Boolean includeTax) {
            this.includeTax = includeTax;
            return this;
        }

        public final Boolean getIncludeSubscription() {
            return includeSubscription;
        }

        public final void setIncludeSubscription(Boolean includeSubscription) {
            this.includeSubscription = includeSubscription;
        }

        @Override
        public final Builder includeSubscription(Boolean includeSubscription) {
            this.includeSubscription = includeSubscription;
            return this;
        }

        public final Boolean getUseBlended() {
            return useBlended;
        }

        public final void setUseBlended(Boolean useBlended) {
            this.useBlended = useBlended;
        }

        @Override
        public final Builder useBlended(Boolean useBlended) {
            this.useBlended = useBlended;
            return this;
        }

        public final Boolean getIncludeRefund() {
            return includeRefund;
        }

        public final void setIncludeRefund(Boolean includeRefund) {
            this.includeRefund = includeRefund;
        }

        @Override
        public final Builder includeRefund(Boolean includeRefund) {
            this.includeRefund = includeRefund;
            return this;
        }

        public final Boolean getIncludeCredit() {
            return includeCredit;
        }

        public final void setIncludeCredit(Boolean includeCredit) {
            this.includeCredit = includeCredit;
        }

        @Override
        public final Builder includeCredit(Boolean includeCredit) {
            this.includeCredit = includeCredit;
            return this;
        }

        public final Boolean getIncludeUpfront() {
            return includeUpfront;
        }

        public final void setIncludeUpfront(Boolean includeUpfront) {
            this.includeUpfront = includeUpfront;
        }

        @Override
        public final Builder includeUpfront(Boolean includeUpfront) {
            this.includeUpfront = includeUpfront;
            return this;
        }

        public final Boolean getIncludeRecurring() {
            return includeRecurring;
        }

        public final void setIncludeRecurring(Boolean includeRecurring) {
            this.includeRecurring = includeRecurring;
        }

        @Override
        public final Builder includeRecurring(Boolean includeRecurring) {
            this.includeRecurring = includeRecurring;
            return this;
        }

        public final Boolean getIncludeOtherSubscription() {
            return includeOtherSubscription;
        }

        public final void setIncludeOtherSubscription(Boolean includeOtherSubscription) {
            this.includeOtherSubscription = includeOtherSubscription;
        }

        @Override
        public final Builder includeOtherSubscription(Boolean includeOtherSubscription) {
            this.includeOtherSubscription = includeOtherSubscription;
            return this;
        }

        public final Boolean getIncludeSupport() {
            return includeSupport;
        }

        public final void setIncludeSupport(Boolean includeSupport) {
            this.includeSupport = includeSupport;
        }

        @Override
        public final Builder includeSupport(Boolean includeSupport) {
            this.includeSupport = includeSupport;
            return this;
        }

        public final Boolean getIncludeDiscount() {
            return includeDiscount;
        }

        public final void setIncludeDiscount(Boolean includeDiscount) {
            this.includeDiscount = includeDiscount;
        }

        @Override
        public final Builder includeDiscount(Boolean includeDiscount) {
            this.includeDiscount = includeDiscount;
            return this;
        }

        public final Boolean getUseAmortized() {
            return useAmortized;
        }

        public final void setUseAmortized(Boolean useAmortized) {
            this.useAmortized = useAmortized;
        }

        @Override
        public final Builder useAmortized(Boolean useAmortized) {
            this.useAmortized = useAmortized;
            return this;
        }

        @Override
        public CostTypes build() {
            return new CostTypes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
