/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies conditions for when to exit or retry a service job based on the exit status or status reason.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceJobEvaluateOnExit implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceJobEvaluateOnExit.Builder, ServiceJobEvaluateOnExit> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ServiceJobEvaluateOnExit::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> ON_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onStatusReason").getter(getter(ServiceJobEvaluateOnExit::onStatusReason))
            .setter(setter(Builder::onStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onStatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            ON_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String onStatusReason;

    private ServiceJobEvaluateOnExit(BuilderImpl builder) {
        this.action = builder.action;
        this.onStatusReason = builder.onStatusReason;
    }

    /**
     * <p>
     * The action to take if the service job exits with the specified condition. Valid values are <code>RETRY</code> and
     * <code>EXIT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ServiceJobRetryAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take if the service job exits with the specified condition. Valid values are
     *         <code>RETRY</code> and <code>EXIT</code>.
     * @see ServiceJobRetryAction
     */
    public final ServiceJobRetryAction action() {
        return ServiceJobRetryAction.fromValue(action);
    }

    /**
     * <p>
     * The action to take if the service job exits with the specified condition. Valid values are <code>RETRY</code> and
     * <code>EXIT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ServiceJobRetryAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take if the service job exits with the specified condition. Valid values are
     *         <code>RETRY</code> and <code>EXIT</code>.
     * @see ServiceJobRetryAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Contains a glob pattern to match against the StatusReason returned for a job. The pattern can contain up to 512
     * characters and can contain all printable characters. It can optionally end with an asterisk (*) so that only the
     * start of the string needs to be an exact match.
     * </p>
     * 
     * @return Contains a glob pattern to match against the StatusReason returned for a job. The pattern can contain up
     *         to 512 characters and can contain all printable characters. It can optionally end with an asterisk (*) so
     *         that only the start of the string needs to be an exact match.
     */
    public final String onStatusReason() {
        return onStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceJobEvaluateOnExit)) {
            return false;
        }
        ServiceJobEvaluateOnExit other = (ServiceJobEvaluateOnExit) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(onStatusReason(), other.onStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceJobEvaluateOnExit").add("Action", actionAsString())
                .add("OnStatusReason", onStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "onStatusReason":
            return Optional.ofNullable(clazz.cast(onStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("onStatusReason", ON_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceJobEvaluateOnExit, T> g) {
        return obj -> g.apply((ServiceJobEvaluateOnExit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceJobEvaluateOnExit> {
        /**
         * <p>
         * The action to take if the service job exits with the specified condition. Valid values are <code>RETRY</code>
         * and <code>EXIT</code>.
         * </p>
         * 
         * @param action
         *        The action to take if the service job exits with the specified condition. Valid values are
         *        <code>RETRY</code> and <code>EXIT</code>.
         * @see ServiceJobRetryAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobRetryAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to take if the service job exits with the specified condition. Valid values are <code>RETRY</code>
         * and <code>EXIT</code>.
         * </p>
         * 
         * @param action
         *        The action to take if the service job exits with the specified condition. Valid values are
         *        <code>RETRY</code> and <code>EXIT</code>.
         * @see ServiceJobRetryAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobRetryAction
         */
        Builder action(ServiceJobRetryAction action);

        /**
         * <p>
         * Contains a glob pattern to match against the StatusReason returned for a job. The pattern can contain up to
         * 512 characters and can contain all printable characters. It can optionally end with an asterisk (*) so that
         * only the start of the string needs to be an exact match.
         * </p>
         * 
         * @param onStatusReason
         *        Contains a glob pattern to match against the StatusReason returned for a job. The pattern can contain
         *        up to 512 characters and can contain all printable characters. It can optionally end with an asterisk
         *        (*) so that only the start of the string needs to be an exact match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onStatusReason(String onStatusReason);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String onStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceJobEvaluateOnExit model) {
            action(model.action);
            onStatusReason(model.onStatusReason);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ServiceJobRetryAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getOnStatusReason() {
            return onStatusReason;
        }

        public final void setOnStatusReason(String onStatusReason) {
            this.onStatusReason = onStatusReason;
        }

        @Override
        public final Builder onStatusReason(String onStatusReason) {
            this.onStatusReason = onStatusReason;
            return this;
        }

        @Override
        public ServiceJobEvaluateOnExit build() {
            return new ServiceJobEvaluateOnExit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
