/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceEnvironmentRequest extends BatchRequest implements
        ToCopyableBuilder<CreateServiceEnvironmentRequest.Builder, CreateServiceEnvironmentRequest> {
    private static final SdkField<String> SERVICE_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceEnvironmentName").getter(getter(CreateServiceEnvironmentRequest::serviceEnvironmentName))
            .setter(setter(Builder::serviceEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironmentName").build())
            .build();

    private static final SdkField<String> SERVICE_ENVIRONMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceEnvironmentType").getter(getter(CreateServiceEnvironmentRequest::serviceEnvironmentTypeAsString))
            .setter(setter(Builder::serviceEnvironmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironmentType").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(CreateServiceEnvironmentRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<List<CapacityLimit>> CAPACITY_LIMITS_FIELD = SdkField
            .<List<CapacityLimit>> builder(MarshallingType.LIST)
            .memberName("capacityLimits")
            .getter(getter(CreateServiceEnvironmentRequest::capacityLimits))
            .setter(setter(Builder::capacityLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateServiceEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVICE_ENVIRONMENT_NAME_FIELD, SERVICE_ENVIRONMENT_TYPE_FIELD, STATE_FIELD, CAPACITY_LIMITS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceEnvironmentName;

    private final String serviceEnvironmentType;

    private final String state;

    private final List<CapacityLimit> capacityLimits;

    private final Map<String, String> tags;

    private CreateServiceEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.serviceEnvironmentName = builder.serviceEnvironmentName;
        this.serviceEnvironmentType = builder.serviceEnvironmentType;
        this.state = builder.state;
        this.capacityLimits = builder.capacityLimits;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the service environment. It can be up to 128 characters long and can contain letters, numbers,
     * hyphens (-), and underscores (_).
     * </p>
     * 
     * @return The name for the service environment. It can be up to 128 characters long and can contain letters,
     *         numbers, hyphens (-), and underscores (_).
     */
    public final String serviceEnvironmentName() {
        return serviceEnvironmentName;
    }

    /**
     * <p>
     * The type of service environment. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceEnvironmentType} will return {@link ServiceEnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceEnvironmentTypeAsString}.
     * </p>
     * 
     * @return The type of service environment. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
     * @see ServiceEnvironmentType
     */
    public final ServiceEnvironmentType serviceEnvironmentType() {
        return ServiceEnvironmentType.fromValue(serviceEnvironmentType);
    }

    /**
     * <p>
     * The type of service environment. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceEnvironmentType} will return {@link ServiceEnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceEnvironmentTypeAsString}.
     * </p>
     * 
     * @return The type of service environment. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
     * @see ServiceEnvironmentType
     */
    public final String serviceEnvironmentTypeAsString() {
        return serviceEnvironmentType;
    }

    /**
     * <p>
     * The state of the service environment. Valid values are <code>ENABLED</code> and <code>DISABLED</code>. The
     * default value is <code>ENABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ServiceEnvironmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the service environment. Valid values are <code>ENABLED</code> and <code>DISABLED</code>.
     *         The default value is <code>ENABLED</code>.
     * @see ServiceEnvironmentState
     */
    public final ServiceEnvironmentState state() {
        return ServiceEnvironmentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the service environment. Valid values are <code>ENABLED</code> and <code>DISABLED</code>. The
     * default value is <code>ENABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ServiceEnvironmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the service environment. Valid values are <code>ENABLED</code> and <code>DISABLED</code>.
     *         The default value is <code>ENABLED</code>.
     * @see ServiceEnvironmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityLimits property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityLimits() {
        return capacityLimits != null && !(capacityLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity limits for the service environment. The number of instances a job consumes is the total number of
     * instances requested in the submit training job request resource configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityLimits} method.
     * </p>
     * 
     * @return The capacity limits for the service environment. The number of instances a job consumes is the total
     *         number of instances requested in the submit training job request resource configuration.
     */
    public final List<CapacityLimit> capacityLimits() {
        return capacityLimits;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that you apply to the service environment to help you categorize and organize your resources. Each tag
     * consists of a key and an optional value. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that you apply to the service environment to help you categorize and organize your resources.
     *         Each tag consists of a key and an optional value. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceEnvironmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityLimits() ? capacityLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceEnvironmentRequest)) {
            return false;
        }
        CreateServiceEnvironmentRequest other = (CreateServiceEnvironmentRequest) obj;
        return Objects.equals(serviceEnvironmentName(), other.serviceEnvironmentName())
                && Objects.equals(serviceEnvironmentTypeAsString(), other.serviceEnvironmentTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasCapacityLimits() == other.hasCapacityLimits()
                && Objects.equals(capacityLimits(), other.capacityLimits()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceEnvironmentRequest").add("ServiceEnvironmentName", serviceEnvironmentName())
                .add("ServiceEnvironmentType", serviceEnvironmentTypeAsString()).add("State", stateAsString())
                .add("CapacityLimits", hasCapacityLimits() ? capacityLimits() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceEnvironmentName":
            return Optional.ofNullable(clazz.cast(serviceEnvironmentName()));
        case "serviceEnvironmentType":
            return Optional.ofNullable(clazz.cast(serviceEnvironmentTypeAsString()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "capacityLimits":
            return Optional.ofNullable(clazz.cast(capacityLimits()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceEnvironmentName", SERVICE_ENVIRONMENT_NAME_FIELD);
        map.put("serviceEnvironmentType", SERVICE_ENVIRONMENT_TYPE_FIELD);
        map.put("state", STATE_FIELD);
        map.put("capacityLimits", CAPACITY_LIMITS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateServiceEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceEnvironmentRequest> {
        /**
         * <p>
         * The name for the service environment. It can be up to 128 characters long and can contain letters, numbers,
         * hyphens (-), and underscores (_).
         * </p>
         * 
         * @param serviceEnvironmentName
         *        The name for the service environment. It can be up to 128 characters long and can contain letters,
         *        numbers, hyphens (-), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceEnvironmentName(String serviceEnvironmentName);

        /**
         * <p>
         * The type of service environment. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param serviceEnvironmentType
         *        The type of service environment. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
         * @see ServiceEnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEnvironmentType
         */
        Builder serviceEnvironmentType(String serviceEnvironmentType);

        /**
         * <p>
         * The type of service environment. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param serviceEnvironmentType
         *        The type of service environment. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
         * @see ServiceEnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEnvironmentType
         */
        Builder serviceEnvironmentType(ServiceEnvironmentType serviceEnvironmentType);

        /**
         * <p>
         * The state of the service environment. Valid values are <code>ENABLED</code> and <code>DISABLED</code>. The
         * default value is <code>ENABLED</code>.
         * </p>
         * 
         * @param state
         *        The state of the service environment. Valid values are <code>ENABLED</code> and <code>DISABLED</code>.
         *        The default value is <code>ENABLED</code>.
         * @see ServiceEnvironmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEnvironmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the service environment. Valid values are <code>ENABLED</code> and <code>DISABLED</code>. The
         * default value is <code>ENABLED</code>.
         * </p>
         * 
         * @param state
         *        The state of the service environment. Valid values are <code>ENABLED</code> and <code>DISABLED</code>.
         *        The default value is <code>ENABLED</code>.
         * @see ServiceEnvironmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEnvironmentState
         */
        Builder state(ServiceEnvironmentState state);

        /**
         * <p>
         * The capacity limits for the service environment. The number of instances a job consumes is the total number
         * of instances requested in the submit training job request resource configuration.
         * </p>
         * 
         * @param capacityLimits
         *        The capacity limits for the service environment. The number of instances a job consumes is the total
         *        number of instances requested in the submit training job request resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityLimits(Collection<CapacityLimit> capacityLimits);

        /**
         * <p>
         * The capacity limits for the service environment. The number of instances a job consumes is the total number
         * of instances requested in the submit training job request resource configuration.
         * </p>
         * 
         * @param capacityLimits
         *        The capacity limits for the service environment. The number of instances a job consumes is the total
         *        number of instances requested in the submit training job request resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityLimits(CapacityLimit... capacityLimits);

        /**
         * <p>
         * The capacity limits for the service environment. The number of instances a job consumes is the total number
         * of instances requested in the submit training job request resource configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.CapacityLimit.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.CapacityLimit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.CapacityLimit.Builder#build()} is called immediately and
         * its result is passed to {@link #capacityLimits(List<CapacityLimit>)}.
         * 
         * @param capacityLimits
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.CapacityLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityLimits(java.util.Collection<CapacityLimit>)
         */
        Builder capacityLimits(Consumer<CapacityLimit.Builder>... capacityLimits);

        /**
         * <p>
         * The tags that you apply to the service environment to help you categorize and organize your resources. Each
         * tag consists of a key and an optional value. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags that you apply to the service environment to help you categorize and organize your resources.
         *        Each tag consists of a key and an optional value. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String serviceEnvironmentName;

        private String serviceEnvironmentType;

        private String state;

        private List<CapacityLimit> capacityLimits = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceEnvironmentRequest model) {
            super(model);
            serviceEnvironmentName(model.serviceEnvironmentName);
            serviceEnvironmentType(model.serviceEnvironmentType);
            state(model.state);
            capacityLimits(model.capacityLimits);
            tags(model.tags);
        }

        public final String getServiceEnvironmentName() {
            return serviceEnvironmentName;
        }

        public final void setServiceEnvironmentName(String serviceEnvironmentName) {
            this.serviceEnvironmentName = serviceEnvironmentName;
        }

        @Override
        public final Builder serviceEnvironmentName(String serviceEnvironmentName) {
            this.serviceEnvironmentName = serviceEnvironmentName;
            return this;
        }

        public final String getServiceEnvironmentType() {
            return serviceEnvironmentType;
        }

        public final void setServiceEnvironmentType(String serviceEnvironmentType) {
            this.serviceEnvironmentType = serviceEnvironmentType;
        }

        @Override
        public final Builder serviceEnvironmentType(String serviceEnvironmentType) {
            this.serviceEnvironmentType = serviceEnvironmentType;
            return this;
        }

        @Override
        public final Builder serviceEnvironmentType(ServiceEnvironmentType serviceEnvironmentType) {
            this.serviceEnvironmentType(serviceEnvironmentType == null ? null : serviceEnvironmentType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ServiceEnvironmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<CapacityLimit.Builder> getCapacityLimits() {
            List<CapacityLimit.Builder> result = CapacityLimitsCopier.copyToBuilder(this.capacityLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityLimits(Collection<CapacityLimit.BuilderImpl> capacityLimits) {
            this.capacityLimits = CapacityLimitsCopier.copyFromBuilder(capacityLimits);
        }

        @Override
        public final Builder capacityLimits(Collection<CapacityLimit> capacityLimits) {
            this.capacityLimits = CapacityLimitsCopier.copy(capacityLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityLimits(CapacityLimit... capacityLimits) {
            capacityLimits(Arrays.asList(capacityLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityLimits(Consumer<CapacityLimit.Builder>... capacityLimits) {
            capacityLimits(Stream.of(capacityLimits).map(c -> CapacityLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceEnvironmentRequest build() {
            return new CreateServiceEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
