/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecoveryPointIndexSettingsRequest extends BackupRequest implements
        ToCopyableBuilder<UpdateRecoveryPointIndexSettingsRequest.Builder, UpdateRecoveryPointIndexSettingsRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(UpdateRecoveryPointIndexSettingsRequest::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(UpdateRecoveryPointIndexSettingsRequest::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("recoveryPointArn").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(UpdateRecoveryPointIndexSettingsRequest::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> INDEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Index")
            .getter(getter(UpdateRecoveryPointIndexSettingsRequest::indexAsString)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            RECOVERY_POINT_ARN_FIELD, IAM_ROLE_ARN_FIELD, INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupVaultName;

    private final String recoveryPointArn;

    private final String iamRoleArn;

    private final String index;

    private UpdateRecoveryPointIndexSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.index = builder.index;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Region where they are created.
     * </p>
     * <p>
     * Accepted characters include lowercase letters, numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Region where they are created.</p>
     *         <p>
     *         Accepted characters include lowercase letters, numbers, and hyphens.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * This specifies the IAM role ARN used for this operation.
     * </p>
     * <p>
     * For example, arn:aws:iam::123456789012:role/S3Access
     * </p>
     * 
     * @return This specifies the IAM role ARN used for this operation.</p>
     *         <p>
     *         For example, arn:aws:iam::123456789012:role/S3Access
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * To create a backup index for an eligible <code>ACTIVE</code> recovery point that does not yet have a backup
     * index, set value to <code>ENABLED</code>.
     * </p>
     * <p>
     * To delete a backup index, set value to <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #index} will return
     * {@link Index#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexAsString}.
     * </p>
     * 
     * @return Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.</p>
     *         <p>
     *         To create a backup index for an eligible <code>ACTIVE</code> recovery point that does not yet have a
     *         backup index, set value to <code>ENABLED</code>.
     *         </p>
     *         <p>
     *         To delete a backup index, set value to <code>DISABLED</code>.
     * @see Index
     */
    public final Index index() {
        return Index.fromValue(index);
    }

    /**
     * <p>
     * Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * To create a backup index for an eligible <code>ACTIVE</code> recovery point that does not yet have a backup
     * index, set value to <code>ENABLED</code>.
     * </p>
     * <p>
     * To delete a backup index, set value to <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #index} will return
     * {@link Index#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexAsString}.
     * </p>
     * 
     * @return Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.</p>
     *         <p>
     *         To create a backup index for an eligible <code>ACTIVE</code> recovery point that does not yet have a
     *         backup index, set value to <code>ENABLED</code>.
     *         </p>
     *         <p>
     *         To delete a backup index, set value to <code>DISABLED</code>.
     * @see Index
     */
    public final String indexAsString() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecoveryPointIndexSettingsRequest)) {
            return false;
        }
        UpdateRecoveryPointIndexSettingsRequest other = (UpdateRecoveryPointIndexSettingsRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(indexAsString(), other.indexAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRecoveryPointIndexSettingsRequest").add("BackupVaultName", backupVaultName())
                .add("RecoveryPointArn", recoveryPointArn()).add("IamRoleArn", iamRoleArn()).add("Index", indexAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "Index":
            return Optional.ofNullable(clazz.cast(indexAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("backupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("recoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("Index", INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecoveryPointIndexSettingsRequest, T> g) {
        return obj -> g.apply((UpdateRecoveryPointIndexSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRecoveryPointIndexSettingsRequest> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Region where they are created.
         * </p>
         * <p>
         * Accepted characters include lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Region where they are created.</p>
         *        <p>
         *        Accepted characters include lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * An ARN that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * This specifies the IAM role ARN used for this operation.
         * </p>
         * <p>
         * For example, arn:aws:iam::123456789012:role/S3Access
         * </p>
         * 
         * @param iamRoleArn
         *        This specifies the IAM role ARN used for this operation.</p>
         *        <p>
         *        For example, arn:aws:iam::123456789012:role/S3Access
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * <p>
         * To create a backup index for an eligible <code>ACTIVE</code> recovery point that does not yet have a backup
         * index, set value to <code>ENABLED</code>.
         * </p>
         * <p>
         * To delete a backup index, set value to <code>DISABLED</code>.
         * </p>
         * 
         * @param index
         *        Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.</p>
         *        <p>
         *        To create a backup index for an eligible <code>ACTIVE</code> recovery point that does not yet have a
         *        backup index, set value to <code>ENABLED</code>.
         *        </p>
         *        <p>
         *        To delete a backup index, set value to <code>DISABLED</code>.
         * @see Index
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Index
         */
        Builder index(String index);

        /**
         * <p>
         * Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * <p>
         * To create a backup index for an eligible <code>ACTIVE</code> recovery point that does not yet have a backup
         * index, set value to <code>ENABLED</code>.
         * </p>
         * <p>
         * To delete a backup index, set value to <code>DISABLED</code>.
         * </p>
         * 
         * @param index
         *        Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.</p>
         *        <p>
         *        To create a backup index for an eligible <code>ACTIVE</code> recovery point that does not yet have a
         *        backup index, set value to <code>ENABLED</code>.
         *        </p>
         *        <p>
         *        To delete a backup index, set value to <code>DISABLED</code>.
         * @see Index
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Index
         */
        Builder index(Index index);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private String recoveryPointArn;

        private String iamRoleArn;

        private String index;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecoveryPointIndexSettingsRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            recoveryPointArn(model.recoveryPointArn);
            iamRoleArn(model.iamRoleArn);
            index(model.index);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getIndex() {
            return index;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        @Override
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        @Override
        public final Builder index(Index index) {
            this.index(index == null ? null : index.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecoveryPointIndexSettingsRequest build() {
            return new UpdateRecoveryPointIndexSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
