/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a scheduled backup plan execution, including the execution time, rule type, and associated
 * rule identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledPlanExecutionMember implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledPlanExecutionMember.Builder, ScheduledPlanExecutionMember> {
    private static final SdkField<Instant> EXECUTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExecutionTime").getter(getter(ScheduledPlanExecutionMember::executionTime))
            .setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(ScheduledPlanExecutionMember::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<String> RULE_EXECUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleExecutionType").getter(getter(ScheduledPlanExecutionMember::ruleExecutionTypeAsString))
            .setter(setter(Builder::ruleExecutionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleExecutionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_TIME_FIELD,
            RULE_ID_FIELD, RULE_EXECUTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant executionTime;

    private final String ruleId;

    private final String ruleExecutionType;

    private ScheduledPlanExecutionMember(BuilderImpl builder) {
        this.executionTime = builder.executionTime;
        this.ruleId = builder.ruleId;
        this.ruleExecutionType = builder.ruleExecutionType;
    }

    /**
     * <p>
     * The timestamp when the backup is scheduled to run, in Unix format and Coordinated Universal Time (UTC). The value
     * is accurate to milliseconds.
     * </p>
     * 
     * @return The timestamp when the backup is scheduled to run, in Unix format and Coordinated Universal Time (UTC).
     *         The value is accurate to milliseconds.
     */
    public final Instant executionTime() {
        return executionTime;
    }

    /**
     * <p>
     * The unique identifier of the backup rule that will execute at the scheduled time.
     * </p>
     * 
     * @return The unique identifier of the backup rule that will execute at the scheduled time.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The type of backup rule execution. Valid values are <code>CONTINUOUS</code> (point-in-time recovery),
     * <code>SNAPSHOTS</code> (snapshot backups), or <code>CONTINUOUS_AND_SNAPSHOTS</code> (both types combined).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleExecutionType}
     * will return {@link RuleExecutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleExecutionTypeAsString}.
     * </p>
     * 
     * @return The type of backup rule execution. Valid values are <code>CONTINUOUS</code> (point-in-time recovery),
     *         <code>SNAPSHOTS</code> (snapshot backups), or <code>CONTINUOUS_AND_SNAPSHOTS</code> (both types
     *         combined).
     * @see RuleExecutionType
     */
    public final RuleExecutionType ruleExecutionType() {
        return RuleExecutionType.fromValue(ruleExecutionType);
    }

    /**
     * <p>
     * The type of backup rule execution. Valid values are <code>CONTINUOUS</code> (point-in-time recovery),
     * <code>SNAPSHOTS</code> (snapshot backups), or <code>CONTINUOUS_AND_SNAPSHOTS</code> (both types combined).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleExecutionType}
     * will return {@link RuleExecutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleExecutionTypeAsString}.
     * </p>
     * 
     * @return The type of backup rule execution. Valid values are <code>CONTINUOUS</code> (point-in-time recovery),
     *         <code>SNAPSHOTS</code> (snapshot backups), or <code>CONTINUOUS_AND_SNAPSHOTS</code> (both types
     *         combined).
     * @see RuleExecutionType
     */
    public final String ruleExecutionTypeAsString() {
        return ruleExecutionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleExecutionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledPlanExecutionMember)) {
            return false;
        }
        ScheduledPlanExecutionMember other = (ScheduledPlanExecutionMember) obj;
        return Objects.equals(executionTime(), other.executionTime()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(ruleExecutionTypeAsString(), other.ruleExecutionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledPlanExecutionMember").add("ExecutionTime", executionTime()).add("RuleId", ruleId())
                .add("RuleExecutionType", ruleExecutionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "RuleExecutionType":
            return Optional.ofNullable(clazz.cast(ruleExecutionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutionTime", EXECUTION_TIME_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("RuleExecutionType", RULE_EXECUTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledPlanExecutionMember, T> g) {
        return obj -> g.apply((ScheduledPlanExecutionMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledPlanExecutionMember> {
        /**
         * <p>
         * The timestamp when the backup is scheduled to run, in Unix format and Coordinated Universal Time (UTC). The
         * value is accurate to milliseconds.
         * </p>
         * 
         * @param executionTime
         *        The timestamp when the backup is scheduled to run, in Unix format and Coordinated Universal Time
         *        (UTC). The value is accurate to milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Instant executionTime);

        /**
         * <p>
         * The unique identifier of the backup rule that will execute at the scheduled time.
         * </p>
         * 
         * @param ruleId
         *        The unique identifier of the backup rule that will execute at the scheduled time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The type of backup rule execution. Valid values are <code>CONTINUOUS</code> (point-in-time recovery),
         * <code>SNAPSHOTS</code> (snapshot backups), or <code>CONTINUOUS_AND_SNAPSHOTS</code> (both types combined).
         * </p>
         * 
         * @param ruleExecutionType
         *        The type of backup rule execution. Valid values are <code>CONTINUOUS</code> (point-in-time recovery),
         *        <code>SNAPSHOTS</code> (snapshot backups), or <code>CONTINUOUS_AND_SNAPSHOTS</code> (both types
         *        combined).
         * @see RuleExecutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionType
         */
        Builder ruleExecutionType(String ruleExecutionType);

        /**
         * <p>
         * The type of backup rule execution. Valid values are <code>CONTINUOUS</code> (point-in-time recovery),
         * <code>SNAPSHOTS</code> (snapshot backups), or <code>CONTINUOUS_AND_SNAPSHOTS</code> (both types combined).
         * </p>
         * 
         * @param ruleExecutionType
         *        The type of backup rule execution. Valid values are <code>CONTINUOUS</code> (point-in-time recovery),
         *        <code>SNAPSHOTS</code> (snapshot backups), or <code>CONTINUOUS_AND_SNAPSHOTS</code> (both types
         *        combined).
         * @see RuleExecutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionType
         */
        Builder ruleExecutionType(RuleExecutionType ruleExecutionType);
    }

    static final class BuilderImpl implements Builder {
        private Instant executionTime;

        private String ruleId;

        private String ruleExecutionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledPlanExecutionMember model) {
            executionTime(model.executionTime);
            ruleId(model.ruleId);
            ruleExecutionType(model.ruleExecutionType);
        }

        public final Instant getExecutionTime() {
            return executionTime;
        }

        public final void setExecutionTime(Instant executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Instant executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleExecutionType() {
            return ruleExecutionType;
        }

        public final void setRuleExecutionType(String ruleExecutionType) {
            this.ruleExecutionType = ruleExecutionType;
        }

        @Override
        public final Builder ruleExecutionType(String ruleExecutionType) {
            this.ruleExecutionType = ruleExecutionType;
            return this;
        }

        @Override
        public final Builder ruleExecutionType(RuleExecutionType ruleExecutionType) {
            this.ruleExecutionType(ruleExecutionType == null ? null : ruleExecutionType.toString());
            return this;
        }

        @Override
        public ScheduledPlanExecutionMember build() {
            return new ScheduledPlanExecutionMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
