/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRestoreAccessBackupVaultsResponse extends BackupResponse implements
        ToCopyableBuilder<ListRestoreAccessBackupVaultsResponse.Builder, ListRestoreAccessBackupVaultsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRestoreAccessBackupVaultsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RestoreAccessBackupVaultListMember>> RESTORE_ACCESS_BACKUP_VAULTS_FIELD = SdkField
            .<List<RestoreAccessBackupVaultListMember>> builder(MarshallingType.LIST)
            .memberName("RestoreAccessBackupVaults")
            .getter(getter(ListRestoreAccessBackupVaultsResponse::restoreAccessBackupVaults))
            .setter(setter(Builder::restoreAccessBackupVaults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreAccessBackupVaults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RestoreAccessBackupVaultListMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(RestoreAccessBackupVaultListMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESTORE_ACCESS_BACKUP_VAULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults;

    private ListRestoreAccessBackupVaultsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.restoreAccessBackupVaults = builder.restoreAccessBackupVaults;
    }

    /**
     * <p>
     * The pagination token to use in a subsequent request to retrieve the next set of results.
     * </p>
     * 
     * @return The pagination token to use in a subsequent request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestoreAccessBackupVaults property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRestoreAccessBackupVaults() {
        return restoreAccessBackupVaults != null && !(restoreAccessBackupVaults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of restore access backup vaults associated with the specified backup vault.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestoreAccessBackupVaults} method.
     * </p>
     * 
     * @return A list of restore access backup vaults associated with the specified backup vault.
     */
    public final List<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults() {
        return restoreAccessBackupVaults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRestoreAccessBackupVaults() ? restoreAccessBackupVaults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreAccessBackupVaultsResponse)) {
            return false;
        }
        ListRestoreAccessBackupVaultsResponse other = (ListRestoreAccessBackupVaultsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasRestoreAccessBackupVaults() == other.hasRestoreAccessBackupVaults()
                && Objects.equals(restoreAccessBackupVaults(), other.restoreAccessBackupVaults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRestoreAccessBackupVaultsResponse").add("NextToken", nextToken())
                .add("RestoreAccessBackupVaults", hasRestoreAccessBackupVaults() ? restoreAccessBackupVaults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RestoreAccessBackupVaults":
            return Optional.ofNullable(clazz.cast(restoreAccessBackupVaults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RestoreAccessBackupVaults", RESTORE_ACCESS_BACKUP_VAULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreAccessBackupVaultsResponse, T> g) {
        return obj -> g.apply((ListRestoreAccessBackupVaultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRestoreAccessBackupVaultsResponse> {
        /**
         * <p>
         * The pagination token to use in a subsequent request to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use in a subsequent request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of restore access backup vaults associated with the specified backup vault.
         * </p>
         * 
         * @param restoreAccessBackupVaults
         *        A list of restore access backup vaults associated with the specified backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreAccessBackupVaults(Collection<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults);

        /**
         * <p>
         * A list of restore access backup vaults associated with the specified backup vault.
         * </p>
         * 
         * @param restoreAccessBackupVaults
         *        A list of restore access backup vaults associated with the specified backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreAccessBackupVaults(RestoreAccessBackupVaultListMember... restoreAccessBackupVaults);

        /**
         * <p>
         * A list of restore access backup vaults associated with the specified backup vault.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.RestoreAccessBackupVaultListMember.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.backup.model.RestoreAccessBackupVaultListMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.RestoreAccessBackupVaultListMember.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #restoreAccessBackupVaults(List<RestoreAccessBackupVaultListMember>)}.
         * 
         * @param restoreAccessBackupVaults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.RestoreAccessBackupVaultListMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreAccessBackupVaults(java.util.Collection<RestoreAccessBackupVaultListMember>)
         */
        Builder restoreAccessBackupVaults(Consumer<RestoreAccessBackupVaultListMember.Builder>... restoreAccessBackupVaults);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreAccessBackupVaultsResponse model) {
            super(model);
            nextToken(model.nextToken);
            restoreAccessBackupVaults(model.restoreAccessBackupVaults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RestoreAccessBackupVaultListMember.Builder> getRestoreAccessBackupVaults() {
            List<RestoreAccessBackupVaultListMember.Builder> result = RestoreAccessBackupVaultListCopier
                    .copyToBuilder(this.restoreAccessBackupVaults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreAccessBackupVaults(
                Collection<RestoreAccessBackupVaultListMember.BuilderImpl> restoreAccessBackupVaults) {
            this.restoreAccessBackupVaults = RestoreAccessBackupVaultListCopier.copyFromBuilder(restoreAccessBackupVaults);
        }

        @Override
        public final Builder restoreAccessBackupVaults(Collection<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults) {
            this.restoreAccessBackupVaults = RestoreAccessBackupVaultListCopier.copy(restoreAccessBackupVaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreAccessBackupVaults(RestoreAccessBackupVaultListMember... restoreAccessBackupVaults) {
            restoreAccessBackupVaults(Arrays.asList(restoreAccessBackupVaults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreAccessBackupVaults(
                Consumer<RestoreAccessBackupVaultListMember.Builder>... restoreAccessBackupVaults) {
            restoreAccessBackupVaults(Stream.of(restoreAccessBackupVaults)
                    .map(c -> RestoreAccessBackupVaultListMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRestoreAccessBackupVaultsResponse build() {
            return new ListRestoreAccessBackupVaultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
