/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRestoreAccessBackupVaultResponse extends BackupResponse implements
        ToCopyableBuilder<CreateRestoreAccessBackupVaultResponse.Builder, CreateRestoreAccessBackupVaultResponse> {
    private static final SdkField<String> RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RestoreAccessBackupVaultArn")
            .getter(getter(CreateRestoreAccessBackupVaultResponse::restoreAccessBackupVaultArn))
            .setter(setter(Builder::restoreAccessBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreAccessBackupVaultArn")
                    .build()).build();

    private static final SdkField<String> VAULT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultState").getter(getter(CreateRestoreAccessBackupVaultResponse::vaultStateAsString))
            .setter(setter(Builder::vaultState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultState").build()).build();

    private static final SdkField<String> RESTORE_ACCESS_BACKUP_VAULT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RestoreAccessBackupVaultName")
            .getter(getter(CreateRestoreAccessBackupVaultResponse::restoreAccessBackupVaultName))
            .setter(setter(Builder::restoreAccessBackupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreAccessBackupVaultName")
                    .build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(CreateRestoreAccessBackupVaultResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD, VAULT_STATE_FIELD, RESTORE_ACCESS_BACKUP_VAULT_NAME_FIELD,
                    CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restoreAccessBackupVaultArn;

    private final String vaultState;

    private final String restoreAccessBackupVaultName;

    private final Instant creationDate;

    private CreateRestoreAccessBackupVaultResponse(BuilderImpl builder) {
        super(builder);
        this.restoreAccessBackupVaultArn = builder.restoreAccessBackupVaultArn;
        this.vaultState = builder.vaultState;
        this.restoreAccessBackupVaultName = builder.restoreAccessBackupVaultName;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The ARN that uniquely identifies the created restore access backup vault.
     * </p>
     * 
     * @return The ARN that uniquely identifies the created restore access backup vault.
     */
    public final String restoreAccessBackupVaultArn() {
        return restoreAccessBackupVaultArn;
    }

    /**
     * <p>
     * The current state of the restore access backup vault.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultState} will
     * return {@link VaultState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultStateAsString}.
     * </p>
     * 
     * @return The current state of the restore access backup vault.
     * @see VaultState
     */
    public final VaultState vaultState() {
        return VaultState.fromValue(vaultState);
    }

    /**
     * <p>
     * The current state of the restore access backup vault.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultState} will
     * return {@link VaultState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultStateAsString}.
     * </p>
     * 
     * @return The current state of the restore access backup vault.
     * @see VaultState
     */
    public final String vaultStateAsString() {
        return vaultState;
    }

    /**
     * <p>
     * The name of the created restore access backup vault.
     * </p>
     * 
     * @return The name of the created restore access backup vault.
     */
    public final String restoreAccessBackupVaultName() {
        return restoreAccessBackupVaultName;
    }

    /**
     * <p>
     * &gt;The date and time when the restore access backup vault was created, in Unix format and Coordinated Universal
     * Time
     * </p>
     * 
     * @return &gt;The date and time when the restore access backup vault was created, in Unix format and Coordinated
     *         Universal Time
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restoreAccessBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(vaultStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(restoreAccessBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreAccessBackupVaultResponse)) {
            return false;
        }
        CreateRestoreAccessBackupVaultResponse other = (CreateRestoreAccessBackupVaultResponse) obj;
        return Objects.equals(restoreAccessBackupVaultArn(), other.restoreAccessBackupVaultArn())
                && Objects.equals(vaultStateAsString(), other.vaultStateAsString())
                && Objects.equals(restoreAccessBackupVaultName(), other.restoreAccessBackupVaultName())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRestoreAccessBackupVaultResponse")
                .add("RestoreAccessBackupVaultArn", restoreAccessBackupVaultArn()).add("VaultState", vaultStateAsString())
                .add("RestoreAccessBackupVaultName", restoreAccessBackupVaultName()).add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreAccessBackupVaultArn":
            return Optional.ofNullable(clazz.cast(restoreAccessBackupVaultArn()));
        case "VaultState":
            return Optional.ofNullable(clazz.cast(vaultStateAsString()));
        case "RestoreAccessBackupVaultName":
            return Optional.ofNullable(clazz.cast(restoreAccessBackupVaultName()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestoreAccessBackupVaultArn", RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD);
        map.put("VaultState", VAULT_STATE_FIELD);
        map.put("RestoreAccessBackupVaultName", RESTORE_ACCESS_BACKUP_VAULT_NAME_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreAccessBackupVaultResponse, T> g) {
        return obj -> g.apply((CreateRestoreAccessBackupVaultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRestoreAccessBackupVaultResponse> {
        /**
         * <p>
         * The ARN that uniquely identifies the created restore access backup vault.
         * </p>
         * 
         * @param restoreAccessBackupVaultArn
         *        The ARN that uniquely identifies the created restore access backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreAccessBackupVaultArn(String restoreAccessBackupVaultArn);

        /**
         * <p>
         * The current state of the restore access backup vault.
         * </p>
         * 
         * @param vaultState
         *        The current state of the restore access backup vault.
         * @see VaultState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultState
         */
        Builder vaultState(String vaultState);

        /**
         * <p>
         * The current state of the restore access backup vault.
         * </p>
         * 
         * @param vaultState
         *        The current state of the restore access backup vault.
         * @see VaultState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultState
         */
        Builder vaultState(VaultState vaultState);

        /**
         * <p>
         * The name of the created restore access backup vault.
         * </p>
         * 
         * @param restoreAccessBackupVaultName
         *        The name of the created restore access backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreAccessBackupVaultName(String restoreAccessBackupVaultName);

        /**
         * <p>
         * &gt;The date and time when the restore access backup vault was created, in Unix format and Coordinated
         * Universal Time
         * </p>
         * 
         * @param creationDate
         *        &gt;The date and time when the restore access backup vault was created, in Unix format and Coordinated
         *        Universal Time
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String restoreAccessBackupVaultArn;

        private String vaultState;

        private String restoreAccessBackupVaultName;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreAccessBackupVaultResponse model) {
            super(model);
            restoreAccessBackupVaultArn(model.restoreAccessBackupVaultArn);
            vaultState(model.vaultState);
            restoreAccessBackupVaultName(model.restoreAccessBackupVaultName);
            creationDate(model.creationDate);
        }

        public final String getRestoreAccessBackupVaultArn() {
            return restoreAccessBackupVaultArn;
        }

        public final void setRestoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
        }

        @Override
        public final Builder restoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
            return this;
        }

        public final String getVaultState() {
            return vaultState;
        }

        public final void setVaultState(String vaultState) {
            this.vaultState = vaultState;
        }

        @Override
        public final Builder vaultState(String vaultState) {
            this.vaultState = vaultState;
            return this;
        }

        @Override
        public final Builder vaultState(VaultState vaultState) {
            this.vaultState(vaultState == null ? null : vaultState.toString());
            return this;
        }

        public final String getRestoreAccessBackupVaultName() {
            return restoreAccessBackupVaultName;
        }

        public final void setRestoreAccessBackupVaultName(String restoreAccessBackupVaultName) {
            this.restoreAccessBackupVaultName = restoreAccessBackupVaultName;
        }

        @Override
        public final Builder restoreAccessBackupVaultName(String restoreAccessBackupVaultName) {
            this.restoreAccessBackupVaultName = restoreAccessBackupVaultName;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public CreateRestoreAccessBackupVaultResponse build() {
            return new CreateRestoreAccessBackupVaultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
