/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about which resources to include or exclude from a backup plan using their tags. Conditions are
 * case sensitive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Conditions implements SdkPojo, Serializable, ToCopyableBuilder<Conditions.Builder, Conditions> {
    private static final SdkField<List<ConditionParameter>> STRING_EQUALS_FIELD = SdkField
            .<List<ConditionParameter>> builder(MarshallingType.LIST)
            .memberName("StringEquals")
            .getter(getter(Conditions::stringEquals))
            .setter(setter(Builder::stringEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConditionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConditionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConditionParameter>> STRING_NOT_EQUALS_FIELD = SdkField
            .<List<ConditionParameter>> builder(MarshallingType.LIST)
            .memberName("StringNotEquals")
            .getter(getter(Conditions::stringNotEquals))
            .setter(setter(Builder::stringNotEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringNotEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConditionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConditionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConditionParameter>> STRING_LIKE_FIELD = SdkField
            .<List<ConditionParameter>> builder(MarshallingType.LIST)
            .memberName("StringLike")
            .getter(getter(Conditions::stringLike))
            .setter(setter(Builder::stringLike))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringLike").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConditionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConditionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConditionParameter>> STRING_NOT_LIKE_FIELD = SdkField
            .<List<ConditionParameter>> builder(MarshallingType.LIST)
            .memberName("StringNotLike")
            .getter(getter(Conditions::stringNotLike))
            .setter(setter(Builder::stringNotLike))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringNotLike").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConditionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConditionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_EQUALS_FIELD,
            STRING_NOT_EQUALS_FIELD, STRING_LIKE_FIELD, STRING_NOT_LIKE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ConditionParameter> stringEquals;

    private final List<ConditionParameter> stringNotEquals;

    private final List<ConditionParameter> stringLike;

    private final List<ConditionParameter> stringNotLike;

    private Conditions(BuilderImpl builder) {
        this.stringEquals = builder.stringEquals;
        this.stringNotEquals = builder.stringNotEquals;
        this.stringLike = builder.stringLike;
        this.stringNotLike = builder.stringNotLike;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringEquals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringEquals() {
        return stringEquals != null && !(stringEquals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the values of your tagged resources for only those resources that you tagged with the same value. Also
     * called "exact matching."
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringEquals} method.
     * </p>
     * 
     * @return Filters the values of your tagged resources for only those resources that you tagged with the same value.
     *         Also called "exact matching."
     */
    public final List<ConditionParameter> stringEquals() {
        return stringEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringNotEquals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringNotEquals() {
        return stringNotEquals != null && !(stringNotEquals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the values of your tagged resources for only those resources that you tagged that do not have the same
     * value. Also called "negated matching."
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringNotEquals} method.
     * </p>
     * 
     * @return Filters the values of your tagged resources for only those resources that you tagged that do not have the
     *         same value. Also called "negated matching."
     */
    public final List<ConditionParameter> stringNotEquals() {
        return stringNotEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringLike property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStringLike() {
        return stringLike != null && !(stringLike instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the values of your tagged resources for matching tag values with the use of a wildcard character (*)
     * anywhere in the string. For example, "prod*" or "*rod*" matches the tag value "production".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringLike} method.
     * </p>
     * 
     * @return Filters the values of your tagged resources for matching tag values with the use of a wildcard character
     *         (*) anywhere in the string. For example, "prod*" or "*rod*" matches the tag value "production".
     */
    public final List<ConditionParameter> stringLike() {
        return stringLike;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringNotLike property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringNotLike() {
        return stringNotLike != null && !(stringNotLike instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the values of your tagged resources for non-matching tag values with the use of a wildcard character (*)
     * anywhere in the string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringNotLike} method.
     * </p>
     * 
     * @return Filters the values of your tagged resources for non-matching tag values with the use of a wildcard
     *         character (*) anywhere in the string.
     */
    public final List<ConditionParameter> stringNotLike() {
        return stringNotLike;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringEquals() ? stringEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStringNotEquals() ? stringNotEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStringLike() ? stringLike() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStringNotLike() ? stringNotLike() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Conditions)) {
            return false;
        }
        Conditions other = (Conditions) obj;
        return hasStringEquals() == other.hasStringEquals() && Objects.equals(stringEquals(), other.stringEquals())
                && hasStringNotEquals() == other.hasStringNotEquals()
                && Objects.equals(stringNotEquals(), other.stringNotEquals()) && hasStringLike() == other.hasStringLike()
                && Objects.equals(stringLike(), other.stringLike()) && hasStringNotLike() == other.hasStringNotLike()
                && Objects.equals(stringNotLike(), other.stringNotLike());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Conditions").add("StringEquals", hasStringEquals() ? stringEquals() : null)
                .add("StringNotEquals", hasStringNotEquals() ? stringNotEquals() : null)
                .add("StringLike", hasStringLike() ? stringLike() : null)
                .add("StringNotLike", hasStringNotLike() ? stringNotLike() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringEquals":
            return Optional.ofNullable(clazz.cast(stringEquals()));
        case "StringNotEquals":
            return Optional.ofNullable(clazz.cast(stringNotEquals()));
        case "StringLike":
            return Optional.ofNullable(clazz.cast(stringLike()));
        case "StringNotLike":
            return Optional.ofNullable(clazz.cast(stringNotLike()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringEquals", STRING_EQUALS_FIELD);
        map.put("StringNotEquals", STRING_NOT_EQUALS_FIELD);
        map.put("StringLike", STRING_LIKE_FIELD);
        map.put("StringNotLike", STRING_NOT_LIKE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Conditions, T> g) {
        return obj -> g.apply((Conditions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Conditions> {
        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged with the same value.
         * Also called "exact matching."
         * </p>
         * 
         * @param stringEquals
         *        Filters the values of your tagged resources for only those resources that you tagged with the same
         *        value. Also called "exact matching."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringEquals(Collection<ConditionParameter> stringEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged with the same value.
         * Also called "exact matching."
         * </p>
         * 
         * @param stringEquals
         *        Filters the values of your tagged resources for only those resources that you tagged with the same
         *        value. Also called "exact matching."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringEquals(ConditionParameter... stringEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged with the same value.
         * Also called "exact matching."
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backup.model.ConditionParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #stringEquals(List<ConditionParameter>)}.
         * 
         * @param stringEquals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringEquals(java.util.Collection<ConditionParameter>)
         */
        Builder stringEquals(Consumer<ConditionParameter.Builder>... stringEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged that do not have the
         * same value. Also called "negated matching."
         * </p>
         * 
         * @param stringNotEquals
         *        Filters the values of your tagged resources for only those resources that you tagged that do not have
         *        the same value. Also called "negated matching."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringNotEquals(Collection<ConditionParameter> stringNotEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged that do not have the
         * same value. Also called "negated matching."
         * </p>
         * 
         * @param stringNotEquals
         *        Filters the values of your tagged resources for only those resources that you tagged that do not have
         *        the same value. Also called "negated matching."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringNotEquals(ConditionParameter... stringNotEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged that do not have the
         * same value. Also called "negated matching."
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backup.model.ConditionParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #stringNotEquals(List<ConditionParameter>)}.
         * 
         * @param stringNotEquals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringNotEquals(java.util.Collection<ConditionParameter>)
         */
        Builder stringNotEquals(Consumer<ConditionParameter.Builder>... stringNotEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for matching tag values with the use of a wildcard character (*)
         * anywhere in the string. For example, "prod*" or "*rod*" matches the tag value "production".
         * </p>
         * 
         * @param stringLike
         *        Filters the values of your tagged resources for matching tag values with the use of a wildcard
         *        character (*) anywhere in the string. For example, "prod*" or "*rod*" matches the tag value
         *        "production".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringLike(Collection<ConditionParameter> stringLike);

        /**
         * <p>
         * Filters the values of your tagged resources for matching tag values with the use of a wildcard character (*)
         * anywhere in the string. For example, "prod*" or "*rod*" matches the tag value "production".
         * </p>
         * 
         * @param stringLike
         *        Filters the values of your tagged resources for matching tag values with the use of a wildcard
         *        character (*) anywhere in the string. For example, "prod*" or "*rod*" matches the tag value
         *        "production".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringLike(ConditionParameter... stringLike);

        /**
         * <p>
         * Filters the values of your tagged resources for matching tag values with the use of a wildcard character (*)
         * anywhere in the string. For example, "prod*" or "*rod*" matches the tag value "production".
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backup.model.ConditionParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #stringLike(List<ConditionParameter>)}.
         * 
         * @param stringLike
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringLike(java.util.Collection<ConditionParameter>)
         */
        Builder stringLike(Consumer<ConditionParameter.Builder>... stringLike);

        /**
         * <p>
         * Filters the values of your tagged resources for non-matching tag values with the use of a wildcard character
         * (*) anywhere in the string.
         * </p>
         * 
         * @param stringNotLike
         *        Filters the values of your tagged resources for non-matching tag values with the use of a wildcard
         *        character (*) anywhere in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringNotLike(Collection<ConditionParameter> stringNotLike);

        /**
         * <p>
         * Filters the values of your tagged resources for non-matching tag values with the use of a wildcard character
         * (*) anywhere in the string.
         * </p>
         * 
         * @param stringNotLike
         *        Filters the values of your tagged resources for non-matching tag values with the use of a wildcard
         *        character (*) anywhere in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringNotLike(ConditionParameter... stringNotLike);

        /**
         * <p>
         * Filters the values of your tagged resources for non-matching tag values with the use of a wildcard character
         * (*) anywhere in the string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backup.model.ConditionParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #stringNotLike(List<ConditionParameter>)}.
         * 
         * @param stringNotLike
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ConditionParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringNotLike(java.util.Collection<ConditionParameter>)
         */
        Builder stringNotLike(Consumer<ConditionParameter.Builder>... stringNotLike);
    }

    static final class BuilderImpl implements Builder {
        private List<ConditionParameter> stringEquals = DefaultSdkAutoConstructList.getInstance();

        private List<ConditionParameter> stringNotEquals = DefaultSdkAutoConstructList.getInstance();

        private List<ConditionParameter> stringLike = DefaultSdkAutoConstructList.getInstance();

        private List<ConditionParameter> stringNotLike = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Conditions model) {
            stringEquals(model.stringEquals);
            stringNotEquals(model.stringNotEquals);
            stringLike(model.stringLike);
            stringNotLike(model.stringNotLike);
        }

        public final List<ConditionParameter.Builder> getStringEquals() {
            List<ConditionParameter.Builder> result = ConditionParametersCopier.copyToBuilder(this.stringEquals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringEquals(Collection<ConditionParameter.BuilderImpl> stringEquals) {
            this.stringEquals = ConditionParametersCopier.copyFromBuilder(stringEquals);
        }

        @Override
        public final Builder stringEquals(Collection<ConditionParameter> stringEquals) {
            this.stringEquals = ConditionParametersCopier.copy(stringEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringEquals(ConditionParameter... stringEquals) {
            stringEquals(Arrays.asList(stringEquals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringEquals(Consumer<ConditionParameter.Builder>... stringEquals) {
            stringEquals(Stream.of(stringEquals).map(c -> ConditionParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ConditionParameter.Builder> getStringNotEquals() {
            List<ConditionParameter.Builder> result = ConditionParametersCopier.copyToBuilder(this.stringNotEquals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringNotEquals(Collection<ConditionParameter.BuilderImpl> stringNotEquals) {
            this.stringNotEquals = ConditionParametersCopier.copyFromBuilder(stringNotEquals);
        }

        @Override
        public final Builder stringNotEquals(Collection<ConditionParameter> stringNotEquals) {
            this.stringNotEquals = ConditionParametersCopier.copy(stringNotEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringNotEquals(ConditionParameter... stringNotEquals) {
            stringNotEquals(Arrays.asList(stringNotEquals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringNotEquals(Consumer<ConditionParameter.Builder>... stringNotEquals) {
            stringNotEquals(Stream.of(stringNotEquals).map(c -> ConditionParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ConditionParameter.Builder> getStringLike() {
            List<ConditionParameter.Builder> result = ConditionParametersCopier.copyToBuilder(this.stringLike);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringLike(Collection<ConditionParameter.BuilderImpl> stringLike) {
            this.stringLike = ConditionParametersCopier.copyFromBuilder(stringLike);
        }

        @Override
        public final Builder stringLike(Collection<ConditionParameter> stringLike) {
            this.stringLike = ConditionParametersCopier.copy(stringLike);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringLike(ConditionParameter... stringLike) {
            stringLike(Arrays.asList(stringLike));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringLike(Consumer<ConditionParameter.Builder>... stringLike) {
            stringLike(Stream.of(stringLike).map(c -> ConditionParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ConditionParameter.Builder> getStringNotLike() {
            List<ConditionParameter.Builder> result = ConditionParametersCopier.copyToBuilder(this.stringNotLike);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringNotLike(Collection<ConditionParameter.BuilderImpl> stringNotLike) {
            this.stringNotLike = ConditionParametersCopier.copyFromBuilder(stringNotLike);
        }

        @Override
        public final Builder stringNotLike(Collection<ConditionParameter> stringNotLike) {
            this.stringNotLike = ConditionParametersCopier.copy(stringNotLike);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringNotLike(ConditionParameter... stringNotLike) {
            stringNotLike(Arrays.asList(stringNotLike));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringNotLike(Consumer<ConditionParameter.Builder>... stringNotLike) {
            stringNotLike(Stream.of(stringNotLike).map(c -> ConditionParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Conditions build() {
            return new Conditions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
