/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScalingPlanRequest extends AutoScalingPlansRequest implements
        ToCopyableBuilder<CreateScalingPlanRequest.Builder, CreateScalingPlanRequest> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingPlanName").getter(getter(CreateScalingPlanRequest::scalingPlanName))
            .setter(setter(Builder::scalingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()).build();

    private static final SdkField<ApplicationSource> APPLICATION_SOURCE_FIELD = SdkField
            .<ApplicationSource> builder(MarshallingType.SDK_POJO).memberName("ApplicationSource")
            .getter(getter(CreateScalingPlanRequest::applicationSource)).setter(setter(Builder::applicationSource))
            .constructor(ApplicationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSource").build()).build();

    private static final SdkField<List<ScalingInstruction>> SCALING_INSTRUCTIONS_FIELD = SdkField
            .<List<ScalingInstruction>> builder(MarshallingType.LIST)
            .memberName("ScalingInstructions")
            .getter(getter(CreateScalingPlanRequest::scalingInstructions))
            .setter(setter(Builder::scalingInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingInstructions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalingInstruction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalingInstruction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD,
            APPLICATION_SOURCE_FIELD, SCALING_INSTRUCTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scalingPlanName;

    private final ApplicationSource applicationSource;

    private final List<ScalingInstruction> scalingInstructions;

    private CreateScalingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.scalingPlanName = builder.scalingPlanName;
        this.applicationSource = builder.applicationSource;
        this.scalingInstructions = builder.scalingInstructions;
    }

    /**
     * <p>
     * The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     * </p>
     * 
     * @return The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     */
    public final String scalingPlanName() {
        return scalingPlanName;
    }

    /**
     * <p>
     * A CloudFormation stack or set of tags. You can create one scaling plan per application source.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html"
     * >ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.
     * </p>
     * 
     * @return A CloudFormation stack or set of tags. You can create one scaling plan per application source.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html"
     *         >ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.
     */
    public final ApplicationSource applicationSource() {
        return applicationSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScalingInstructions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScalingInstructions() {
        return scalingInstructions != null && !(scalingInstructions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scaling instructions.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html"
     * >ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalingInstructions} method.
     * </p>
     * 
     * @return The scaling instructions.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html"
     *         >ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.
     */
    public final List<ScalingInstruction> scalingInstructions() {
        return scalingInstructions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingInstructions() ? scalingInstructions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScalingPlanRequest)) {
            return false;
        }
        CreateScalingPlanRequest other = (CreateScalingPlanRequest) obj;
        return Objects.equals(scalingPlanName(), other.scalingPlanName())
                && Objects.equals(applicationSource(), other.applicationSource())
                && hasScalingInstructions() == other.hasScalingInstructions()
                && Objects.equals(scalingInstructions(), other.scalingInstructions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScalingPlanRequest").add("ScalingPlanName", scalingPlanName())
                .add("ApplicationSource", applicationSource())
                .add("ScalingInstructions", hasScalingInstructions() ? scalingInstructions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPlanName":
            return Optional.ofNullable(clazz.cast(scalingPlanName()));
        case "ApplicationSource":
            return Optional.ofNullable(clazz.cast(applicationSource()));
        case "ScalingInstructions":
            return Optional.ofNullable(clazz.cast(scalingInstructions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScalingPlanName", SCALING_PLAN_NAME_FIELD);
        map.put("ApplicationSource", APPLICATION_SOURCE_FIELD);
        map.put("ScalingInstructions", SCALING_INSTRUCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScalingPlanRequest, T> g) {
        return obj -> g.apply((CreateScalingPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AutoScalingPlansRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateScalingPlanRequest> {
        /**
         * <p>
         * The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
         * </p>
         * 
         * @param scalingPlanName
         *        The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanName(String scalingPlanName);

        /**
         * <p>
         * A CloudFormation stack or set of tags. You can create one scaling plan per application source.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html"
         * >ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.
         * </p>
         * 
         * @param applicationSource
         *        A CloudFormation stack or set of tags. You can create one scaling plan per application source.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html"
         *        >ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSource(ApplicationSource applicationSource);

        /**
         * <p>
         * A CloudFormation stack or set of tags. You can create one scaling plan per application source.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html"
         * >ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationSource.Builder} avoiding the
         * need to create one manually via {@link ApplicationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSource.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationSource(ApplicationSource)}.
         * 
         * @param applicationSource
         *        a consumer that will call methods on {@link ApplicationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSource(ApplicationSource)
         */
        default Builder applicationSource(Consumer<ApplicationSource.Builder> applicationSource) {
            return applicationSource(ApplicationSource.builder().applyMutation(applicationSource).build());
        }

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html"
         * >ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.
         * </p>
         * 
         * @param scalingInstructions
         *        The scaling instructions.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html"
         *        >ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions);

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html"
         * >ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.
         * </p>
         * 
         * @param scalingInstructions
         *        The scaling instructions.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html"
         *        >ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingInstructions(ScalingInstruction... scalingInstructions);

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html"
         * >ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingInstructions(List<ScalingInstruction>)}.
         * 
         * @param scalingInstructions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingInstructions(java.util.Collection<ScalingInstruction>)
         */
        Builder scalingInstructions(Consumer<ScalingInstruction.Builder>... scalingInstructions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingPlansRequest.BuilderImpl implements Builder {
        private String scalingPlanName;

        private ApplicationSource applicationSource;

        private List<ScalingInstruction> scalingInstructions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScalingPlanRequest model) {
            super(model);
            scalingPlanName(model.scalingPlanName);
            applicationSource(model.applicationSource);
            scalingInstructions(model.scalingInstructions);
        }

        public final String getScalingPlanName() {
            return scalingPlanName;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final ApplicationSource.Builder getApplicationSource() {
            return applicationSource != null ? applicationSource.toBuilder() : null;
        }

        public final void setApplicationSource(ApplicationSource.BuilderImpl applicationSource) {
            this.applicationSource = applicationSource != null ? applicationSource.build() : null;
        }

        @Override
        public final Builder applicationSource(ApplicationSource applicationSource) {
            this.applicationSource = applicationSource;
            return this;
        }

        public final List<ScalingInstruction.Builder> getScalingInstructions() {
            List<ScalingInstruction.Builder> result = ScalingInstructionsCopier.copyToBuilder(this.scalingInstructions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingInstructions(Collection<ScalingInstruction.BuilderImpl> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copyFromBuilder(scalingInstructions);
        }

        @Override
        public final Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copy(scalingInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(ScalingInstruction... scalingInstructions) {
            scalingInstructions(Arrays.asList(scalingInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(Consumer<ScalingInstruction.Builder>... scalingInstructions) {
            scalingInstructions(Stream.of(scalingInstructions).map(c -> ScalingInstruction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScalingPlanRequest build() {
            return new CreateScalingPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
