/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines the CloudWatch metric to return, along with the statistic and unit.
 * </p>
 * <p>
 * For more information about the CloudWatch terminology below, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch
 * concepts</a> in the <i>Amazon CloudWatch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingMetricStat implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingMetricStat.Builder, TargetTrackingMetricStat> {
    private static final SdkField<Metric> METRIC_FIELD = SdkField.<Metric> builder(MarshallingType.SDK_POJO).memberName("Metric")
            .getter(getter(TargetTrackingMetricStat::metric)).setter(setter(Builder::metric)).constructor(Metric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<String> STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stat")
            .getter(getter(TargetTrackingMetricStat::stat)).setter(setter(Builder::stat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(TargetTrackingMetricStat::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(TargetTrackingMetricStat::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, STAT_FIELD,
            UNIT_FIELD, PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Metric metric;

    private final String stat;

    private final String unit;

    private final Integer period;

    private TargetTrackingMetricStat(BuilderImpl builder) {
        this.metric = builder.metric;
        this.stat = builder.stat;
        this.unit = builder.unit;
        this.period = builder.period;
    }

    /**
     * <p>
     * The metric to use.
     * </p>
     * 
     * @return The metric to use.
     */
    public final Metric metric() {
        return metric;
    }

    /**
     * <p>
     * The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid
     * values, see the table in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * The most commonly used metric for scaling is <code>Average</code>.
     * </p>
     * 
     * @return The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of
     *         valid values, see the table in <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     *         >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
     *         <p>
     *         The most commonly used metric for scaling is <code>Average</code>.
     */
    public final String stat() {
        return stat;
    }

    /**
     * <p>
     * The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a>
     * data type in the <i>Amazon CloudWatch API Reference</i>.
     * </p>
     * 
     * @return The unit to use for the returned data points. For a complete list of the units that CloudWatch supports,
     *         see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">
     *         MetricDatum</a> data type in the <i>Amazon CloudWatch API Reference</i>.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high
     * resolution metric, set the value to less than 60. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html">Create
     * a target tracking policy using high-resolution metrics for faster response</a>.
     * </p>
     * 
     * @return The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For
     *         high resolution metric, set the value to less than 60. For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html"
     *         >Create a target tracking policy using high-resolution metrics for faster response</a>.
     */
    public final Integer period() {
        return period;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(stat());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingMetricStat)) {
            return false;
        }
        TargetTrackingMetricStat other = (TargetTrackingMetricStat) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(stat(), other.stat())
                && Objects.equals(unit(), other.unit()) && Objects.equals(period(), other.period());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetTrackingMetricStat").add("Metric", metric()).add("Stat", stat()).add("Unit", unit())
                .add("Period", period()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Stat":
            return Optional.ofNullable(clazz.cast(stat()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metric", METRIC_FIELD);
        map.put("Stat", STAT_FIELD);
        map.put("Unit", UNIT_FIELD);
        map.put("Period", PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingMetricStat, T> g) {
        return obj -> g.apply((TargetTrackingMetricStat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingMetricStat> {
        /**
         * <p>
         * The metric to use.
         * </p>
         * 
         * @param metric
         *        The metric to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(Metric metric);

        /**
         * <p>
         * The metric to use.
         * </p>
         * This is a convenience method that creates an instance of the {@link Metric.Builder} avoiding the need to
         * create one manually via {@link Metric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Metric.Builder#build()} is called immediately and its result is
         * passed to {@link #metric(Metric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link Metric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(Metric)
         */
        default Builder metric(Consumer<Metric.Builder> metric) {
            return metric(Metric.builder().applyMutation(metric).build());
        }

        /**
         * <p>
         * The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid
         * values, see the table in <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * <p>
         * The most commonly used metric for scaling is <code>Average</code>.
         * </p>
         * 
         * @param stat
         *        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of
         *        valid values, see the table in <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         *        >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
         *        <p>
         *        The most commonly used metric for scaling is <code>Average</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stat(String stat);

        /**
         * <p>
         * The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see
         * the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a>
         * data type in the <i>Amazon CloudWatch API Reference</i>.
         * </p>
         * 
         * @param unit
         *        The unit to use for the returned data points. For a complete list of the units that CloudWatch
         *        supports, see the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
         *        >MetricDatum</a> data type in the <i>Amazon CloudWatch API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For high
         * resolution metric, set the value to less than 60. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html"
         * >Create a target tracking policy using high-resolution metrics for faster response</a>.
         * </p>
         * 
         * @param period
         *        The period of the metric in seconds. The default value is 60. Accepted values are 10, 30, and 60. For
         *        high resolution metric, set the value to less than 60. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/policy-creating-high-resolution-metrics.html"
         *        >Create a target tracking policy using high-resolution metrics for faster response</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);
    }

    static final class BuilderImpl implements Builder {
        private Metric metric;

        private String stat;

        private String unit;

        private Integer period;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingMetricStat model) {
            metric(model.metric);
            stat(model.stat);
            unit(model.unit);
            period(model.period);
        }

        public final Metric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(Metric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public final String getStat() {
            return stat;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        @Override
        public TargetTrackingMetricStat build() {
            return new TargetTrackingMetricStat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
