/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an instance refresh rollback.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RollbackDetails implements SdkPojo, Serializable, ToCopyableBuilder<RollbackDetails.Builder, RollbackDetails> {
    private static final SdkField<String> ROLLBACK_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RollbackReason").getter(getter(RollbackDetails::rollbackReason)).setter(setter(Builder::rollbackReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackReason").build()).build();

    private static final SdkField<Instant> ROLLBACK_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RollbackStartTime").getter(getter(RollbackDetails::rollbackStartTime))
            .setter(setter(Builder::rollbackStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackStartTime").build()).build();

    private static final SdkField<Integer> PERCENTAGE_COMPLETE_ON_ROLLBACK_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentageCompleteOnRollback")
            .getter(getter(RollbackDetails::percentageCompleteOnRollback))
            .setter(setter(Builder::percentageCompleteOnRollback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageCompleteOnRollback")
                    .build()).build();

    private static final SdkField<Integer> INSTANCES_TO_UPDATE_ON_ROLLBACK_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstancesToUpdateOnRollback")
            .getter(getter(RollbackDetails::instancesToUpdateOnRollback))
            .setter(setter(Builder::instancesToUpdateOnRollback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToUpdateOnRollback")
                    .build()).build();

    private static final SdkField<InstanceRefreshProgressDetails> PROGRESS_DETAILS_ON_ROLLBACK_FIELD = SdkField
            .<InstanceRefreshProgressDetails> builder(MarshallingType.SDK_POJO).memberName("ProgressDetailsOnRollback")
            .getter(getter(RollbackDetails::progressDetailsOnRollback)).setter(setter(Builder::progressDetailsOnRollback))
            .constructor(InstanceRefreshProgressDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressDetailsOnRollback").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLBACK_REASON_FIELD,
            ROLLBACK_START_TIME_FIELD, PERCENTAGE_COMPLETE_ON_ROLLBACK_FIELD, INSTANCES_TO_UPDATE_ON_ROLLBACK_FIELD,
            PROGRESS_DETAILS_ON_ROLLBACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String rollbackReason;

    private final Instant rollbackStartTime;

    private final Integer percentageCompleteOnRollback;

    private final Integer instancesToUpdateOnRollback;

    private final InstanceRefreshProgressDetails progressDetailsOnRollback;

    private RollbackDetails(BuilderImpl builder) {
        this.rollbackReason = builder.rollbackReason;
        this.rollbackStartTime = builder.rollbackStartTime;
        this.percentageCompleteOnRollback = builder.percentageCompleteOnRollback;
        this.instancesToUpdateOnRollback = builder.instancesToUpdateOnRollback;
        this.progressDetailsOnRollback = builder.progressDetailsOnRollback;
    }

    /**
     * <p>
     * The reason for this instance refresh rollback (for example, whether a manual or automatic rollback was
     * initiated).
     * </p>
     * 
     * @return The reason for this instance refresh rollback (for example, whether a manual or automatic rollback was
     *         initiated).
     */
    public final String rollbackReason() {
        return rollbackReason;
    }

    /**
     * <p>
     * The date and time at which the rollback began.
     * </p>
     * 
     * @return The date and time at which the rollback began.
     */
    public final Instant rollbackStartTime() {
        return rollbackStartTime;
    }

    /**
     * <p>
     * Indicates the value of <code>PercentageComplete</code> at the time the rollback started.
     * </p>
     * 
     * @return Indicates the value of <code>PercentageComplete</code> at the time the rollback started.
     */
    public final Integer percentageCompleteOnRollback() {
        return percentageCompleteOnRollback;
    }

    /**
     * <p>
     * Indicates the value of <code>InstancesToUpdate</code> at the time the rollback started.
     * </p>
     * 
     * @return Indicates the value of <code>InstancesToUpdate</code> at the time the rollback started.
     */
    public final Integer instancesToUpdateOnRollback() {
        return instancesToUpdateOnRollback;
    }

    /**
     * <p>
     * Reports progress on replacing instances in an Auto Scaling group that has a warm pool. This includes separate
     * details for instances in the warm pool and instances in the Auto Scaling group (the live pool).
     * </p>
     * 
     * @return Reports progress on replacing instances in an Auto Scaling group that has a warm pool. This includes
     *         separate details for instances in the warm pool and instances in the Auto Scaling group (the live pool).
     */
    public final InstanceRefreshProgressDetails progressDetailsOnRollback() {
        return progressDetailsOnRollback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rollbackReason());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(percentageCompleteOnRollback());
        hashCode = 31 * hashCode + Objects.hashCode(instancesToUpdateOnRollback());
        hashCode = 31 * hashCode + Objects.hashCode(progressDetailsOnRollback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackDetails)) {
            return false;
        }
        RollbackDetails other = (RollbackDetails) obj;
        return Objects.equals(rollbackReason(), other.rollbackReason())
                && Objects.equals(rollbackStartTime(), other.rollbackStartTime())
                && Objects.equals(percentageCompleteOnRollback(), other.percentageCompleteOnRollback())
                && Objects.equals(instancesToUpdateOnRollback(), other.instancesToUpdateOnRollback())
                && Objects.equals(progressDetailsOnRollback(), other.progressDetailsOnRollback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RollbackDetails").add("RollbackReason", rollbackReason())
                .add("RollbackStartTime", rollbackStartTime())
                .add("PercentageCompleteOnRollback", percentageCompleteOnRollback())
                .add("InstancesToUpdateOnRollback", instancesToUpdateOnRollback())
                .add("ProgressDetailsOnRollback", progressDetailsOnRollback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RollbackReason":
            return Optional.ofNullable(clazz.cast(rollbackReason()));
        case "RollbackStartTime":
            return Optional.ofNullable(clazz.cast(rollbackStartTime()));
        case "PercentageCompleteOnRollback":
            return Optional.ofNullable(clazz.cast(percentageCompleteOnRollback()));
        case "InstancesToUpdateOnRollback":
            return Optional.ofNullable(clazz.cast(instancesToUpdateOnRollback()));
        case "ProgressDetailsOnRollback":
            return Optional.ofNullable(clazz.cast(progressDetailsOnRollback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RollbackReason", ROLLBACK_REASON_FIELD);
        map.put("RollbackStartTime", ROLLBACK_START_TIME_FIELD);
        map.put("PercentageCompleteOnRollback", PERCENTAGE_COMPLETE_ON_ROLLBACK_FIELD);
        map.put("InstancesToUpdateOnRollback", INSTANCES_TO_UPDATE_ON_ROLLBACK_FIELD);
        map.put("ProgressDetailsOnRollback", PROGRESS_DETAILS_ON_ROLLBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RollbackDetails, T> g) {
        return obj -> g.apply((RollbackDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RollbackDetails> {
        /**
         * <p>
         * The reason for this instance refresh rollback (for example, whether a manual or automatic rollback was
         * initiated).
         * </p>
         * 
         * @param rollbackReason
         *        The reason for this instance refresh rollback (for example, whether a manual or automatic rollback was
         *        initiated).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackReason(String rollbackReason);

        /**
         * <p>
         * The date and time at which the rollback began.
         * </p>
         * 
         * @param rollbackStartTime
         *        The date and time at which the rollback began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackStartTime(Instant rollbackStartTime);

        /**
         * <p>
         * Indicates the value of <code>PercentageComplete</code> at the time the rollback started.
         * </p>
         * 
         * @param percentageCompleteOnRollback
         *        Indicates the value of <code>PercentageComplete</code> at the time the rollback started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageCompleteOnRollback(Integer percentageCompleteOnRollback);

        /**
         * <p>
         * Indicates the value of <code>InstancesToUpdate</code> at the time the rollback started.
         * </p>
         * 
         * @param instancesToUpdateOnRollback
         *        Indicates the value of <code>InstancesToUpdate</code> at the time the rollback started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesToUpdateOnRollback(Integer instancesToUpdateOnRollback);

        /**
         * <p>
         * Reports progress on replacing instances in an Auto Scaling group that has a warm pool. This includes separate
         * details for instances in the warm pool and instances in the Auto Scaling group (the live pool).
         * </p>
         * 
         * @param progressDetailsOnRollback
         *        Reports progress on replacing instances in an Auto Scaling group that has a warm pool. This includes
         *        separate details for instances in the warm pool and instances in the Auto Scaling group (the live
         *        pool).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressDetailsOnRollback(InstanceRefreshProgressDetails progressDetailsOnRollback);

        /**
         * <p>
         * Reports progress on replacing instances in an Auto Scaling group that has a warm pool. This includes separate
         * details for instances in the warm pool and instances in the Auto Scaling group (the live pool).
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceRefreshProgressDetails.Builder}
         * avoiding the need to create one manually via {@link InstanceRefreshProgressDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRefreshProgressDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #progressDetailsOnRollback(InstanceRefreshProgressDetails)}.
         * 
         * @param progressDetailsOnRollback
         *        a consumer that will call methods on {@link InstanceRefreshProgressDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressDetailsOnRollback(InstanceRefreshProgressDetails)
         */
        default Builder progressDetailsOnRollback(Consumer<InstanceRefreshProgressDetails.Builder> progressDetailsOnRollback) {
            return progressDetailsOnRollback(InstanceRefreshProgressDetails.builder().applyMutation(progressDetailsOnRollback)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String rollbackReason;

        private Instant rollbackStartTime;

        private Integer percentageCompleteOnRollback;

        private Integer instancesToUpdateOnRollback;

        private InstanceRefreshProgressDetails progressDetailsOnRollback;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackDetails model) {
            rollbackReason(model.rollbackReason);
            rollbackStartTime(model.rollbackStartTime);
            percentageCompleteOnRollback(model.percentageCompleteOnRollback);
            instancesToUpdateOnRollback(model.instancesToUpdateOnRollback);
            progressDetailsOnRollback(model.progressDetailsOnRollback);
        }

        public final String getRollbackReason() {
            return rollbackReason;
        }

        public final void setRollbackReason(String rollbackReason) {
            this.rollbackReason = rollbackReason;
        }

        @Override
        public final Builder rollbackReason(String rollbackReason) {
            this.rollbackReason = rollbackReason;
            return this;
        }

        public final Instant getRollbackStartTime() {
            return rollbackStartTime;
        }

        public final void setRollbackStartTime(Instant rollbackStartTime) {
            this.rollbackStartTime = rollbackStartTime;
        }

        @Override
        public final Builder rollbackStartTime(Instant rollbackStartTime) {
            this.rollbackStartTime = rollbackStartTime;
            return this;
        }

        public final Integer getPercentageCompleteOnRollback() {
            return percentageCompleteOnRollback;
        }

        public final void setPercentageCompleteOnRollback(Integer percentageCompleteOnRollback) {
            this.percentageCompleteOnRollback = percentageCompleteOnRollback;
        }

        @Override
        public final Builder percentageCompleteOnRollback(Integer percentageCompleteOnRollback) {
            this.percentageCompleteOnRollback = percentageCompleteOnRollback;
            return this;
        }

        public final Integer getInstancesToUpdateOnRollback() {
            return instancesToUpdateOnRollback;
        }

        public final void setInstancesToUpdateOnRollback(Integer instancesToUpdateOnRollback) {
            this.instancesToUpdateOnRollback = instancesToUpdateOnRollback;
        }

        @Override
        public final Builder instancesToUpdateOnRollback(Integer instancesToUpdateOnRollback) {
            this.instancesToUpdateOnRollback = instancesToUpdateOnRollback;
            return this;
        }

        public final InstanceRefreshProgressDetails.Builder getProgressDetailsOnRollback() {
            return progressDetailsOnRollback != null ? progressDetailsOnRollback.toBuilder() : null;
        }

        public final void setProgressDetailsOnRollback(InstanceRefreshProgressDetails.BuilderImpl progressDetailsOnRollback) {
            this.progressDetailsOnRollback = progressDetailsOnRollback != null ? progressDetailsOnRollback.build() : null;
        }

        @Override
        public final Builder progressDetailsOnRollback(InstanceRefreshProgressDetails progressDetailsOnRollback) {
            this.progressDetailsOnRollback = progressDetailsOnRollback;
            return this;
        }

        @Override
        public RollbackDetails build() {
            return new RollbackDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
