/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics such as input rows and bytes read by the query, rows and bytes output by the query, and the number of rows
 * written by the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryRuntimeStatisticsRows implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryRuntimeStatisticsRows.Builder, QueryRuntimeStatisticsRows> {
    private static final SdkField<Long> INPUT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("InputRows")
            .getter(getter(QueryRuntimeStatisticsRows::inputRows)).setter(setter(Builder::inputRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputRows").build()).build();

    private static final SdkField<Long> INPUT_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("InputBytes").getter(getter(QueryRuntimeStatisticsRows::inputBytes)).setter(setter(Builder::inputBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputBytes").build()).build();

    private static final SdkField<Long> OUTPUT_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OutputBytes").getter(getter(QueryRuntimeStatisticsRows::outputBytes))
            .setter(setter(Builder::outputBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBytes").build()).build();

    private static final SdkField<Long> OUTPUT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OutputRows").getter(getter(QueryRuntimeStatisticsRows::outputRows)).setter(setter(Builder::outputRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputRows").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ROWS_FIELD,
            INPUT_BYTES_FIELD, OUTPUT_BYTES_FIELD, OUTPUT_ROWS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long inputRows;

    private final Long inputBytes;

    private final Long outputBytes;

    private final Long outputRows;

    private QueryRuntimeStatisticsRows(BuilderImpl builder) {
        this.inputRows = builder.inputRows;
        this.inputBytes = builder.inputBytes;
        this.outputBytes = builder.outputBytes;
        this.outputRows = builder.outputRows;
    }

    /**
     * <p>
     * The number of rows read to execute the query.
     * </p>
     * 
     * @return The number of rows read to execute the query.
     */
    public final Long inputRows() {
        return inputRows;
    }

    /**
     * <p>
     * The number of bytes read to execute the query.
     * </p>
     * 
     * @return The number of bytes read to execute the query.
     */
    public final Long inputBytes() {
        return inputBytes;
    }

    /**
     * <p>
     * The number of bytes returned by the query.
     * </p>
     * 
     * @return The number of bytes returned by the query.
     */
    public final Long outputBytes() {
        return outputBytes;
    }

    /**
     * <p>
     * The number of rows returned by the query.
     * </p>
     * 
     * @return The number of rows returned by the query.
     */
    public final Long outputRows() {
        return outputRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputRows());
        hashCode = 31 * hashCode + Objects.hashCode(inputBytes());
        hashCode = 31 * hashCode + Objects.hashCode(outputBytes());
        hashCode = 31 * hashCode + Objects.hashCode(outputRows());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRuntimeStatisticsRows)) {
            return false;
        }
        QueryRuntimeStatisticsRows other = (QueryRuntimeStatisticsRows) obj;
        return Objects.equals(inputRows(), other.inputRows()) && Objects.equals(inputBytes(), other.inputBytes())
                && Objects.equals(outputBytes(), other.outputBytes()) && Objects.equals(outputRows(), other.outputRows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryRuntimeStatisticsRows").add("InputRows", inputRows()).add("InputBytes", inputBytes())
                .add("OutputBytes", outputBytes()).add("OutputRows", outputRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputRows":
            return Optional.ofNullable(clazz.cast(inputRows()));
        case "InputBytes":
            return Optional.ofNullable(clazz.cast(inputBytes()));
        case "OutputBytes":
            return Optional.ofNullable(clazz.cast(outputBytes()));
        case "OutputRows":
            return Optional.ofNullable(clazz.cast(outputRows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InputRows", INPUT_ROWS_FIELD);
        map.put("InputBytes", INPUT_BYTES_FIELD);
        map.put("OutputBytes", OUTPUT_BYTES_FIELD);
        map.put("OutputRows", OUTPUT_ROWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryRuntimeStatisticsRows, T> g) {
        return obj -> g.apply((QueryRuntimeStatisticsRows) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryRuntimeStatisticsRows> {
        /**
         * <p>
         * The number of rows read to execute the query.
         * </p>
         * 
         * @param inputRows
         *        The number of rows read to execute the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRows(Long inputRows);

        /**
         * <p>
         * The number of bytes read to execute the query.
         * </p>
         * 
         * @param inputBytes
         *        The number of bytes read to execute the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputBytes(Long inputBytes);

        /**
         * <p>
         * The number of bytes returned by the query.
         * </p>
         * 
         * @param outputBytes
         *        The number of bytes returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBytes(Long outputBytes);

        /**
         * <p>
         * The number of rows returned by the query.
         * </p>
         * 
         * @param outputRows
         *        The number of rows returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputRows(Long outputRows);
    }

    static final class BuilderImpl implements Builder {
        private Long inputRows;

        private Long inputBytes;

        private Long outputBytes;

        private Long outputRows;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRuntimeStatisticsRows model) {
            inputRows(model.inputRows);
            inputBytes(model.inputBytes);
            outputBytes(model.outputBytes);
            outputRows(model.outputRows);
        }

        public final Long getInputRows() {
            return inputRows;
        }

        public final void setInputRows(Long inputRows) {
            this.inputRows = inputRows;
        }

        @Override
        public final Builder inputRows(Long inputRows) {
            this.inputRows = inputRows;
            return this;
        }

        public final Long getInputBytes() {
            return inputBytes;
        }

        public final void setInputBytes(Long inputBytes) {
            this.inputBytes = inputBytes;
        }

        @Override
        public final Builder inputBytes(Long inputBytes) {
            this.inputBytes = inputBytes;
            return this;
        }

        public final Long getOutputBytes() {
            return outputBytes;
        }

        public final void setOutputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
        }

        @Override
        public final Builder outputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
            return this;
        }

        public final Long getOutputRows() {
            return outputRows;
        }

        public final void setOutputRows(Long outputRows) {
            this.outputRows = outputRows;
        }

        @Override
        public final Builder outputRows(Long outputRows) {
            this.outputRows = outputRows;
            return this;
        }

        @Override
        public QueryRuntimeStatisticsRows build() {
            return new QueryRuntimeStatisticsRows(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
