/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExecutorsRequest extends AthenaRequest implements
        ToCopyableBuilder<ListExecutorsRequest.Builder, ListExecutorsRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(ListExecutorsRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> EXECUTOR_STATE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutorStateFilter").getter(getter(ListExecutorsRequest::executorStateFilterAsString))
            .setter(setter(Builder::executorStateFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorStateFilter").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListExecutorsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListExecutorsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            EXECUTOR_STATE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String executorStateFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListExecutorsRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.executorStateFilter = builder.executorStateFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * A filter for a specific executor state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The executor is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The executor has been started.
     * </p>
     * <p>
     * <code>REGISTERED</code> - The executor has been registered.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The executor is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The executor is no longer running.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the executor is no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executorStateFilter} will return {@link ExecutorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #executorStateFilterAsString}.
     * </p>
     * 
     * @return A filter for a specific executor state. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The executor is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The executor has been started.
     *         </p>
     *         <p>
     *         <code>REGISTERED</code> - The executor has been registered.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The executor is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The executor is no longer running.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the executor is no longer running.
     * @see ExecutorState
     */
    public final ExecutorState executorStateFilter() {
        return ExecutorState.fromValue(executorStateFilter);
    }

    /**
     * <p>
     * A filter for a specific executor state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The executor is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The executor has been started.
     * </p>
     * <p>
     * <code>REGISTERED</code> - The executor has been registered.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The executor is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The executor is no longer running.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the executor is no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executorStateFilter} will return {@link ExecutorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #executorStateFilterAsString}.
     * </p>
     * 
     * @return A filter for a specific executor state. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The executor is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The executor has been started.
     *         </p>
     *         <p>
     *         <code>REGISTERED</code> - The executor has been registered.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The executor is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The executor is no longer running.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the executor is no longer running.
     * @see ExecutorState
     */
    public final String executorStateFilterAsString() {
        return executorStateFilter;
    }

    /**
     * <p>
     * The maximum number of executors to return.
     * </p>
     * 
     * @return The maximum number of executors to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(executorStateFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutorsRequest)) {
            return false;
        }
        ListExecutorsRequest other = (ListExecutorsRequest) obj;
        return Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(executorStateFilterAsString(), other.executorStateFilterAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExecutorsRequest").add("SessionId", sessionId())
                .add("ExecutorStateFilter", executorStateFilterAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "ExecutorStateFilter":
            return Optional.ofNullable(clazz.cast(executorStateFilterAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("ExecutorStateFilter", EXECUTOR_STATE_FILTER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExecutorsRequest, T> g) {
        return obj -> g.apply((ListExecutorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListExecutorsRequest> {
        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * A filter for a specific executor state. A description of each state follows.
         * </p>
         * <p>
         * <code>CREATING</code> - The executor is being started, including acquiring resources.
         * </p>
         * <p>
         * <code>CREATED</code> - The executor has been started.
         * </p>
         * <p>
         * <code>REGISTERED</code> - The executor has been registered.
         * </p>
         * <p>
         * <code>TERMINATING</code> - The executor is in the process of shutting down.
         * </p>
         * <p>
         * <code>TERMINATED</code> - The executor is no longer running.
         * </p>
         * <p>
         * <code>FAILED</code> - Due to a failure, the executor is no longer running.
         * </p>
         * 
         * @param executorStateFilter
         *        A filter for a specific executor state. A description of each state follows.</p>
         *        <p>
         *        <code>CREATING</code> - The executor is being started, including acquiring resources.
         *        </p>
         *        <p>
         *        <code>CREATED</code> - The executor has been started.
         *        </p>
         *        <p>
         *        <code>REGISTERED</code> - The executor has been registered.
         *        </p>
         *        <p>
         *        <code>TERMINATING</code> - The executor is in the process of shutting down.
         *        </p>
         *        <p>
         *        <code>TERMINATED</code> - The executor is no longer running.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - Due to a failure, the executor is no longer running.
         * @see ExecutorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutorState
         */
        Builder executorStateFilter(String executorStateFilter);

        /**
         * <p>
         * A filter for a specific executor state. A description of each state follows.
         * </p>
         * <p>
         * <code>CREATING</code> - The executor is being started, including acquiring resources.
         * </p>
         * <p>
         * <code>CREATED</code> - The executor has been started.
         * </p>
         * <p>
         * <code>REGISTERED</code> - The executor has been registered.
         * </p>
         * <p>
         * <code>TERMINATING</code> - The executor is in the process of shutting down.
         * </p>
         * <p>
         * <code>TERMINATED</code> - The executor is no longer running.
         * </p>
         * <p>
         * <code>FAILED</code> - Due to a failure, the executor is no longer running.
         * </p>
         * 
         * @param executorStateFilter
         *        A filter for a specific executor state. A description of each state follows.</p>
         *        <p>
         *        <code>CREATING</code> - The executor is being started, including acquiring resources.
         *        </p>
         *        <p>
         *        <code>CREATED</code> - The executor has been started.
         *        </p>
         *        <p>
         *        <code>REGISTERED</code> - The executor has been registered.
         *        </p>
         *        <p>
         *        <code>TERMINATING</code> - The executor is in the process of shutting down.
         *        </p>
         *        <p>
         *        <code>TERMINATED</code> - The executor is no longer running.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - Due to a failure, the executor is no longer running.
         * @see ExecutorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutorState
         */
        Builder executorStateFilter(ExecutorState executorStateFilter);

        /**
         * <p>
         * The maximum number of executors to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of executors to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was
         * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of
         * the previous page call.
         * </p>
         * 
         * @param nextToken
         *        A token generated by the Athena service that specifies where to continue pagination if a previous
         *        request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the
         *        response object of the previous page call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String sessionId;

        private String executorStateFilter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutorsRequest model) {
            super(model);
            sessionId(model.sessionId);
            executorStateFilter(model.executorStateFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getExecutorStateFilter() {
            return executorStateFilter;
        }

        public final void setExecutorStateFilter(String executorStateFilter) {
            this.executorStateFilter = executorStateFilter;
        }

        @Override
        public final Builder executorStateFilter(String executorStateFilter) {
            this.executorStateFilter = executorStateFilter;
            return this;
        }

        @Override
        public final Builder executorStateFilter(ExecutorState executorStateFilter) {
            this.executorStateFilter(executorStateFilter == null ? null : executorStateFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExecutorsRequest build() {
            return new ListExecutorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
