/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteWorkGroupRequest extends AthenaRequest implements
        ToCopyableBuilder<DeleteWorkGroupRequest.Builder, DeleteWorkGroupRequest> {
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(DeleteWorkGroupRequest::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final SdkField<Boolean> RECURSIVE_DELETE_OPTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RecursiveDeleteOption").getter(getter(DeleteWorkGroupRequest::recursiveDeleteOption))
            .setter(setter(Builder::recursiveDeleteOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecursiveDeleteOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD,
            RECURSIVE_DELETE_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workGroup;

    private final Boolean recursiveDeleteOption;

    private DeleteWorkGroupRequest(BuilderImpl builder) {
        super(builder);
        this.workGroup = builder.workGroup;
        this.recursiveDeleteOption = builder.recursiveDeleteOption;
    }

    /**
     * <p>
     * The unique name of the workgroup to delete.
     * </p>
     * 
     * @return The unique name of the workgroup to delete.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * The option to delete the workgroup and its contents even if the workgroup contains any named queries, query
     * executions, or notebooks.
     * </p>
     * 
     * @return The option to delete the workgroup and its contents even if the workgroup contains any named queries,
     *         query executions, or notebooks.
     */
    public final Boolean recursiveDeleteOption() {
        return recursiveDeleteOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(recursiveDeleteOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWorkGroupRequest)) {
            return false;
        }
        DeleteWorkGroupRequest other = (DeleteWorkGroupRequest) obj;
        return Objects.equals(workGroup(), other.workGroup())
                && Objects.equals(recursiveDeleteOption(), other.recursiveDeleteOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteWorkGroupRequest").add("WorkGroup", workGroup())
                .add("RecursiveDeleteOption", recursiveDeleteOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "RecursiveDeleteOption":
            return Optional.ofNullable(clazz.cast(recursiveDeleteOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkGroup", WORK_GROUP_FIELD);
        map.put("RecursiveDeleteOption", RECURSIVE_DELETE_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteWorkGroupRequest, T> g) {
        return obj -> g.apply((DeleteWorkGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteWorkGroupRequest> {
        /**
         * <p>
         * The unique name of the workgroup to delete.
         * </p>
         * 
         * @param workGroup
         *        The unique name of the workgroup to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * The option to delete the workgroup and its contents even if the workgroup contains any named queries, query
         * executions, or notebooks.
         * </p>
         * 
         * @param recursiveDeleteOption
         *        The option to delete the workgroup and its contents even if the workgroup contains any named queries,
         *        query executions, or notebooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursiveDeleteOption(Boolean recursiveDeleteOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String workGroup;

        private Boolean recursiveDeleteOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWorkGroupRequest model) {
            super(model);
            workGroup(model.workGroup);
            recursiveDeleteOption(model.recursiveDeleteOption);
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final Boolean getRecursiveDeleteOption() {
            return recursiveDeleteOption;
        }

        public final void setRecursiveDeleteOption(Boolean recursiveDeleteOption) {
            this.recursiveDeleteOption = recursiveDeleteOption;
        }

        @Override
        public final Builder recursiveDeleteOption(Boolean recursiveDeleteOption) {
            this.recursiveDeleteOption = recursiveDeleteOption;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWorkGroupRequest build() {
            return new DeleteWorkGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
