/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDataCatalogRequest extends AthenaRequest implements
        ToCopyableBuilder<DeleteDataCatalogRequest.Builder, DeleteDataCatalogRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DeleteDataCatalogRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Boolean> DELETE_CATALOG_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteCatalogOnly").getter(getter(DeleteDataCatalogRequest::deleteCatalogOnly))
            .setter(setter(Builder::deleteCatalogOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteCatalogOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DELETE_CATALOG_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Boolean deleteCatalogOnly;

    private DeleteDataCatalogRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.deleteCatalogOnly = builder.deleteCatalogOnly;
    }

    /**
     * <p>
     * The name of the data catalog to delete.
     * </p>
     * 
     * @return The name of the data catalog to delete.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Deletes the Athena Data Catalog. You can only use this with the <code>FEDERATED</code> catalogs. You usually
     * perform this before registering the connector with Glue Data Catalog. After deletion, you will have to manage the
     * Glue Connection and Lambda function.
     * </p>
     * 
     * @return Deletes the Athena Data Catalog. You can only use this with the <code>FEDERATED</code> catalogs. You
     *         usually perform this before registering the connector with Glue Data Catalog. After deletion, you will
     *         have to manage the Glue Connection and Lambda function.
     */
    public final Boolean deleteCatalogOnly() {
        return deleteCatalogOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(deleteCatalogOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataCatalogRequest)) {
            return false;
        }
        DeleteDataCatalogRequest other = (DeleteDataCatalogRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(deleteCatalogOnly(), other.deleteCatalogOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDataCatalogRequest").add("Name", name()).add("DeleteCatalogOnly", deleteCatalogOnly())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DeleteCatalogOnly":
            return Optional.ofNullable(clazz.cast(deleteCatalogOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("DeleteCatalogOnly", DELETE_CATALOG_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataCatalogRequest, T> g) {
        return obj -> g.apply((DeleteDataCatalogRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDataCatalogRequest> {
        /**
         * <p>
         * The name of the data catalog to delete.
         * </p>
         * 
         * @param name
         *        The name of the data catalog to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Deletes the Athena Data Catalog. You can only use this with the <code>FEDERATED</code> catalogs. You usually
         * perform this before registering the connector with Glue Data Catalog. After deletion, you will have to manage
         * the Glue Connection and Lambda function.
         * </p>
         * 
         * @param deleteCatalogOnly
         *        Deletes the Athena Data Catalog. You can only use this with the <code>FEDERATED</code> catalogs. You
         *        usually perform this before registering the connector with Glue Data Catalog. After deletion, you will
         *        have to manage the Glue Connection and Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteCatalogOnly(Boolean deleteCatalogOnly);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String name;

        private Boolean deleteCatalogOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataCatalogRequest model) {
            super(model);
            name(model.name);
            deleteCatalogOnly(model.deleteCatalogOnly);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDeleteCatalogOnly() {
            return deleteCatalogOnly;
        }

        public final void setDeleteCatalogOnly(Boolean deleteCatalogOnly) {
            this.deleteCatalogOnly = deleteCatalogOnly;
        }

        @Override
        public final Builder deleteCatalogOnly(Boolean deleteCatalogOnly) {
            this.deleteCatalogOnly = deleteCatalogOnly;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDataCatalogRequest build() {
            return new DeleteDataCatalogRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
