/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping between one or more workgroups and a capacity reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityAssignment implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityAssignment.Builder, CapacityAssignment> {
    private static final SdkField<List<String>> WORK_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WorkGroupNames")
            .getter(getter(CapacityAssignment::workGroupNames))
            .setter(setter(Builder::workGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> workGroupNames;

    private CapacityAssignment(BuilderImpl builder) {
        this.workGroupNames = builder.workGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkGroupNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkGroupNames() {
        return workGroupNames != null && !(workGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of workgroup names for the capacity assignment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkGroupNames} method.
     * </p>
     * 
     * @return The list of workgroup names for the capacity assignment.
     */
    public final List<String> workGroupNames() {
        return workGroupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkGroupNames() ? workGroupNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityAssignment)) {
            return false;
        }
        CapacityAssignment other = (CapacityAssignment) obj;
        return hasWorkGroupNames() == other.hasWorkGroupNames() && Objects.equals(workGroupNames(), other.workGroupNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityAssignment").add("WorkGroupNames", hasWorkGroupNames() ? workGroupNames() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkGroupNames":
            return Optional.ofNullable(clazz.cast(workGroupNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkGroupNames", WORK_GROUP_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityAssignment, T> g) {
        return obj -> g.apply((CapacityAssignment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityAssignment> {
        /**
         * <p>
         * The list of workgroup names for the capacity assignment.
         * </p>
         * 
         * @param workGroupNames
         *        The list of workgroup names for the capacity assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroupNames(Collection<String> workGroupNames);

        /**
         * <p>
         * The list of workgroup names for the capacity assignment.
         * </p>
         * 
         * @param workGroupNames
         *        The list of workgroup names for the capacity assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroupNames(String... workGroupNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> workGroupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityAssignment model) {
            workGroupNames(model.workGroupNames);
        }

        public final Collection<String> getWorkGroupNames() {
            if (workGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return workGroupNames;
        }

        public final void setWorkGroupNames(Collection<String> workGroupNames) {
            this.workGroupNames = WorkGroupNamesListCopier.copy(workGroupNames);
        }

        @Override
        public final Builder workGroupNames(Collection<String> workGroupNames) {
            this.workGroupNames = WorkGroupNamesListCopier.copy(workGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workGroupNames(String... workGroupNames) {
            workGroupNames(Arrays.asList(workGroupNames));
            return this;
        }

        @Override
        public CapacityAssignment build() {
            return new CapacityAssignment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
