/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon Cognito user pool configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolConfig implements SdkPojo, Serializable, ToCopyableBuilder<UserPoolConfig.Builder, UserPoolConfig> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userPoolId").getter(getter(UserPoolConfig::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsRegion").getter(getter(UserPoolConfig::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()).build();

    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultAction").getter(getter(UserPoolConfig::defaultActionAsString))
            .setter(setter(Builder::defaultAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAction").build()).build();

    private static final SdkField<String> APP_ID_CLIENT_REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appIdClientRegex").getter(getter(UserPoolConfig::appIdClientRegex))
            .setter(setter(Builder::appIdClientRegex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appIdClientRegex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            AWS_REGION_FIELD, DEFAULT_ACTION_FIELD, APP_ID_CLIENT_REGEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userPoolId;

    private final String awsRegion;

    private final String defaultAction;

    private final String appIdClientRegex;

    private UserPoolConfig(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsRegion = builder.awsRegion;
        this.defaultAction = builder.defaultAction;
        this.appIdClientRegex = builder.appIdClientRegex;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which the user pool was created.
     * </p>
     * 
     * @return The Amazon Web Services Region in which the user pool was created.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool
     * authentication doesn't match the Amazon Cognito user pool configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAction}
     * will return {@link DefaultAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultActionAsString}.
     * </p>
     * 
     * @return The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool
     *         authentication doesn't match the Amazon Cognito user pool configuration.
     * @see DefaultAction
     */
    public final DefaultAction defaultAction() {
        return DefaultAction.fromValue(defaultAction);
    }

    /**
     * <p>
     * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool
     * authentication doesn't match the Amazon Cognito user pool configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAction}
     * will return {@link DefaultAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultActionAsString}.
     * </p>
     * 
     * @return The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool
     *         authentication doesn't match the Amazon Cognito user pool configuration.
     * @see DefaultAction
     */
    public final String defaultActionAsString() {
        return defaultAction;
    }

    /**
     * <p>
     * A regular expression for validating the incoming Amazon Cognito user pool app client ID. If this value isn't set,
     * no filtering is applied.
     * </p>
     * 
     * @return A regular expression for validating the incoming Amazon Cognito user pool app client ID. If this value
     *         isn't set, no filtering is applied.
     */
    public final String appIdClientRegex() {
        return appIdClientRegex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(defaultActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(appIdClientRegex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolConfig)) {
            return false;
        }
        UserPoolConfig other = (UserPoolConfig) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(defaultActionAsString(), other.defaultActionAsString())
                && Objects.equals(appIdClientRegex(), other.appIdClientRegex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPoolConfig").add("UserPoolId", userPoolId()).add("AwsRegion", awsRegion())
                .add("DefaultAction", defaultActionAsString()).add("AppIdClientRegex", appIdClientRegex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "awsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "defaultAction":
            return Optional.ofNullable(clazz.cast(defaultActionAsString()));
        case "appIdClientRegex":
            return Optional.ofNullable(clazz.cast(appIdClientRegex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userPoolId", USER_POOL_ID_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("defaultAction", DEFAULT_ACTION_FIELD);
        map.put("appIdClientRegex", APP_ID_CLIENT_REGEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPoolConfig, T> g) {
        return obj -> g.apply((UserPoolConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolConfig> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The Amazon Web Services Region in which the user pool was created.
         * </p>
         * 
         * @param awsRegion
         *        The Amazon Web Services Region in which the user pool was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool
         * authentication doesn't match the Amazon Cognito user pool configuration.
         * </p>
         * 
         * @param defaultAction
         *        The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool
         *        authentication doesn't match the Amazon Cognito user pool configuration.
         * @see DefaultAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultAction
         */
        Builder defaultAction(String defaultAction);

        /**
         * <p>
         * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool
         * authentication doesn't match the Amazon Cognito user pool configuration.
         * </p>
         * 
         * @param defaultAction
         *        The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool
         *        authentication doesn't match the Amazon Cognito user pool configuration.
         * @see DefaultAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultAction
         */
        Builder defaultAction(DefaultAction defaultAction);

        /**
         * <p>
         * A regular expression for validating the incoming Amazon Cognito user pool app client ID. If this value isn't
         * set, no filtering is applied.
         * </p>
         * 
         * @param appIdClientRegex
         *        A regular expression for validating the incoming Amazon Cognito user pool app client ID. If this value
         *        isn't set, no filtering is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appIdClientRegex(String appIdClientRegex);
    }

    static final class BuilderImpl implements Builder {
        private String userPoolId;

        private String awsRegion;

        private String defaultAction;

        private String appIdClientRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolConfig model) {
            userPoolId(model.userPoolId);
            awsRegion(model.awsRegion);
            defaultAction(model.defaultAction);
            appIdClientRegex(model.appIdClientRegex);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getDefaultAction() {
            return defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(DefaultAction defaultAction) {
            this.defaultAction(defaultAction == null ? null : defaultAction.toString());
            return this;
        }

        public final String getAppIdClientRegex() {
            return appIdClientRegex;
        }

        public final void setAppIdClientRegex(String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
        }

        @Override
        public final Builder appIdClientRegex(String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
            return this;
        }

        @Override
        public UserPoolConfig build() {
            return new UserPoolConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
