/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDataSourceIntrospectionRequest extends AppSyncRequest implements
        ToCopyableBuilder<StartDataSourceIntrospectionRequest.Builder, StartDataSourceIntrospectionRequest> {
    private static final SdkField<RdsDataApiConfig> RDS_DATA_API_CONFIG_FIELD = SdkField
            .<RdsDataApiConfig> builder(MarshallingType.SDK_POJO).memberName("rdsDataApiConfig")
            .getter(getter(StartDataSourceIntrospectionRequest::rdsDataApiConfig)).setter(setter(Builder::rdsDataApiConfig))
            .constructor(RdsDataApiConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDataApiConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RDS_DATA_API_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RdsDataApiConfig rdsDataApiConfig;

    private StartDataSourceIntrospectionRequest(BuilderImpl builder) {
        super(builder);
        this.rdsDataApiConfig = builder.rdsDataApiConfig;
    }

    /**
     * <p>
     * The <code>rdsDataApiConfig</code> object data.
     * </p>
     * 
     * @return The <code>rdsDataApiConfig</code> object data.
     */
    public final RdsDataApiConfig rdsDataApiConfig() {
        return rdsDataApiConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rdsDataApiConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataSourceIntrospectionRequest)) {
            return false;
        }
        StartDataSourceIntrospectionRequest other = (StartDataSourceIntrospectionRequest) obj;
        return Objects.equals(rdsDataApiConfig(), other.rdsDataApiConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDataSourceIntrospectionRequest").add("RdsDataApiConfig", rdsDataApiConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rdsDataApiConfig":
            return Optional.ofNullable(clazz.cast(rdsDataApiConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rdsDataApiConfig", RDS_DATA_API_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDataSourceIntrospectionRequest, T> g) {
        return obj -> g.apply((StartDataSourceIntrospectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppSyncRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDataSourceIntrospectionRequest> {
        /**
         * <p>
         * The <code>rdsDataApiConfig</code> object data.
         * </p>
         * 
         * @param rdsDataApiConfig
         *        The <code>rdsDataApiConfig</code> object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDataApiConfig(RdsDataApiConfig rdsDataApiConfig);

        /**
         * <p>
         * The <code>rdsDataApiConfig</code> object data.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsDataApiConfig.Builder} avoiding the
         * need to create one manually via {@link RdsDataApiConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsDataApiConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #rdsDataApiConfig(RdsDataApiConfig)}.
         * 
         * @param rdsDataApiConfig
         *        a consumer that will call methods on {@link RdsDataApiConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsDataApiConfig(RdsDataApiConfig)
         */
        default Builder rdsDataApiConfig(Consumer<RdsDataApiConfig.Builder> rdsDataApiConfig) {
            return rdsDataApiConfig(RdsDataApiConfig.builder().applyMutation(rdsDataApiConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private RdsDataApiConfig rdsDataApiConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataSourceIntrospectionRequest model) {
            super(model);
            rdsDataApiConfig(model.rdsDataApiConfig);
        }

        public final RdsDataApiConfig.Builder getRdsDataApiConfig() {
            return rdsDataApiConfig != null ? rdsDataApiConfig.toBuilder() : null;
        }

        public final void setRdsDataApiConfig(RdsDataApiConfig.BuilderImpl rdsDataApiConfig) {
            this.rdsDataApiConfig = rdsDataApiConfig != null ? rdsDataApiConfig.build() : null;
        }

        @Override
        public final Builder rdsDataApiConfig(RdsDataApiConfig rdsDataApiConfig) {
            this.rdsDataApiConfig = rdsDataApiConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataSourceIntrospectionRequest build() {
            return new StartDataSourceIntrospectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
