/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutGraphqlApiEnvironmentVariablesRequest extends AppSyncRequest implements
        ToCopyableBuilder<PutGraphqlApiEnvironmentVariablesRequest.Builder, PutGraphqlApiEnvironmentVariablesRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(PutGraphqlApiEnvironmentVariablesRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(PutGraphqlApiEnvironmentVariablesRequest::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            ENVIRONMENT_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String apiId;

    private final Map<String, String> environmentVariables;

    private PutGraphqlApiEnvironmentVariablesRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.environmentVariables = builder.environmentVariables;
    }

    /**
     * <p>
     * The ID of the API to which the environmental variable list will be written.
     * </p>
     * 
     * @return The ID of the API to which the environmental variable list will be written.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of environmental variables to add to the API.
     * </p>
     * <p>
     * When creating an environmental variable key-value pair, it must follow the additional constraints below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Keys must begin with a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys must be at least two characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys can only contain letters, numbers, and the underscore character (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Values can be up to 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure up to 50 key-value pairs in a GraphQL API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can create a list of environmental variables by adding it to the <code>environmentVariables</code> payload as
     * a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call of the
     * <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the existing
     * environmental variable list of that API. This means the existing environmental variables will be lost. To avoid
     * this, you must include all existing and new environmental variables in the list each time you call this action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return The list of environmental variables to add to the API.</p>
     *         <p>
     *         When creating an environmental variable key-value pair, it must follow the additional constraints below:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Keys must begin with a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Keys must be at least two characters long.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Keys can only contain letters, numbers, and the underscore character (_).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Values can be up to 512 characters long.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can configure up to 50 key-value pairs in a GraphQL API.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can create a list of environmental variables by adding it to the <code>environmentVariables</code>
     *         payload as a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call of
     *         the <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the existing
     *         environmental variable list of that API. This means the existing environmental variables will be lost. To
     *         avoid this, you must include all existing and new environmental variables in the list each time you call
     *         this action.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGraphqlApiEnvironmentVariablesRequest)) {
            return false;
        }
        PutGraphqlApiEnvironmentVariablesRequest other = (PutGraphqlApiEnvironmentVariablesRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutGraphqlApiEnvironmentVariablesRequest").add("ApiId", apiId())
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiId", API_ID_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutGraphqlApiEnvironmentVariablesRequest, T> g) {
        return obj -> g.apply((PutGraphqlApiEnvironmentVariablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppSyncRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutGraphqlApiEnvironmentVariablesRequest> {
        /**
         * <p>
         * The ID of the API to which the environmental variable list will be written.
         * </p>
         * 
         * @param apiId
         *        The ID of the API to which the environmental variable list will be written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The list of environmental variables to add to the API.
         * </p>
         * <p>
         * When creating an environmental variable key-value pair, it must follow the additional constraints below:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Keys must begin with a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys must be at least two characters long.
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys can only contain letters, numbers, and the underscore character (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Values can be up to 512 characters long.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can configure up to 50 key-value pairs in a GraphQL API.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can create a list of environmental variables by adding it to the <code>environmentVariables</code>
         * payload as a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call of the
         * <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the existing
         * environmental variable list of that API. This means the existing environmental variables will be lost. To
         * avoid this, you must include all existing and new environmental variables in the list each time you call this
         * action.
         * </p>
         * 
         * @param environmentVariables
         *        The list of environmental variables to add to the API.</p>
         *        <p>
         *        When creating an environmental variable key-value pair, it must follow the additional constraints
         *        below:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Keys must begin with a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys must be at least two characters long.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys can only contain letters, numbers, and the underscore character (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Values can be up to 512 characters long.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can configure up to 50 key-value pairs in a GraphQL API.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can create a list of environmental variables by adding it to the <code>environmentVariables</code>
         *        payload as a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call
         *        of the <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the
         *        existing environmental variable list of that API. This means the existing environmental variables will
         *        be lost. To avoid this, you must include all existing and new environmental variables in the list each
         *        time you call this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutGraphqlApiEnvironmentVariablesRequest model) {
            super(model);
            apiId(model.apiId);
            environmentVariables(model.environmentVariables);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGraphqlApiEnvironmentVariablesRequest build() {
            return new PutGraphqlApiEnvironmentVariablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
