/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateMappingTemplateResponse extends AppSyncResponse implements
        ToCopyableBuilder<EvaluateMappingTemplateResponse.Builder, EvaluateMappingTemplateResponse> {
    private static final SdkField<String> EVALUATION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationResult").getter(getter(EvaluateMappingTemplateResponse::evaluationResult))
            .setter(setter(Builder::evaluationResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationResult").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(EvaluateMappingTemplateResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<List<String>> LOGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logs")
            .getter(getter(EvaluateMappingTemplateResponse::logs))
            .setter(setter(Builder::logs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STASH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stash")
            .getter(getter(EvaluateMappingTemplateResponse::stash)).setter(setter(Builder::stash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stash").build()).build();

    private static final SdkField<String> OUT_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outErrors").getter(getter(EvaluateMappingTemplateResponse::outErrors))
            .setter(setter(Builder::outErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outErrors").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULT_FIELD,
            ERROR_FIELD, LOGS_FIELD, STASH_FIELD, OUT_ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String evaluationResult;

    private final ErrorDetail error;

    private final List<String> logs;

    private final String stash;

    private final String outErrors;

    private EvaluateMappingTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResult = builder.evaluationResult;
        this.error = builder.error;
        this.logs = builder.logs;
        this.stash = builder.stash;
        this.outErrors = builder.outErrors;
    }

    /**
     * <p>
     * The mapping template; this can be a request or response template.
     * </p>
     * 
     * @return The mapping template; this can be a request or response template.
     */
    public final String evaluationResult() {
        return evaluationResult;
    }

    /**
     * <p>
     * The <code>ErrorDetail</code> object.
     * </p>
     * 
     * @return The <code>ErrorDetail</code> object.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * For responses, this returns true if the service returned a value for the Logs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLogs() {
        return logs != null && !(logs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the
     * evaluated code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogs} method.
     * </p>
     * 
     * @return A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code>
     *         in the evaluated code.
     */
    public final List<String> logs() {
        return logs;
    }

    /**
     * <p>
     * An object available inside each resolver and function handler. A single <code>stash</code> object lives through a
     * single resolver run. Therefore, you can use the stash to pass arbitrary data across request and response handlers
     * and across functions in a pipeline resolver.
     * </p>
     * 
     * @return An object available inside each resolver and function handler. A single <code>stash</code> object lives
     *         through a single resolver run. Therefore, you can use the stash to pass arbitrary data across request and
     *         response handlers and across functions in a pipeline resolver.
     */
    public final String stash() {
        return stash;
    }

    /**
     * <p>
     * The list of runtime errors that are added to the GraphQL operation response.
     * </p>
     * 
     * @return The list of runtime errors that are added to the GraphQL operation response.
     */
    public final String outErrors() {
        return outErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogs() ? logs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stash());
        hashCode = 31 * hashCode + Objects.hashCode(outErrors());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateMappingTemplateResponse)) {
            return false;
        }
        EvaluateMappingTemplateResponse other = (EvaluateMappingTemplateResponse) obj;
        return Objects.equals(evaluationResult(), other.evaluationResult()) && Objects.equals(error(), other.error())
                && hasLogs() == other.hasLogs() && Objects.equals(logs(), other.logs()) && Objects.equals(stash(), other.stash())
                && Objects.equals(outErrors(), other.outErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateMappingTemplateResponse").add("EvaluationResult", evaluationResult())
                .add("Error", error()).add("Logs", hasLogs() ? logs() : null).add("Stash", stash()).add("OutErrors", outErrors())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evaluationResult":
            return Optional.ofNullable(clazz.cast(evaluationResult()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "logs":
            return Optional.ofNullable(clazz.cast(logs()));
        case "stash":
            return Optional.ofNullable(clazz.cast(stash()));
        case "outErrors":
            return Optional.ofNullable(clazz.cast(outErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("evaluationResult", EVALUATION_RESULT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("logs", LOGS_FIELD);
        map.put("stash", STASH_FIELD);
        map.put("outErrors", OUT_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateMappingTemplateResponse, T> g) {
        return obj -> g.apply((EvaluateMappingTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateMappingTemplateResponse> {
        /**
         * <p>
         * The mapping template; this can be a request or response template.
         * </p>
         * 
         * @param evaluationResult
         *        The mapping template; this can be a request or response template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResult(String evaluationResult);

        /**
         * <p>
         * The <code>ErrorDetail</code> object.
         * </p>
         * 
         * @param error
         *        The <code>ErrorDetail</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * The <code>ErrorDetail</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in
         * the evaluated code.
         * </p>
         * 
         * @param logs
         *        A list of logs that were generated by calls to <code>util.log.info</code> and
         *        <code>util.log.error</code> in the evaluated code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(Collection<String> logs);

        /**
         * <p>
         * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in
         * the evaluated code.
         * </p>
         * 
         * @param logs
         *        A list of logs that were generated by calls to <code>util.log.info</code> and
         *        <code>util.log.error</code> in the evaluated code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(String... logs);

        /**
         * <p>
         * An object available inside each resolver and function handler. A single <code>stash</code> object lives
         * through a single resolver run. Therefore, you can use the stash to pass arbitrary data across request and
         * response handlers and across functions in a pipeline resolver.
         * </p>
         * 
         * @param stash
         *        An object available inside each resolver and function handler. A single <code>stash</code> object
         *        lives through a single resolver run. Therefore, you can use the stash to pass arbitrary data across
         *        request and response handlers and across functions in a pipeline resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stash(String stash);

        /**
         * <p>
         * The list of runtime errors that are added to the GraphQL operation response.
         * </p>
         * 
         * @param outErrors
         *        The list of runtime errors that are added to the GraphQL operation response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outErrors(String outErrors);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private String evaluationResult;

        private ErrorDetail error;

        private List<String> logs = DefaultSdkAutoConstructList.getInstance();

        private String stash;

        private String outErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateMappingTemplateResponse model) {
            super(model);
            evaluationResult(model.evaluationResult);
            error(model.error);
            logs(model.logs);
            stash(model.stash);
            outErrors(model.outErrors);
        }

        public final String getEvaluationResult() {
            return evaluationResult;
        }

        public final void setEvaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
        }

        @Override
        public final Builder evaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final Collection<String> getLogs() {
            if (logs instanceof SdkAutoConstructList) {
                return null;
            }
            return logs;
        }

        public final void setLogs(Collection<String> logs) {
            this.logs = LogsCopier.copy(logs);
        }

        @Override
        public final Builder logs(Collection<String> logs) {
            this.logs = LogsCopier.copy(logs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logs(String... logs) {
            logs(Arrays.asList(logs));
            return this;
        }

        public final String getStash() {
            return stash;
        }

        public final void setStash(String stash) {
            this.stash = stash;
        }

        @Override
        public final Builder stash(String stash) {
            this.stash = stash;
            return this;
        }

        public final String getOutErrors() {
            return outErrors;
        }

        public final void setOutErrors(String outErrors) {
            this.outErrors = outErrors;
        }

        @Override
        public final Builder outErrors(String outErrors) {
            this.outErrors = outErrors;
            return this;
        }

        @Override
        public EvaluateMappingTemplateResponse build() {
            return new EvaluateMappingTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
