/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateCodeRequest extends AppSyncRequest implements
        ToCopyableBuilder<EvaluateCodeRequest.Builder, EvaluateCodeRequest> {
    private static final SdkField<AppSyncRuntime> RUNTIME_FIELD = SdkField.<AppSyncRuntime> builder(MarshallingType.SDK_POJO)
            .memberName("runtime").getter(getter(EvaluateCodeRequest::runtime)).setter(setter(Builder::runtime))
            .constructor(AppSyncRuntime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(EvaluateCodeRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("context")
            .getter(getter(EvaluateCodeRequest::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("function").getter(getter(EvaluateCodeRequest::function)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_FIELD, CODE_FIELD,
            CONTEXT_FIELD, FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AppSyncRuntime runtime;

    private final String code;

    private final String context;

    private final String function;

    private EvaluateCodeRequest(BuilderImpl builder) {
        super(builder);
        this.runtime = builder.runtime;
        this.code = builder.code;
        this.context = builder.context;
        this.function = builder.function;
    }

    /**
     * <p>
     * The runtime to be used when evaluating the code. Currently, only the <code>APPSYNC_JS</code> runtime is
     * supported.
     * </p>
     * 
     * @return The runtime to be used when evaluating the code. Currently, only the <code>APPSYNC_JS</code> runtime is
     *         supported.
     */
    public final AppSyncRuntime runtime() {
        return runtime;
    }

    /**
     * <p>
     * The code definition to be evaluated. Note that <code>code</code> and <code>runtime</code> are both required for
     * this action. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
     * </p>
     * 
     * @return The code definition to be evaluated. Note that <code>code</code> and <code>runtime</code> are both
     *         required for this action. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The map that holds all of the contextual information for your resolver invocation. A <code>context</code> is
     * required for this action.
     * </p>
     * 
     * @return The map that holds all of the contextual information for your resolver invocation. A <code>context</code>
     *         is required for this action.
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * The function within the code to be evaluated. If provided, the valid values are <code>request</code> and
     * <code>response</code>.
     * </p>
     * 
     * @return The function within the code to be evaluated. If provided, the valid values are <code>request</code> and
     *         <code>response</code>.
     */
    public final String function() {
        return function;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runtime());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(function());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateCodeRequest)) {
            return false;
        }
        EvaluateCodeRequest other = (EvaluateCodeRequest) obj;
        return Objects.equals(runtime(), other.runtime()) && Objects.equals(code(), other.code())
                && Objects.equals(context(), other.context()) && Objects.equals(function(), other.function());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateCodeRequest").add("Runtime", runtime()).add("Code", code()).add("Context", context())
                .add("Function", function()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtime()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "function":
            return Optional.ofNullable(clazz.cast(function()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("runtime", RUNTIME_FIELD);
        map.put("code", CODE_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("function", FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateCodeRequest, T> g) {
        return obj -> g.apply((EvaluateCodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateCodeRequest> {
        /**
         * <p>
         * The runtime to be used when evaluating the code. Currently, only the <code>APPSYNC_JS</code> runtime is
         * supported.
         * </p>
         * 
         * @param runtime
         *        The runtime to be used when evaluating the code. Currently, only the <code>APPSYNC_JS</code> runtime
         *        is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtime(AppSyncRuntime runtime);

        /**
         * <p>
         * The runtime to be used when evaluating the code. Currently, only the <code>APPSYNC_JS</code> runtime is
         * supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppSyncRuntime.Builder} avoiding the need
         * to create one manually via {@link AppSyncRuntime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppSyncRuntime.Builder#build()} is called immediately and its
         * result is passed to {@link #runtime(AppSyncRuntime)}.
         * 
         * @param runtime
         *        a consumer that will call methods on {@link AppSyncRuntime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtime(AppSyncRuntime)
         */
        default Builder runtime(Consumer<AppSyncRuntime.Builder> runtime) {
            return runtime(AppSyncRuntime.builder().applyMutation(runtime).build());
        }

        /**
         * <p>
         * The code definition to be evaluated. Note that <code>code</code> and <code>runtime</code> are both required
         * for this action. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
         * </p>
         * 
         * @param code
         *        The code definition to be evaluated. Note that <code>code</code> and <code>runtime</code> are both
         *        required for this action. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The map that holds all of the contextual information for your resolver invocation. A <code>context</code> is
         * required for this action.
         * </p>
         * 
         * @param context
         *        The map that holds all of the contextual information for your resolver invocation. A
         *        <code>context</code> is required for this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * The function within the code to be evaluated. If provided, the valid values are <code>request</code> and
         * <code>response</code>.
         * </p>
         * 
         * @param function
         *        The function within the code to be evaluated. If provided, the valid values are <code>request</code>
         *        and <code>response</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder function(String function);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private AppSyncRuntime runtime;

        private String code;

        private String context;

        private String function;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateCodeRequest model) {
            super(model);
            runtime(model.runtime);
            code(model.code);
            context(model.context);
            function(model.function);
        }

        public final AppSyncRuntime.Builder getRuntime() {
            return runtime != null ? runtime.toBuilder() : null;
        }

        public final void setRuntime(AppSyncRuntime.BuilderImpl runtime) {
            this.runtime = runtime != null ? runtime.build() : null;
        }

        @Override
        public final Builder runtime(AppSyncRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateCodeRequest build() {
            return new EvaluateCodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
