/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the fields that were retrieved from the introspected data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceIntrospectionModelField implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceIntrospectionModelField.Builder, DataSourceIntrospectionModelField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataSourceIntrospectionModelField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<DataSourceIntrospectionModelFieldType> TYPE_FIELD = SdkField
            .<DataSourceIntrospectionModelFieldType> builder(MarshallingType.SDK_POJO).memberName("type")
            .getter(getter(DataSourceIntrospectionModelField::type)).setter(setter(Builder::type))
            .constructor(DataSourceIntrospectionModelFieldType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Long> LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("length")
            .getter(getter(DataSourceIntrospectionModelField::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("length").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final DataSourceIntrospectionModelFieldType type;

    private final Long length;

    private DataSourceIntrospectionModelField(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.length = builder.length;
    }

    /**
     * <p>
     * The name of the field that was retrieved from the introspected data.
     * </p>
     * 
     * @return The name of the field that was retrieved from the introspected data.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The <code>DataSourceIntrospectionModelFieldType</code> object data.
     * </p>
     * 
     * @return The <code>DataSourceIntrospectionModelFieldType</code> object data.
     */
    public final DataSourceIntrospectionModelFieldType type() {
        return type;
    }

    /**
     * <p>
     * The length value of the introspected field.
     * </p>
     * 
     * @return The length value of the introspected field.
     */
    public final Long length() {
        return length;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(length());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceIntrospectionModelField)) {
            return false;
        }
        DataSourceIntrospectionModelField other = (DataSourceIntrospectionModelField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(length(), other.length());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceIntrospectionModelField").add("Name", name()).add("Type", type())
                .add("Length", length()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "length":
            return Optional.ofNullable(clazz.cast(length()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("length", LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceIntrospectionModelField, T> g) {
        return obj -> g.apply((DataSourceIntrospectionModelField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceIntrospectionModelField> {
        /**
         * <p>
         * The name of the field that was retrieved from the introspected data.
         * </p>
         * 
         * @param name
         *        The name of the field that was retrieved from the introspected data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>DataSourceIntrospectionModelFieldType</code> object data.
         * </p>
         * 
         * @param type
         *        The <code>DataSourceIntrospectionModelFieldType</code> object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(DataSourceIntrospectionModelFieldType type);

        /**
         * <p>
         * The <code>DataSourceIntrospectionModelFieldType</code> object data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataSourceIntrospectionModelFieldType.Builder} avoiding the need to create one manually via
         * {@link DataSourceIntrospectionModelFieldType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceIntrospectionModelFieldType.Builder#build()} is called
         * immediately and its result is passed to {@link #type(DataSourceIntrospectionModelFieldType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link DataSourceIntrospectionModelFieldType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(DataSourceIntrospectionModelFieldType)
         */
        default Builder type(Consumer<DataSourceIntrospectionModelFieldType.Builder> type) {
            return type(DataSourceIntrospectionModelFieldType.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * The length value of the introspected field.
         * </p>
         * 
         * @param length
         *        The length value of the introspected field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Long length);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private DataSourceIntrospectionModelFieldType type;

        private Long length;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceIntrospectionModelField model) {
            name(model.name);
            type(model.type);
            length(model.length);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DataSourceIntrospectionModelFieldType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(DataSourceIntrospectionModelFieldType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(DataSourceIntrospectionModelFieldType type) {
            this.type = type;
            return this;
        }

        public final Long getLength() {
            return length;
        }

        public final void setLength(Long length) {
            this.length = length;
        }

        @Override
        public final Builder length(Long length) {
            this.length = length;
            return this;
        }

        @Override
        public DataSourceIntrospectionModelField build() {
            return new DataSourceIntrospectionModelField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
