/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the location of the error in a code sample.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeErrorLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeErrorLocation.Builder, CodeErrorLocation> {
    private static final SdkField<Integer> LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("line")
            .getter(getter(CodeErrorLocation::line)).setter(setter(Builder::line))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("line").build()).build();

    private static final SdkField<Integer> COLUMN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("column").getter(getter(CodeErrorLocation::column)).setter(setter(Builder::column))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("column").build()).build();

    private static final SdkField<Integer> SPAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("span")
            .getter(getter(CodeErrorLocation::span)).setter(setter(Builder::span))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("span").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_FIELD, COLUMN_FIELD,
            SPAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer line;

    private final Integer column;

    private final Integer span;

    private CodeErrorLocation(BuilderImpl builder) {
        this.line = builder.line;
        this.column = builder.column;
        this.span = builder.span;
    }

    /**
     * <p>
     * The line number in the code. Defaults to <code>0</code> if unknown.
     * </p>
     * 
     * @return The line number in the code. Defaults to <code>0</code> if unknown.
     */
    public final Integer line() {
        return line;
    }

    /**
     * <p>
     * The column number in the code. Defaults to <code>0</code> if unknown.
     * </p>
     * 
     * @return The column number in the code. Defaults to <code>0</code> if unknown.
     */
    public final Integer column() {
        return column;
    }

    /**
     * <p>
     * The span/length of the error. Defaults to <code>-1</code> if unknown.
     * </p>
     * 
     * @return The span/length of the error. Defaults to <code>-1</code> if unknown.
     */
    public final Integer span() {
        return span;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(line());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(span());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeErrorLocation)) {
            return false;
        }
        CodeErrorLocation other = (CodeErrorLocation) obj;
        return Objects.equals(line(), other.line()) && Objects.equals(column(), other.column())
                && Objects.equals(span(), other.span());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeErrorLocation").add("Line", line()).add("Column", column()).add("Span", span()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "line":
            return Optional.ofNullable(clazz.cast(line()));
        case "column":
            return Optional.ofNullable(clazz.cast(column()));
        case "span":
            return Optional.ofNullable(clazz.cast(span()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("line", LINE_FIELD);
        map.put("column", COLUMN_FIELD);
        map.put("span", SPAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeErrorLocation, T> g) {
        return obj -> g.apply((CodeErrorLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeErrorLocation> {
        /**
         * <p>
         * The line number in the code. Defaults to <code>0</code> if unknown.
         * </p>
         * 
         * @param line
         *        The line number in the code. Defaults to <code>0</code> if unknown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder line(Integer line);

        /**
         * <p>
         * The column number in the code. Defaults to <code>0</code> if unknown.
         * </p>
         * 
         * @param column
         *        The column number in the code. Defaults to <code>0</code> if unknown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(Integer column);

        /**
         * <p>
         * The span/length of the error. Defaults to <code>-1</code> if unknown.
         * </p>
         * 
         * @param span
         *        The span/length of the error. Defaults to <code>-1</code> if unknown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder span(Integer span);
    }

    static final class BuilderImpl implements Builder {
        private Integer line;

        private Integer column;

        private Integer span;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeErrorLocation model) {
            line(model.line);
            column(model.column);
            span(model.span);
        }

        public final Integer getLine() {
            return line;
        }

        public final void setLine(Integer line) {
            this.line = line;
        }

        @Override
        public final Builder line(Integer line) {
            this.line = line;
            return this;
        }

        public final Integer getColumn() {
            return column;
        }

        public final void setColumn(Integer column) {
            this.column = column;
        }

        @Override
        public final Builder column(Integer column) {
            this.column = column;
            return this;
        }

        public final Integer getSpan() {
            return span;
        }

        public final void setSpan(Integer span) {
            this.span = span;
        }

        @Override
        public final Builder span(Integer span) {
            this.span = span;
            return this;
        }

        @Override
        public CodeErrorLocation build() {
            return new CodeErrorLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
