/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Identity and Access Management (IAM) configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamConfig implements SdkPojo, Serializable, ToCopyableBuilder<AwsIamConfig.Builder, AwsIamConfig> {
    private static final SdkField<String> SIGNING_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signingRegion").getter(getter(AwsIamConfig::signingRegion)).setter(setter(Builder::signingRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingRegion").build()).build();

    private static final SdkField<String> SIGNING_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signingServiceName").getter(getter(AwsIamConfig::signingServiceName))
            .setter(setter(Builder::signingServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingServiceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_REGION_FIELD,
            SIGNING_SERVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String signingRegion;

    private final String signingServiceName;

    private AwsIamConfig(BuilderImpl builder) {
        this.signingRegion = builder.signingRegion;
        this.signingServiceName = builder.signingServiceName;
    }

    /**
     * <p>
     * The signing Amazon Web Services Region for IAM authorization.
     * </p>
     * 
     * @return The signing Amazon Web Services Region for IAM authorization.
     */
    public final String signingRegion() {
        return signingRegion;
    }

    /**
     * <p>
     * The signing service name for IAM authorization.
     * </p>
     * 
     * @return The signing service name for IAM authorization.
     */
    public final String signingServiceName() {
        return signingServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signingRegion());
        hashCode = 31 * hashCode + Objects.hashCode(signingServiceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamConfig)) {
            return false;
        }
        AwsIamConfig other = (AwsIamConfig) obj;
        return Objects.equals(signingRegion(), other.signingRegion())
                && Objects.equals(signingServiceName(), other.signingServiceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamConfig").add("SigningRegion", signingRegion())
                .add("SigningServiceName", signingServiceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signingRegion":
            return Optional.ofNullable(clazz.cast(signingRegion()));
        case "signingServiceName":
            return Optional.ofNullable(clazz.cast(signingServiceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("signingRegion", SIGNING_REGION_FIELD);
        map.put("signingServiceName", SIGNING_SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsIamConfig, T> g) {
        return obj -> g.apply((AwsIamConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamConfig> {
        /**
         * <p>
         * The signing Amazon Web Services Region for IAM authorization.
         * </p>
         * 
         * @param signingRegion
         *        The signing Amazon Web Services Region for IAM authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingRegion(String signingRegion);

        /**
         * <p>
         * The signing service name for IAM authorization.
         * </p>
         * 
         * @param signingServiceName
         *        The signing service name for IAM authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingServiceName(String signingServiceName);
    }

    static final class BuilderImpl implements Builder {
        private String signingRegion;

        private String signingServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamConfig model) {
            signingRegion(model.signingRegion);
            signingServiceName(model.signingServiceName);
        }

        public final String getSigningRegion() {
            return signingRegion;
        }

        public final void setSigningRegion(String signingRegion) {
            this.signingRegion = signingRegion;
        }

        @Override
        public final Builder signingRegion(String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        public final String getSigningServiceName() {
            return signingServiceName;
        }

        public final void setSigningServiceName(String signingServiceName) {
            this.signingServiceName = signingServiceName;
        }

        @Override
        public final Builder signingServiceName(String signingServiceName) {
            this.signingServiceName = signingServiceName;
            return this;
        }

        @Override
        public AwsIamConfig build() {
            return new AwsIamConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
