/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an AppSync API. You can use <code>Api</code> for an AppSync API with your preferred configuration, such as
 * an Event API that provides real-time message publishing and message subscriptions over WebSockets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Api implements SdkPojo, Serializable, ToCopyableBuilder<Api.Builder, Api> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(Api::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Api::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_CONTACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerContact").getter(getter(Api::ownerContact)).setter(setter(Builder::ownerContact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerContact").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Api::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> DNS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("dns")
            .getter(getter(Api::dns))
            .setter(setter(Builder::dns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dns").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> API_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiArn")
            .getter(getter(Api::apiArn)).setter(setter(Builder::apiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiArn").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(Api::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("xrayEnabled").getter(getter(Api::xrayEnabled)).setter(setter(Builder::xrayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xrayEnabled").build()).build();

    private static final SdkField<String> WAF_WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("wafWebAclArn").getter(getter(Api::wafWebAclArn)).setter(setter(Builder::wafWebAclArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wafWebAclArn").build()).build();

    private static final SdkField<EventConfig> EVENT_CONFIG_FIELD = SdkField.<EventConfig> builder(MarshallingType.SDK_POJO)
            .memberName("eventConfig").getter(getter(Api::eventConfig)).setter(setter(Builder::eventConfig))
            .constructor(EventConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD,
            OWNER_CONTACT_FIELD, TAGS_FIELD, DNS_FIELD, API_ARN_FIELD, CREATED_FIELD, XRAY_ENABLED_FIELD, WAF_WEB_ACL_ARN_FIELD,
            EVENT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String apiId;

    private final String name;

    private final String ownerContact;

    private final Map<String, String> tags;

    private final Map<String, String> dns;

    private final String apiArn;

    private final Instant created;

    private final Boolean xrayEnabled;

    private final String wafWebAclArn;

    private final EventConfig eventConfig;

    private Api(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.ownerContact = builder.ownerContact;
        this.tags = builder.tags;
        this.dns = builder.dns;
        this.apiArn = builder.apiArn;
        this.created = builder.created;
        this.xrayEnabled = builder.xrayEnabled;
        this.wafWebAclArn = builder.wafWebAclArn;
        this.eventConfig = builder.eventConfig;
    }

    /**
     * <p>
     * The <code>Api</code> ID.
     * </p>
     * 
     * @return The <code>Api</code> ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The name of the <code>Api</code>.
     * </p>
     * 
     * @return The name of the <code>Api</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner contact information for the <code>Api</code>
     * </p>
     * 
     * @return The owner contact information for the <code>Api</code>
     */
    public final String ownerContact() {
        return ownerContact;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dns property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasDns() {
        return dns != null && !(dns instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The DNS records for the API. This will include an HTTP and a real-time endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDns} method.
     * </p>
     * 
     * @return The DNS records for the API. This will include an HTTP and a real-time endpoint.
     */
    public final Map<String, String> dns() {
        return dns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the <code>Api</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the <code>Api</code>.
     */
    public final String apiArn() {
        return apiArn;
    }

    /**
     * <p>
     * The date and time that the <code>Api</code> was created.
     * </p>
     * 
     * @return The date and time that the <code>Api</code> was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * A flag indicating whether to use X-Ray tracing for this <code>Api</code>.
     * </p>
     * 
     * @return A flag indicating whether to use X-Ray tracing for this <code>Api</code>.
     */
    public final Boolean xrayEnabled() {
        return xrayEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this <code>Api</code>
     * , if one exists.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this
     *         <code>Api</code>, if one exists.
     */
    public final String wafWebAclArn() {
        return wafWebAclArn;
    }

    /**
     * <p>
     * The Event API configuration. This includes the default authorization configuration for connecting, publishing,
     * and subscribing to an Event API.
     * </p>
     * 
     * @return The Event API configuration. This includes the default authorization configuration for connecting,
     *         publishing, and subscribing to an Event API.
     */
    public final EventConfig eventConfig() {
        return eventConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerContact());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDns() ? dns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(apiArn());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(xrayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(wafWebAclArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Api)) {
            return false;
        }
        Api other = (Api) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerContact(), other.ownerContact()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasDns() == other.hasDns() && Objects.equals(dns(), other.dns())
                && Objects.equals(apiArn(), other.apiArn()) && Objects.equals(created(), other.created())
                && Objects.equals(xrayEnabled(), other.xrayEnabled()) && Objects.equals(wafWebAclArn(), other.wafWebAclArn())
                && Objects.equals(eventConfig(), other.eventConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Api").add("ApiId", apiId()).add("Name", name()).add("OwnerContact", ownerContact())
                .add("Tags", hasTags() ? tags() : null).add("Dns", hasDns() ? dns() : null).add("ApiArn", apiArn())
                .add("Created", created()).add("XrayEnabled", xrayEnabled()).add("WafWebAclArn", wafWebAclArn())
                .add("EventConfig", eventConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ownerContact":
            return Optional.ofNullable(clazz.cast(ownerContact()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "dns":
            return Optional.ofNullable(clazz.cast(dns()));
        case "apiArn":
            return Optional.ofNullable(clazz.cast(apiArn()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "xrayEnabled":
            return Optional.ofNullable(clazz.cast(xrayEnabled()));
        case "wafWebAclArn":
            return Optional.ofNullable(clazz.cast(wafWebAclArn()));
        case "eventConfig":
            return Optional.ofNullable(clazz.cast(eventConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiId", API_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ownerContact", OWNER_CONTACT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("dns", DNS_FIELD);
        map.put("apiArn", API_ARN_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("xrayEnabled", XRAY_ENABLED_FIELD);
        map.put("wafWebAclArn", WAF_WEB_ACL_ARN_FIELD);
        map.put("eventConfig", EVENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Api, T> g) {
        return obj -> g.apply((Api) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Api> {
        /**
         * <p>
         * The <code>Api</code> ID.
         * </p>
         * 
         * @param apiId
         *        The <code>Api</code> ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The name of the <code>Api</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>Api</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner contact information for the <code>Api</code>
         * </p>
         * 
         * @param ownerContact
         *        The owner contact information for the <code>Api</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerContact(String ownerContact);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The DNS records for the API. This will include an HTTP and a real-time endpoint.
         * </p>
         * 
         * @param dns
         *        The DNS records for the API. This will include an HTTP and a real-time endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dns(Map<String, String> dns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the <code>Api</code>.
         * </p>
         * 
         * @param apiArn
         *        The Amazon Resource Name (ARN) for the <code>Api</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiArn(String apiArn);

        /**
         * <p>
         * The date and time that the <code>Api</code> was created.
         * </p>
         * 
         * @param created
         *        The date and time that the <code>Api</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * A flag indicating whether to use X-Ray tracing for this <code>Api</code>.
         * </p>
         * 
         * @param xrayEnabled
         *        A flag indicating whether to use X-Ray tracing for this <code>Api</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xrayEnabled(Boolean xrayEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this
         * <code>Api</code>, if one exists.
         * </p>
         * 
         * @param wafWebAclArn
         *        The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this
         *        <code>Api</code>, if one exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wafWebAclArn(String wafWebAclArn);

        /**
         * <p>
         * The Event API configuration. This includes the default authorization configuration for connecting,
         * publishing, and subscribing to an Event API.
         * </p>
         * 
         * @param eventConfig
         *        The Event API configuration. This includes the default authorization configuration for connecting,
         *        publishing, and subscribing to an Event API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfig(EventConfig eventConfig);

        /**
         * <p>
         * The Event API configuration. This includes the default authorization configuration for connecting,
         * publishing, and subscribing to an Event API.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventConfig.Builder} avoiding the need to
         * create one manually via {@link EventConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #eventConfig(EventConfig)}.
         * 
         * @param eventConfig
         *        a consumer that will call methods on {@link EventConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventConfig(EventConfig)
         */
        default Builder eventConfig(Consumer<EventConfig.Builder> eventConfig) {
            return eventConfig(EventConfig.builder().applyMutation(eventConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String apiId;

        private String name;

        private String ownerContact;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> dns = DefaultSdkAutoConstructMap.getInstance();

        private String apiArn;

        private Instant created;

        private Boolean xrayEnabled;

        private String wafWebAclArn;

        private EventConfig eventConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Api model) {
            apiId(model.apiId);
            name(model.name);
            ownerContact(model.ownerContact);
            tags(model.tags);
            dns(model.dns);
            apiArn(model.apiArn);
            created(model.created);
            xrayEnabled(model.xrayEnabled);
            wafWebAclArn(model.wafWebAclArn);
            eventConfig(model.eventConfig);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerContact() {
            return ownerContact;
        }

        public final void setOwnerContact(String ownerContact) {
            this.ownerContact = ownerContact;
        }

        @Override
        public final Builder ownerContact(String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getDns() {
            if (dns instanceof SdkAutoConstructMap) {
                return null;
            }
            return dns;
        }

        public final void setDns(Map<String, String> dns) {
            this.dns = MapOfStringToStringCopier.copy(dns);
        }

        @Override
        public final Builder dns(Map<String, String> dns) {
            this.dns = MapOfStringToStringCopier.copy(dns);
            return this;
        }

        public final String getApiArn() {
            return apiArn;
        }

        public final void setApiArn(String apiArn) {
            this.apiArn = apiArn;
        }

        @Override
        public final Builder apiArn(String apiArn) {
            this.apiArn = apiArn;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Boolean getXrayEnabled() {
            return xrayEnabled;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final String getWafWebAclArn() {
            return wafWebAclArn;
        }

        public final void setWafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
        }

        @Override
        public final Builder wafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
            return this;
        }

        public final EventConfig.Builder getEventConfig() {
            return eventConfig != null ? eventConfig.toBuilder() : null;
        }

        public final void setEventConfig(EventConfig.BuilderImpl eventConfig) {
            this.eventConfig = eventConfig != null ? eventConfig.build() : null;
        }

        @Override
        public final Builder eventConfig(EventConfig eventConfig) {
            this.eventConfig = eventConfig;
            return this;
        }

        @Override
        public Api build() {
            return new Api(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
