/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends AppStreamRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateApplicationRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<S3Location> ICON_S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("IconS3Location").getter(getter(UpdateApplicationRequest::iconS3Location))
            .setter(setter(Builder::iconS3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconS3Location").build()).build();

    private static final SdkField<String> LAUNCH_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchPath").getter(getter(UpdateApplicationRequest::launchPath)).setter(setter(Builder::launchPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPath").build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkingDirectory").getter(getter(UpdateApplicationRequest::workingDirectory))
            .setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()).build();

    private static final SdkField<String> LAUNCH_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchParameters").getter(getter(UpdateApplicationRequest::launchParameters))
            .setter(setter(Builder::launchParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchParameters").build()).build();

    private static final SdkField<String> APP_BLOCK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppBlockArn").getter(getter(UpdateApplicationRequest::appBlockArn)).setter(setter(Builder::appBlockArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockArn").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributesToDelete")
            .getter(getter(UpdateApplicationRequest::attributesToDeleteAsStrings))
            .setter(setter(Builder::attributesToDeleteWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ICON_S3_LOCATION_FIELD, LAUNCH_PATH_FIELD, WORKING_DIRECTORY_FIELD,
            LAUNCH_PARAMETERS_FIELD, APP_BLOCK_ARN_FIELD, ATTRIBUTES_TO_DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String displayName;

    private final String description;

    private final S3Location iconS3Location;

    private final String launchPath;

    private final String workingDirectory;

    private final String launchParameters;

    private final String appBlockArn;

    private final List<String> attributesToDelete;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.iconS3Location = builder.iconS3Location;
        this.launchPath = builder.launchPath;
        this.workingDirectory = builder.workingDirectory;
        this.launchParameters = builder.launchParameters;
        this.appBlockArn = builder.appBlockArn;
        this.attributesToDelete = builder.attributesToDelete;
    }

    /**
     * <p>
     * The name of the application. This name is visible to users when display name is not specified.
     * </p>
     * 
     * @return The name of the application. This name is visible to users when display name is not specified.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The display name of the application. This name is visible to users in the application catalog.
     * </p>
     * 
     * @return The display name of the application. This name is visible to users in the application catalog.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The icon S3 location of the application.
     * </p>
     * 
     * @return The icon S3 location of the application.
     */
    public final S3Location iconS3Location() {
        return iconS3Location;
    }

    /**
     * <p>
     * The launch path of the application.
     * </p>
     * 
     * @return The launch path of the application.
     */
    public final String launchPath() {
        return launchPath;
    }

    /**
     * <p>
     * The working directory of the application.
     * </p>
     * 
     * @return The working directory of the application.
     */
    public final String workingDirectory() {
        return workingDirectory;
    }

    /**
     * <p>
     * The launch parameters of the application.
     * </p>
     * 
     * @return The launch parameters of the application.
     */
    public final String launchParameters() {
        return launchParameters;
    }

    /**
     * <p>
     * The ARN of the app block.
     * </p>
     * 
     * @return The ARN of the app block.
     */
    public final String appBlockArn() {
        return appBlockArn;
    }

    /**
     * <p>
     * The attributes to delete for an application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToDelete} method.
     * </p>
     * 
     * @return The attributes to delete for an application.
     */
    public final List<ApplicationAttribute> attributesToDelete() {
        return ApplicationAttributesCopier.copyStringToEnum(attributesToDelete);
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributesToDelete() {
        return attributesToDelete != null && !(attributesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes to delete for an application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToDelete} method.
     * </p>
     * 
     * @return The attributes to delete for an application.
     */
    public final List<String> attributesToDeleteAsStrings() {
        return attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(iconS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(launchPath());
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(launchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(appBlockArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesToDelete() ? attributesToDeleteAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description()) && Objects.equals(iconS3Location(), other.iconS3Location())
                && Objects.equals(launchPath(), other.launchPath())
                && Objects.equals(workingDirectory(), other.workingDirectory())
                && Objects.equals(launchParameters(), other.launchParameters())
                && Objects.equals(appBlockArn(), other.appBlockArn()) && hasAttributesToDelete() == other.hasAttributesToDelete()
                && Objects.equals(attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("Name", name()).add("DisplayName", displayName())
                .add("Description", description()).add("IconS3Location", iconS3Location()).add("LaunchPath", launchPath())
                .add("WorkingDirectory", workingDirectory()).add("LaunchParameters", launchParameters())
                .add("AppBlockArn", appBlockArn())
                .add("AttributesToDelete", hasAttributesToDelete() ? attributesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IconS3Location":
            return Optional.ofNullable(clazz.cast(iconS3Location()));
        case "LaunchPath":
            return Optional.ofNullable(clazz.cast(launchPath()));
        case "WorkingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        case "LaunchParameters":
            return Optional.ofNullable(clazz.cast(launchParameters()));
        case "AppBlockArn":
            return Optional.ofNullable(clazz.cast(appBlockArn()));
        case "AttributesToDelete":
            return Optional.ofNullable(clazz.cast(attributesToDeleteAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IconS3Location", ICON_S3_LOCATION_FIELD);
        map.put("LaunchPath", LAUNCH_PATH_FIELD);
        map.put("WorkingDirectory", WORKING_DIRECTORY_FIELD);
        map.put("LaunchParameters", LAUNCH_PARAMETERS_FIELD);
        map.put("AppBlockArn", APP_BLOCK_ARN_FIELD);
        map.put("AttributesToDelete", ATTRIBUTES_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The name of the application. This name is visible to users when display name is not specified.
         * </p>
         * 
         * @param name
         *        The name of the application. This name is visible to users when display name is not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The display name of the application. This name is visible to users in the application catalog.
         * </p>
         * 
         * @param displayName
         *        The display name of the application. This name is visible to users in the application catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The icon S3 location of the application.
         * </p>
         * 
         * @param iconS3Location
         *        The icon S3 location of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconS3Location(S3Location iconS3Location);

        /**
         * <p>
         * The icon S3 location of the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #iconS3Location(S3Location)}.
         * 
         * @param iconS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iconS3Location(S3Location)
         */
        default Builder iconS3Location(Consumer<S3Location.Builder> iconS3Location) {
            return iconS3Location(S3Location.builder().applyMutation(iconS3Location).build());
        }

        /**
         * <p>
         * The launch path of the application.
         * </p>
         * 
         * @param launchPath
         *        The launch path of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPath(String launchPath);

        /**
         * <p>
         * The working directory of the application.
         * </p>
         * 
         * @param workingDirectory
         *        The working directory of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);

        /**
         * <p>
         * The launch parameters of the application.
         * </p>
         * 
         * @param launchParameters
         *        The launch parameters of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchParameters(String launchParameters);

        /**
         * <p>
         * The ARN of the app block.
         * </p>
         * 
         * @param appBlockArn
         *        The ARN of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBlockArn(String appBlockArn);

        /**
         * <p>
         * The attributes to delete for an application.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete);

        /**
         * <p>
         * The attributes to delete for an application.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDeleteWithStrings(String... attributesToDelete);

        /**
         * <p>
         * The attributes to delete for an application.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(Collection<ApplicationAttribute> attributesToDelete);

        /**
         * <p>
         * The attributes to delete for an application.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(ApplicationAttribute... attributesToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String displayName;

        private String description;

        private S3Location iconS3Location;

        private String launchPath;

        private String workingDirectory;

        private String launchParameters;

        private String appBlockArn;

        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            name(model.name);
            displayName(model.displayName);
            description(model.description);
            iconS3Location(model.iconS3Location);
            launchPath(model.launchPath);
            workingDirectory(model.workingDirectory);
            launchParameters(model.launchParameters);
            appBlockArn(model.appBlockArn);
            attributesToDeleteWithStrings(model.attributesToDelete);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final S3Location.Builder getIconS3Location() {
            return iconS3Location != null ? iconS3Location.toBuilder() : null;
        }

        public final void setIconS3Location(S3Location.BuilderImpl iconS3Location) {
            this.iconS3Location = iconS3Location != null ? iconS3Location.build() : null;
        }

        @Override
        public final Builder iconS3Location(S3Location iconS3Location) {
            this.iconS3Location = iconS3Location;
            return this;
        }

        public final String getLaunchPath() {
            return launchPath;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final String getLaunchParameters() {
            return launchParameters;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        @Override
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public final String getAppBlockArn() {
            return appBlockArn;
        }

        public final void setAppBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
        }

        @Override
        public final Builder appBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
            return this;
        }

        public final Collection<String> getAttributesToDelete() {
            if (attributesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesToDelete;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = ApplicationAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = ApplicationAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String... attributesToDelete) {
            attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<ApplicationAttribute> attributesToDelete) {
            this.attributesToDelete = ApplicationAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(ApplicationAttribute... attributesToDelete) {
            attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
