/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ThemeFooterLinksCopier {
    static List<ThemeFooterLink> copy(Collection<? extends ThemeFooterLink> themeFooterLinksParam) {
        List<ThemeFooterLink> list;
        if (themeFooterLinksParam == null || themeFooterLinksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThemeFooterLink> modifiableList = new ArrayList<>(themeFooterLinksParam.size());
            themeFooterLinksParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ThemeFooterLink> copyFromBuilder(Collection<? extends ThemeFooterLink.Builder> themeFooterLinksParam) {
        List<ThemeFooterLink> list;
        if (themeFooterLinksParam == null || themeFooterLinksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThemeFooterLink> modifiableList = new ArrayList<>(themeFooterLinksParam.size());
            themeFooterLinksParam.forEach(entry -> {
                ThemeFooterLink member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ThemeFooterLink.Builder> copyToBuilder(Collection<? extends ThemeFooterLink> themeFooterLinksParam) {
        List<ThemeFooterLink.Builder> list;
        if (themeFooterLinksParam == null || themeFooterLinksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThemeFooterLink.Builder> modifiableList = new ArrayList<>(themeFooterLinksParam.size());
            themeFooterLinksParam.forEach(entry -> {
                ThemeFooterLink.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
