/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom branding theme, which might include a custom logo, website links, and other branding to display to users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Theme implements SdkPojo, Serializable, ToCopyableBuilder<Theme.Builder, Theme> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(Theme::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Theme::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> THEME_TITLE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeTitleText").getter(getter(Theme::themeTitleText)).setter(setter(Builder::themeTitleText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeTitleText").build()).build();

    private static final SdkField<String> THEME_STYLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeStyling").getter(getter(Theme::themeStylingAsString)).setter(setter(Builder::themeStyling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeStyling").build()).build();

    private static final SdkField<List<ThemeFooterLink>> THEME_FOOTER_LINKS_FIELD = SdkField
            .<List<ThemeFooterLink>> builder(MarshallingType.LIST)
            .memberName("ThemeFooterLinks")
            .getter(getter(Theme::themeFooterLinks))
            .setter(setter(Builder::themeFooterLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeFooterLinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeFooterLink> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeFooterLink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> THEME_ORGANIZATION_LOGO_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeOrganizationLogoURL").getter(getter(Theme::themeOrganizationLogoURL))
            .setter(setter(Builder::themeOrganizationLogoURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeOrganizationLogoURL").build())
            .build();

    private static final SdkField<String> THEME_FAVICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeFaviconURL").getter(getter(Theme::themeFaviconURL)).setter(setter(Builder::themeFaviconURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeFaviconURL").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Theme::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, STATE_FIELD,
            THEME_TITLE_TEXT_FIELD, THEME_STYLING_FIELD, THEME_FOOTER_LINKS_FIELD, THEME_ORGANIZATION_LOGO_URL_FIELD,
            THEME_FAVICON_URL_FIELD, CREATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stackName;

    private final String state;

    private final String themeTitleText;

    private final String themeStyling;

    private final List<ThemeFooterLink> themeFooterLinks;

    private final String themeOrganizationLogoURL;

    private final String themeFaviconURL;

    private final Instant createdTime;

    private Theme(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.state = builder.state;
        this.themeTitleText = builder.themeTitleText;
        this.themeStyling = builder.themeStyling;
        this.themeFooterLinks = builder.themeFooterLinks;
        this.themeOrganizationLogoURL = builder.themeOrganizationLogoURL;
        this.themeFaviconURL = builder.themeFaviconURL;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The stack that has the custom branding theme.
     * </p>
     * 
     * @return The stack that has the custom branding theme.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The state of the theme.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ThemeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the theme.
     * @see ThemeState
     */
    public final ThemeState state() {
        return ThemeState.fromValue(state);
    }

    /**
     * <p>
     * The state of the theme.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ThemeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the theme.
     * @see ThemeState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The browser tab page title.
     * </p>
     * 
     * @return The browser tab page title.
     */
    public final String themeTitleText() {
        return themeTitleText;
    }

    /**
     * <p>
     * The color that is used for the website links, text, buttons, and catalog page background.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #themeStyling} will
     * return {@link ThemeStyling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #themeStylingAsString}.
     * </p>
     * 
     * @return The color that is used for the website links, text, buttons, and catalog page background.
     * @see ThemeStyling
     */
    public final ThemeStyling themeStyling() {
        return ThemeStyling.fromValue(themeStyling);
    }

    /**
     * <p>
     * The color that is used for the website links, text, buttons, and catalog page background.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #themeStyling} will
     * return {@link ThemeStyling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #themeStylingAsString}.
     * </p>
     * 
     * @return The color that is used for the website links, text, buttons, and catalog page background.
     * @see ThemeStyling
     */
    public final String themeStylingAsString() {
        return themeStyling;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThemeFooterLinks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThemeFooterLinks() {
        return themeFooterLinks != null && !(themeFooterLinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The website links that display in the catalog page footer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThemeFooterLinks} method.
     * </p>
     * 
     * @return The website links that display in the catalog page footer.
     */
    public final List<ThemeFooterLink> themeFooterLinks() {
        return themeFooterLinks;
    }

    /**
     * <p>
     * The URL of the logo that displays in the catalog page header.
     * </p>
     * 
     * @return The URL of the logo that displays in the catalog page header.
     */
    public final String themeOrganizationLogoURL() {
        return themeOrganizationLogoURL;
    }

    /**
     * <p>
     * The URL of the icon that displays at the top of a user's browser tab during streaming sessions.
     * </p>
     * 
     * @return The URL of the icon that displays at the top of a user's browser tab during streaming sessions.
     */
    public final String themeFaviconURL() {
        return themeFaviconURL;
    }

    /**
     * <p>
     * The time the theme was created.
     * </p>
     * 
     * @return The time the theme was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(themeTitleText());
        hashCode = 31 * hashCode + Objects.hashCode(themeStylingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasThemeFooterLinks() ? themeFooterLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(themeOrganizationLogoURL());
        hashCode = 31 * hashCode + Objects.hashCode(themeFaviconURL());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Theme)) {
            return false;
        }
        Theme other = (Theme) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(themeTitleText(), other.themeTitleText())
                && Objects.equals(themeStylingAsString(), other.themeStylingAsString())
                && hasThemeFooterLinks() == other.hasThemeFooterLinks()
                && Objects.equals(themeFooterLinks(), other.themeFooterLinks())
                && Objects.equals(themeOrganizationLogoURL(), other.themeOrganizationLogoURL())
                && Objects.equals(themeFaviconURL(), other.themeFaviconURL())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Theme").add("StackName", stackName()).add("State", stateAsString())
                .add("ThemeTitleText", themeTitleText()).add("ThemeStyling", themeStylingAsString())
                .add("ThemeFooterLinks", hasThemeFooterLinks() ? themeFooterLinks() : null)
                .add("ThemeOrganizationLogoURL", themeOrganizationLogoURL()).add("ThemeFaviconURL", themeFaviconURL())
                .add("CreatedTime", createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ThemeTitleText":
            return Optional.ofNullable(clazz.cast(themeTitleText()));
        case "ThemeStyling":
            return Optional.ofNullable(clazz.cast(themeStylingAsString()));
        case "ThemeFooterLinks":
            return Optional.ofNullable(clazz.cast(themeFooterLinks()));
        case "ThemeOrganizationLogoURL":
            return Optional.ofNullable(clazz.cast(themeOrganizationLogoURL()));
        case "ThemeFaviconURL":
            return Optional.ofNullable(clazz.cast(themeFaviconURL()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ThemeTitleText", THEME_TITLE_TEXT_FIELD);
        map.put("ThemeStyling", THEME_STYLING_FIELD);
        map.put("ThemeFooterLinks", THEME_FOOTER_LINKS_FIELD);
        map.put("ThemeOrganizationLogoURL", THEME_ORGANIZATION_LOGO_URL_FIELD);
        map.put("ThemeFaviconURL", THEME_FAVICON_URL_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Theme, T> g) {
        return obj -> g.apply((Theme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Theme> {
        /**
         * <p>
         * The stack that has the custom branding theme.
         * </p>
         * 
         * @param stackName
         *        The stack that has the custom branding theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The state of the theme.
         * </p>
         * 
         * @param state
         *        The state of the theme.
         * @see ThemeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the theme.
         * </p>
         * 
         * @param state
         *        The state of the theme.
         * @see ThemeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeState
         */
        Builder state(ThemeState state);

        /**
         * <p>
         * The browser tab page title.
         * </p>
         * 
         * @param themeTitleText
         *        The browser tab page title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeTitleText(String themeTitleText);

        /**
         * <p>
         * The color that is used for the website links, text, buttons, and catalog page background.
         * </p>
         * 
         * @param themeStyling
         *        The color that is used for the website links, text, buttons, and catalog page background.
         * @see ThemeStyling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeStyling
         */
        Builder themeStyling(String themeStyling);

        /**
         * <p>
         * The color that is used for the website links, text, buttons, and catalog page background.
         * </p>
         * 
         * @param themeStyling
         *        The color that is used for the website links, text, buttons, and catalog page background.
         * @see ThemeStyling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeStyling
         */
        Builder themeStyling(ThemeStyling themeStyling);

        /**
         * <p>
         * The website links that display in the catalog page footer.
         * </p>
         * 
         * @param themeFooterLinks
         *        The website links that display in the catalog page footer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeFooterLinks(Collection<ThemeFooterLink> themeFooterLinks);

        /**
         * <p>
         * The website links that display in the catalog page footer.
         * </p>
         * 
         * @param themeFooterLinks
         *        The website links that display in the catalog page footer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeFooterLinks(ThemeFooterLink... themeFooterLinks);

        /**
         * <p>
         * The website links that display in the catalog page footer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appstream.model.ThemeFooterLink.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appstream.model.ThemeFooterLink#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appstream.model.ThemeFooterLink.Builder#build()} is called immediately
         * and its result is passed to {@link #themeFooterLinks(List<ThemeFooterLink>)}.
         * 
         * @param themeFooterLinks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appstream.model.ThemeFooterLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themeFooterLinks(java.util.Collection<ThemeFooterLink>)
         */
        Builder themeFooterLinks(Consumer<ThemeFooterLink.Builder>... themeFooterLinks);

        /**
         * <p>
         * The URL of the logo that displays in the catalog page header.
         * </p>
         * 
         * @param themeOrganizationLogoURL
         *        The URL of the logo that displays in the catalog page header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeOrganizationLogoURL(String themeOrganizationLogoURL);

        /**
         * <p>
         * The URL of the icon that displays at the top of a user's browser tab during streaming sessions.
         * </p>
         * 
         * @param themeFaviconURL
         *        The URL of the icon that displays at the top of a user's browser tab during streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeFaviconURL(String themeFaviconURL);

        /**
         * <p>
         * The time the theme was created.
         * </p>
         * 
         * @param createdTime
         *        The time the theme was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String stackName;

        private String state;

        private String themeTitleText;

        private String themeStyling;

        private List<ThemeFooterLink> themeFooterLinks = DefaultSdkAutoConstructList.getInstance();

        private String themeOrganizationLogoURL;

        private String themeFaviconURL;

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Theme model) {
            stackName(model.stackName);
            state(model.state);
            themeTitleText(model.themeTitleText);
            themeStyling(model.themeStyling);
            themeFooterLinks(model.themeFooterLinks);
            themeOrganizationLogoURL(model.themeOrganizationLogoURL);
            themeFaviconURL(model.themeFaviconURL);
            createdTime(model.createdTime);
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ThemeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getThemeTitleText() {
            return themeTitleText;
        }

        public final void setThemeTitleText(String themeTitleText) {
            this.themeTitleText = themeTitleText;
        }

        @Override
        public final Builder themeTitleText(String themeTitleText) {
            this.themeTitleText = themeTitleText;
            return this;
        }

        public final String getThemeStyling() {
            return themeStyling;
        }

        public final void setThemeStyling(String themeStyling) {
            this.themeStyling = themeStyling;
        }

        @Override
        public final Builder themeStyling(String themeStyling) {
            this.themeStyling = themeStyling;
            return this;
        }

        @Override
        public final Builder themeStyling(ThemeStyling themeStyling) {
            this.themeStyling(themeStyling == null ? null : themeStyling.toString());
            return this;
        }

        public final List<ThemeFooterLink.Builder> getThemeFooterLinks() {
            List<ThemeFooterLink.Builder> result = ThemeFooterLinksCopier.copyToBuilder(this.themeFooterLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThemeFooterLinks(Collection<ThemeFooterLink.BuilderImpl> themeFooterLinks) {
            this.themeFooterLinks = ThemeFooterLinksCopier.copyFromBuilder(themeFooterLinks);
        }

        @Override
        public final Builder themeFooterLinks(Collection<ThemeFooterLink> themeFooterLinks) {
            this.themeFooterLinks = ThemeFooterLinksCopier.copy(themeFooterLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themeFooterLinks(ThemeFooterLink... themeFooterLinks) {
            themeFooterLinks(Arrays.asList(themeFooterLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themeFooterLinks(Consumer<ThemeFooterLink.Builder>... themeFooterLinks) {
            themeFooterLinks(Stream.of(themeFooterLinks).map(c -> ThemeFooterLink.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getThemeOrganizationLogoURL() {
            return themeOrganizationLogoURL;
        }

        public final void setThemeOrganizationLogoURL(String themeOrganizationLogoURL) {
            this.themeOrganizationLogoURL = themeOrganizationLogoURL;
        }

        @Override
        public final Builder themeOrganizationLogoURL(String themeOrganizationLogoURL) {
            this.themeOrganizationLogoURL = themeOrganizationLogoURL;
            return this;
        }

        public final String getThemeFaviconURL() {
            return themeFaviconURL;
        }

        public final void setThemeFaviconURL(String themeFaviconURL) {
            this.themeFaviconURL = themeFaviconURL;
        }

        @Override
        public final Builder themeFaviconURL(String themeFaviconURL) {
            this.themeFaviconURL = themeFaviconURL;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public Theme build() {
            return new Theme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
