/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a connector that enables persistent storage for users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageConnector implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageConnector.Builder, StorageConnector> {
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorType").getter(getter(StorageConnector::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorType").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(StorageConnector::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<List<String>> DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Domains")
            .getter(getter(StorageConnector::domains))
            .setter(setter(Builder::domains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DOMAINS_REQUIRE_ADMIN_CONSENT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DomainsRequireAdminConsent")
            .getter(getter(StorageConnector::domainsRequireAdminConsent))
            .setter(setter(Builder::domainsRequireAdminConsent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainsRequireAdminConsent").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPE_FIELD,
            RESOURCE_IDENTIFIER_FIELD, DOMAINS_FIELD, DOMAINS_REQUIRE_ADMIN_CONSENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorType;

    private final String resourceIdentifier;

    private final List<String> domains;

    private final List<String> domainsRequireAdminConsent;

    private StorageConnector(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.domains = builder.domains;
        this.domainsRequireAdminConsent = builder.domainsRequireAdminConsent;
    }

    /**
     * <p>
     * The type of storage connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link StorageConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of storage connector.
     * @see StorageConnectorType
     */
    public final StorageConnectorType connectorType() {
        return StorageConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of storage connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link StorageConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of storage connector.
     * @see StorageConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * The ARN of the storage connector.
     * </p>
     * 
     * @return The ARN of the storage connector.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Domains property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDomains() {
        return domains != null && !(domains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the domains for the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomains} method.
     * </p>
     * 
     * @return The names of the domains for the account.
     */
    public final List<String> domains() {
        return domains;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainsRequireAdminConsent property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainsRequireAdminConsent() {
        return domainsRequireAdminConsent != null && !(domainsRequireAdminConsent instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OneDrive for Business domains where you require admin consent when users try to link their OneDrive account
     * to AppStream 2.0. The attribute can only be specified when ConnectorType=ONE_DRIVE.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainsRequireAdminConsent} method.
     * </p>
     * 
     * @return The OneDrive for Business domains where you require admin consent when users try to link their OneDrive
     *         account to AppStream 2.0. The attribute can only be specified when ConnectorType=ONE_DRIVE.
     */
    public final List<String> domainsRequireAdminConsent() {
        return domainsRequireAdminConsent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomains() ? domains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainsRequireAdminConsent() ? domainsRequireAdminConsent() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConnector)) {
            return false;
        }
        StorageConnector other = (StorageConnector) obj;
        return Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier()) && hasDomains() == other.hasDomains()
                && Objects.equals(domains(), other.domains())
                && hasDomainsRequireAdminConsent() == other.hasDomainsRequireAdminConsent()
                && Objects.equals(domainsRequireAdminConsent(), other.domainsRequireAdminConsent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageConnector").add("ConnectorType", connectorTypeAsString())
                .add("ResourceIdentifier", resourceIdentifier()).add("Domains", hasDomains() ? domains() : null)
                .add("DomainsRequireAdminConsent", hasDomainsRequireAdminConsent() ? domainsRequireAdminConsent() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "Domains":
            return Optional.ofNullable(clazz.cast(domains()));
        case "DomainsRequireAdminConsent":
            return Optional.ofNullable(clazz.cast(domainsRequireAdminConsent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorType", CONNECTOR_TYPE_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("Domains", DOMAINS_FIELD);
        map.put("DomainsRequireAdminConsent", DOMAINS_REQUIRE_ADMIN_CONSENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageConnector, T> g) {
        return obj -> g.apply((StorageConnector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageConnector> {
        /**
         * <p>
         * The type of storage connector.
         * </p>
         * 
         * @param connectorType
         *        The type of storage connector.
         * @see StorageConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of storage connector.
         * </p>
         * 
         * @param connectorType
         *        The type of storage connector.
         * @see StorageConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorType
         */
        Builder connectorType(StorageConnectorType connectorType);

        /**
         * <p>
         * The ARN of the storage connector.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ARN of the storage connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The names of the domains for the account.
         * </p>
         * 
         * @param domains
         *        The names of the domains for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<String> domains);

        /**
         * <p>
         * The names of the domains for the account.
         * </p>
         * 
         * @param domains
         *        The names of the domains for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(String... domains);

        /**
         * <p>
         * The OneDrive for Business domains where you require admin consent when users try to link their OneDrive
         * account to AppStream 2.0. The attribute can only be specified when ConnectorType=ONE_DRIVE.
         * </p>
         * 
         * @param domainsRequireAdminConsent
         *        The OneDrive for Business domains where you require admin consent when users try to link their
         *        OneDrive account to AppStream 2.0. The attribute can only be specified when ConnectorType=ONE_DRIVE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainsRequireAdminConsent(Collection<String> domainsRequireAdminConsent);

        /**
         * <p>
         * The OneDrive for Business domains where you require admin consent when users try to link their OneDrive
         * account to AppStream 2.0. The attribute can only be specified when ConnectorType=ONE_DRIVE.
         * </p>
         * 
         * @param domainsRequireAdminConsent
         *        The OneDrive for Business domains where you require admin consent when users try to link their
         *        OneDrive account to AppStream 2.0. The attribute can only be specified when ConnectorType=ONE_DRIVE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainsRequireAdminConsent(String... domainsRequireAdminConsent);
    }

    static final class BuilderImpl implements Builder {
        private String connectorType;

        private String resourceIdentifier;

        private List<String> domains = DefaultSdkAutoConstructList.getInstance();

        private List<String> domainsRequireAdminConsent = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConnector model) {
            connectorType(model.connectorType);
            resourceIdentifier(model.resourceIdentifier);
            domains(model.domains);
            domainsRequireAdminConsent(model.domainsRequireAdminConsent);
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(StorageConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Collection<String> getDomains() {
            if (domains instanceof SdkAutoConstructList) {
                return null;
            }
            return domains;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = DomainListCopier.copy(domains);
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = DomainListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        public final Collection<String> getDomainsRequireAdminConsent() {
            if (domainsRequireAdminConsent instanceof SdkAutoConstructList) {
                return null;
            }
            return domainsRequireAdminConsent;
        }

        public final void setDomainsRequireAdminConsent(Collection<String> domainsRequireAdminConsent) {
            this.domainsRequireAdminConsent = DomainListCopier.copy(domainsRequireAdminConsent);
        }

        @Override
        public final Builder domainsRequireAdminConsent(Collection<String> domainsRequireAdminConsent) {
            this.domainsRequireAdminConsent = DomainListCopier.copy(domainsRequireAdminConsent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainsRequireAdminConsent(String... domainsRequireAdminConsent) {
            domainsRequireAdminConsent(Arrays.asList(domainsRequireAdminConsent));
            return this;
        }

        @Override
        public StorageConnector build() {
            return new StorageConnector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
