/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the permissions that are available to the specified AWS account for a shared image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SharedImagePermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<SharedImagePermissions.Builder, SharedImagePermissions> {
    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sharedAccountId").getter(getter(SharedImagePermissions::sharedAccountId))
            .setter(setter(Builder::sharedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAccountId").build()).build();

    private static final SdkField<ImagePermissions> IMAGE_PERMISSIONS_FIELD = SdkField
            .<ImagePermissions> builder(MarshallingType.SDK_POJO).memberName("imagePermissions")
            .getter(getter(SharedImagePermissions::imagePermissions)).setter(setter(Builder::imagePermissions))
            .constructor(ImagePermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePermissions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_ACCOUNT_ID_FIELD,
            IMAGE_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sharedAccountId;

    private final ImagePermissions imagePermissions;

    private SharedImagePermissions(BuilderImpl builder) {
        this.sharedAccountId = builder.sharedAccountId;
        this.imagePermissions = builder.imagePermissions;
    }

    /**
     * <p>
     * The 12-digit identifier of the AWS account with which the image is shared.
     * </p>
     * 
     * @return The 12-digit identifier of the AWS account with which the image is shared.
     */
    public final String sharedAccountId() {
        return sharedAccountId;
    }

    /**
     * <p>
     * Describes the permissions for a shared image.
     * </p>
     * 
     * @return Describes the permissions for a shared image.
     */
    public final ImagePermissions imagePermissions() {
        return imagePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(imagePermissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedImagePermissions)) {
            return false;
        }
        SharedImagePermissions other = (SharedImagePermissions) obj;
        return Objects.equals(sharedAccountId(), other.sharedAccountId())
                && Objects.equals(imagePermissions(), other.imagePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SharedImagePermissions").add("SharedAccountId", sharedAccountId())
                .add("ImagePermissions", imagePermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        case "imagePermissions":
            return Optional.ofNullable(clazz.cast(imagePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sharedAccountId", SHARED_ACCOUNT_ID_FIELD);
        map.put("imagePermissions", IMAGE_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SharedImagePermissions, T> g) {
        return obj -> g.apply((SharedImagePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SharedImagePermissions> {
        /**
         * <p>
         * The 12-digit identifier of the AWS account with which the image is shared.
         * </p>
         * 
         * @param sharedAccountId
         *        The 12-digit identifier of the AWS account with which the image is shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);

        /**
         * <p>
         * Describes the permissions for a shared image.
         * </p>
         * 
         * @param imagePermissions
         *        Describes the permissions for a shared image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePermissions(ImagePermissions imagePermissions);

        /**
         * <p>
         * Describes the permissions for a shared image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImagePermissions.Builder} avoiding the
         * need to create one manually via {@link ImagePermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImagePermissions.Builder#build()} is called immediately and its
         * result is passed to {@link #imagePermissions(ImagePermissions)}.
         * 
         * @param imagePermissions
         *        a consumer that will call methods on {@link ImagePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePermissions(ImagePermissions)
         */
        default Builder imagePermissions(Consumer<ImagePermissions.Builder> imagePermissions) {
            return imagePermissions(ImagePermissions.builder().applyMutation(imagePermissions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sharedAccountId;

        private ImagePermissions imagePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(SharedImagePermissions model) {
            sharedAccountId(model.sharedAccountId);
            imagePermissions(model.imagePermissions);
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final ImagePermissions.Builder getImagePermissions() {
            return imagePermissions != null ? imagePermissions.toBuilder() : null;
        }

        public final void setImagePermissions(ImagePermissions.BuilderImpl imagePermissions) {
            this.imagePermissions = imagePermissions != null ? imagePermissions.build() : null;
        }

        @Override
        public final Builder imagePermissions(ImagePermissions imagePermissions) {
            this.imagePermissions = imagePermissions;
            return this;
        }

        @Override
        public SharedImagePermissions build() {
            return new SharedImagePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
