/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImageBuilderRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateImageBuilderRequest.Builder, CreateImageBuilderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateImageBuilderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(CreateImageBuilderRequest::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageArn").getter(getter(CreateImageBuilderRequest::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(CreateImageBuilderRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateImageBuilderRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateImageBuilderRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateImageBuilderRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(CreateImageBuilderRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableDefaultInternetAccess")
            .getter(getter(CreateImageBuilderRequest::enableDefaultInternetAccess))
            .setter(setter(Builder::enableDefaultInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess")
                    .build()).build();

    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField
            .<DomainJoinInfo> builder(MarshallingType.SDK_POJO).memberName("DomainJoinInfo")
            .getter(getter(CreateImageBuilderRequest::domainJoinInfo)).setter(setter(Builder::domainJoinInfo))
            .constructor(DomainJoinInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()).build();

    private static final SdkField<String> APPSTREAM_AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppstreamAgentVersion").getter(getter(CreateImageBuilderRequest::appstreamAgentVersion))
            .setter(setter(Builder::appstreamAgentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppstreamAgentVersion").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateImageBuilderRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField
            .<List<AccessEndpoint>> builder(MarshallingType.LIST)
            .memberName("AccessEndpoints")
            .getter(getter(CreateImageBuilderRequest::accessEndpoints))
            .setter(setter(Builder::accessEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_NAME_FIELD,
            IMAGE_ARN_FIELD, INSTANCE_TYPE_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, VPC_CONFIG_FIELD, IAM_ROLE_ARN_FIELD,
            ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, DOMAIN_JOIN_INFO_FIELD, APPSTREAM_AGENT_VERSION_FIELD, TAGS_FIELD,
            ACCESS_ENDPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String imageName;

    private final String imageArn;

    private final String instanceType;

    private final String description;

    private final String displayName;

    private final VpcConfig vpcConfig;

    private final String iamRoleArn;

    private final Boolean enableDefaultInternetAccess;

    private final DomainJoinInfo domainJoinInfo;

    private final String appstreamAgentVersion;

    private final Map<String, String> tags;

    private final List<AccessEndpoint> accessEndpoints;

    private CreateImageBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.instanceType = builder.instanceType;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.vpcConfig = builder.vpcConfig;
        this.iamRoleArn = builder.iamRoleArn;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.appstreamAgentVersion = builder.appstreamAgentVersion;
        this.tags = builder.tags;
        this.accessEndpoints = builder.accessEndpoints;
    }

    /**
     * <p>
     * A unique name for the image builder.
     * </p>
     * 
     * @return A unique name for the image builder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the image used to create the image builder.
     * </p>
     * 
     * @return The name of the image used to create the image builder.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The ARN of the public, private, or shared image to use.
     * </p>
     * 
     * @return The ARN of the public, private, or shared image to use.
     */
    public final String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The instance type to use when launching the image builder. The following instance types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * stream.standard.small
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.medium
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.3xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.6xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-desktop.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.24xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.24xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.gr6.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.gr6.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6f.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6f.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6f.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6f.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.gr6f.4xlarge
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance type to use when launching the image builder. The following instance types are
     *         available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         stream.standard.small
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.3xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.6xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-desktop.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.24xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.24xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.gr6.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.gr6.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6f.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6f.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6f.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6f.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.gr6f.4xlarge
     *         </p>
     *         </li>
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The description to display.
     * </p>
     * 
     * @return The description to display.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The image builder name to display.
     * </p>
     * 
     * @return The image builder name to display.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The VPC configuration for the image builder. You can specify only one subnet.
     * </p>
     * 
     * @return The VPC configuration for the image builder. You can specify only one subnet.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder
     * calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role
     * to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary
     * credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
     * >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
     * Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image
     *         builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the
     *         ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0
     *         retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on
     *         the instance.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
     *         >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
     *         Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * Enables or disables default internet access for the image builder.
     * </p>
     * 
     * @return Enables or disables default internet access for the image builder.
     */
    public final Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * <p>
     * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active
     * Directory domain.
     * </p>
     * 
     * @return The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft
     *         Active Directory domain.
     */
    public final DomainJoinInfo domainJoinInfo() {
        return domainJoinInfo;
    }

    /**
     * <p>
     * The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream
     * 2.0 agent, specify [LATEST].
     * </p>
     * 
     * @return The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the
     *         AppStream 2.0 agent, specify [LATEST].
     */
    public final String appstreamAgentVersion() {
        return appstreamAgentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example,
     * Environment=Test. If you do not specify a value, Environment=.
     * </p>
     * <p>
     * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special
     * characters:
     * </p>
     * <p>
     * _ . : / = + \ - @
     * </p>
     * <p>
     * If you do not specify a value, the value is set to an empty string.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For
     *         example, Environment=Test. If you do not specify a value, Environment=. </p>
     *         <p>
     *         Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following
     *         special characters:
     *         </p>
     *         <p>
     *         _ . : / = + \ - @
     *         </p>
     *         <p>
     *         If you do not specify a value, the value is set to an empty string.
     *         </p>
     *         <p>
     *         For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
     *         Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessEndpoints() {
        return accessEndpoints != null && !(accessEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder
     * only through the specified endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessEndpoints} method.
     * </p>
     * 
     * @return The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image
     *         builder only through the specified endpoints.
     */
    public final List<AccessEndpoint> accessEndpoints() {
        return accessEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(appstreamAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessEndpoints() ? accessEndpoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageBuilderRequest)) {
            return false;
        }
        CreateImageBuilderRequest other = (CreateImageBuilderRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(imageName(), other.imageName())
                && Objects.equals(imageArn(), other.imageArn()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(enableDefaultInternetAccess(), other.enableDefaultInternetAccess())
                && Objects.equals(domainJoinInfo(), other.domainJoinInfo())
                && Objects.equals(appstreamAgentVersion(), other.appstreamAgentVersion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasAccessEndpoints() == other.hasAccessEndpoints()
                && Objects.equals(accessEndpoints(), other.accessEndpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateImageBuilderRequest").add("Name", name()).add("ImageName", imageName())
                .add("ImageArn", imageArn()).add("InstanceType", instanceType()).add("Description", description())
                .add("DisplayName", displayName()).add("VpcConfig", vpcConfig()).add("IamRoleArn", iamRoleArn())
                .add("EnableDefaultInternetAccess", enableDefaultInternetAccess()).add("DomainJoinInfo", domainJoinInfo())
                .add("AppstreamAgentVersion", appstreamAgentVersion()).add("Tags", hasTags() ? tags() : null)
                .add("AccessEndpoints", hasAccessEndpoints() ? accessEndpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "EnableDefaultInternetAccess":
            return Optional.ofNullable(clazz.cast(enableDefaultInternetAccess()));
        case "DomainJoinInfo":
            return Optional.ofNullable(clazz.cast(domainJoinInfo()));
        case "AppstreamAgentVersion":
            return Optional.ofNullable(clazz.cast(appstreamAgentVersion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AccessEndpoints":
            return Optional.ofNullable(clazz.cast(accessEndpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ImageName", IMAGE_NAME_FIELD);
        map.put("ImageArn", IMAGE_ARN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("EnableDefaultInternetAccess", ENABLE_DEFAULT_INTERNET_ACCESS_FIELD);
        map.put("DomainJoinInfo", DOMAIN_JOIN_INFO_FIELD);
        map.put("AppstreamAgentVersion", APPSTREAM_AGENT_VERSION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AccessEndpoints", ACCESS_ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImageBuilderRequest, T> g) {
        return obj -> g.apply((CreateImageBuilderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateImageBuilderRequest> {
        /**
         * <p>
         * A unique name for the image builder.
         * </p>
         * 
         * @param name
         *        A unique name for the image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the image used to create the image builder.
         * </p>
         * 
         * @param imageName
         *        The name of the image used to create the image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The ARN of the public, private, or shared image to use.
         * </p>
         * 
         * @param imageArn
         *        The ARN of the public, private, or shared image to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The instance type to use when launching the image builder. The following instance types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * stream.standard.small
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.medium
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.3xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.6xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-desktop.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.24xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.24xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.gr6.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.gr6.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6f.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6f.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6f.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6f.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.gr6f.4xlarge
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceType
         *        The instance type to use when launching the image builder. The following instance types are
         *        available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        stream.standard.small
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.3xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.6xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-desktop.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.24xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.24xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.gr6.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.gr6.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6f.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6f.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6f.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6f.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.gr6f.4xlarge
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The description to display.
         * </p>
         * 
         * @param description
         *        The description to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The image builder name to display.
         * </p>
         * 
         * @param displayName
         *        The image builder name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The VPC configuration for the image builder. You can specify only one subnet.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the image builder. You can specify only one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the image builder. You can specify only one subnet.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image
         * builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN
         * of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves
         * the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
         * >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
         * Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the
         *        image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and
         *        passes the ARN of the role to use. The operation creates a new session with temporary credentials.
         *        AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b>
         *        credential profile on the instance.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
         *        >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
         *        Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * Enables or disables default internet access for the image builder.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Enables or disables default internet access for the image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * <p>
         * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active
         * Directory domain.
         * </p>
         * 
         * @param domainJoinInfo
         *        The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft
         *        Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainJoinInfo(DomainJoinInfo domainJoinInfo);

        /**
         * <p>
         * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active
         * Directory domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainJoinInfo.Builder} avoiding the need
         * to create one manually via {@link DomainJoinInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainJoinInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #domainJoinInfo(DomainJoinInfo)}.
         * 
         * @param domainJoinInfo
         *        a consumer that will call methods on {@link DomainJoinInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainJoinInfo(DomainJoinInfo)
         */
        default Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return domainJoinInfo(DomainJoinInfo.builder().applyMutation(domainJoinInfo).build());
        }

        /**
         * <p>
         * The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the
         * AppStream 2.0 agent, specify [LATEST].
         * </p>
         * 
         * @param appstreamAgentVersion
         *        The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the
         *        AppStream 2.0 agent, specify [LATEST].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appstreamAgentVersion(String appstreamAgentVersion);

        /**
         * <p>
         * The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For
         * example, Environment=Test. If you do not specify a value, Environment=.
         * </p>
         * <p>
         * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following
         * special characters:
         * </p>
         * <p>
         * _ . : / = + \ - @
         * </p>
         * <p>
         * If you do not specify a value, the value is set to an empty string.
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         * Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param tags
         *        The tags to associate with the image builder. A tag is a key-value pair, and the value is optional.
         *        For example, Environment=Test. If you do not specify a value, Environment=. </p>
         *        <p>
         *        Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the
         *        following special characters:
         *        </p>
         *        <p>
         *        _ . : / = + \ - @
         *        </p>
         *        <p>
         *        If you do not specify a value, the value is set to an empty string.
         *        </p>
         *        <p>
         *        For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         *        Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image
         * builder only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the
         *        image builder only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image
         * builder only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the
         *        image builder only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(AccessEndpoint... accessEndpoints);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image
         * builder only through the specified endpoints.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appstream.model.AccessEndpoint.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appstream.model.AccessEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appstream.model.AccessEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #accessEndpoints(List<AccessEndpoint>)}.
         * 
         * @param accessEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appstream.model.AccessEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessEndpoints(java.util.Collection<AccessEndpoint>)
         */
        Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String imageName;

        private String imageArn;

        private String instanceType;

        private String description;

        private String displayName;

        private VpcConfig vpcConfig;

        private String iamRoleArn;

        private Boolean enableDefaultInternetAccess;

        private DomainJoinInfo domainJoinInfo;

        private String appstreamAgentVersion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageBuilderRequest model) {
            super(model);
            name(model.name);
            imageName(model.imageName);
            imageArn(model.imageArn);
            instanceType(model.instanceType);
            description(model.description);
            displayName(model.displayName);
            vpcConfig(model.vpcConfig);
            iamRoleArn(model.iamRoleArn);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            domainJoinInfo(model.domainJoinInfo);
            appstreamAgentVersion(model.appstreamAgentVersion);
            tags(model.tags);
            accessEndpoints(model.accessEndpoints);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getImageArn() {
            return imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return domainJoinInfo != null ? domainJoinInfo.toBuilder() : null;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final String getAppstreamAgentVersion() {
            return appstreamAgentVersion;
        }

        public final void setAppstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
        }

        @Override
        public final Builder appstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint... accessEndpoints) {
            accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints) {
            accessEndpoints(Stream.of(accessEndpoints).map(c -> AccessEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageBuilderRequest build() {
            return new CreateImageBuilderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
