/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateFleetRequest.Builder, CreateFleetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFleetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(CreateFleetRequest::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageArn").getter(getter(CreateFleetRequest::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(CreateFleetRequest::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetType").getter(getter(CreateFleetRequest::fleetTypeAsString)).setter(setter(Builder::fleetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()).build();

    private static final SdkField<ComputeCapacity> COMPUTE_CAPACITY_FIELD = SdkField
            .<ComputeCapacity> builder(MarshallingType.SDK_POJO).memberName("ComputeCapacity")
            .getter(getter(CreateFleetRequest::computeCapacity)).setter(setter(Builder::computeCapacity))
            .constructor(ComputeCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeCapacity").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateFleetRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<Integer> MAX_USER_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxUserDurationInSeconds")
            .getter(getter(CreateFleetRequest::maxUserDurationInSeconds)).setter(setter(Builder::maxUserDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUserDurationInSeconds").build())
            .build();

    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DisconnectTimeoutInSeconds")
            .getter(getter(CreateFleetRequest::disconnectTimeoutInSeconds))
            .setter(setter(Builder::disconnectTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimeoutInSeconds").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFleetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateFleetRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableDefaultInternetAccess")
            .getter(getter(CreateFleetRequest::enableDefaultInternetAccess))
            .setter(setter(Builder::enableDefaultInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess")
                    .build()).build();

    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField
            .<DomainJoinInfo> builder(MarshallingType.SDK_POJO).memberName("DomainJoinInfo")
            .getter(getter(CreateFleetRequest::domainJoinInfo)).setter(setter(Builder::domainJoinInfo))
            .constructor(DomainJoinInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateFleetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdleDisconnectTimeoutInSeconds")
            .getter(getter(CreateFleetRequest::idleDisconnectTimeoutInSeconds))
            .setter(setter(Builder::idleDisconnectTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleDisconnectTimeoutInSeconds")
                    .build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(CreateFleetRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> STREAM_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamView").getter(getter(CreateFleetRequest::streamViewAsString)).setter(setter(Builder::streamView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamView").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(CreateFleetRequest::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentSessions").getter(getter(CreateFleetRequest::maxConcurrentSessions))
            .setter(setter(Builder::maxConcurrentSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentSessions").build())
            .build();

    private static final SdkField<List<String>> USB_DEVICE_FILTER_STRINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UsbDeviceFilterStrings")
            .getter(getter(CreateFleetRequest::usbDeviceFilterStrings))
            .setter(setter(Builder::usbDeviceFilterStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsbDeviceFilterStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3Location> SESSION_SCRIPT_S3_LOCATION_FIELD = SdkField
            .<S3Location> builder(MarshallingType.SDK_POJO).memberName("SessionScriptS3Location")
            .getter(getter(CreateFleetRequest::sessionScriptS3Location)).setter(setter(Builder::sessionScriptS3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionScriptS3Location").build())
            .build();

    private static final SdkField<Integer> MAX_SESSIONS_PER_INSTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSessionsPerInstance").getter(getter(CreateFleetRequest::maxSessionsPerInstance))
            .setter(setter(Builder::maxSessionsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionsPerInstance").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_NAME_FIELD,
            IMAGE_ARN_FIELD, INSTANCE_TYPE_FIELD, FLEET_TYPE_FIELD, COMPUTE_CAPACITY_FIELD, VPC_CONFIG_FIELD,
            MAX_USER_DURATION_IN_SECONDS_FIELD, DISCONNECT_TIMEOUT_IN_SECONDS_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD,
            ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, DOMAIN_JOIN_INFO_FIELD, TAGS_FIELD, IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD,
            IAM_ROLE_ARN_FIELD, STREAM_VIEW_FIELD, PLATFORM_FIELD, MAX_CONCURRENT_SESSIONS_FIELD,
            USB_DEVICE_FILTER_STRINGS_FIELD, SESSION_SCRIPT_S3_LOCATION_FIELD, MAX_SESSIONS_PER_INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String imageName;

    private final String imageArn;

    private final String instanceType;

    private final String fleetType;

    private final ComputeCapacity computeCapacity;

    private final VpcConfig vpcConfig;

    private final Integer maxUserDurationInSeconds;

    private final Integer disconnectTimeoutInSeconds;

    private final String description;

    private final String displayName;

    private final Boolean enableDefaultInternetAccess;

    private final DomainJoinInfo domainJoinInfo;

    private final Map<String, String> tags;

    private final Integer idleDisconnectTimeoutInSeconds;

    private final String iamRoleArn;

    private final String streamView;

    private final String platform;

    private final Integer maxConcurrentSessions;

    private final List<String> usbDeviceFilterStrings;

    private final S3Location sessionScriptS3Location;

    private final Integer maxSessionsPerInstance;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.instanceType = builder.instanceType;
        this.fleetType = builder.fleetType;
        this.computeCapacity = builder.computeCapacity;
        this.vpcConfig = builder.vpcConfig;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.tags = builder.tags;
        this.idleDisconnectTimeoutInSeconds = builder.idleDisconnectTimeoutInSeconds;
        this.iamRoleArn = builder.iamRoleArn;
        this.streamView = builder.streamView;
        this.platform = builder.platform;
        this.maxConcurrentSessions = builder.maxConcurrentSessions;
        this.usbDeviceFilterStrings = builder.usbDeviceFilterStrings;
        this.sessionScriptS3Location = builder.sessionScriptS3Location;
        this.maxSessionsPerInstance = builder.maxSessionsPerInstance;
    }

    /**
     * <p>
     * A unique name for the fleet.
     * </p>
     * 
     * @return A unique name for the fleet.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the image used to create the fleet.
     * </p>
     * 
     * @return The name of the image used to create the fleet.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The ARN of the public, private, or shared image to use.
     * </p>
     * 
     * @return The ARN of the public, private, or shared image to use.
     */
    public final String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The instance type to use when launching fleet instances. The following instance types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * stream.standard.small
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.medium
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.3xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.6xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-desktop.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.24xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.24xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.gr6.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.gr6.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6f.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6f.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6f.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6f.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.gr6f.4xlarge
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following instance types are available for Elastic fleets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * stream.standard.small
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.medium
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.2xlarge
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance type to use when launching fleet instances. The following instance types are available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         stream.standard.small
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.3xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.6xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-desktop.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.24xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.24xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.gr6.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.gr6.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6f.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6f.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6f.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6f.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.gr6f.4xlarge
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following instance types are available for Elastic fleets:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         stream.standard.small
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.2xlarge
     *         </p>
     *         </li>
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The fleet type.
     * </p>
     * <dl>
     * <dt>ALWAYS_ON</dt>
     * <dd>
     * <p>
     * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
     * even if no users are streaming apps.
     * </p>
     * </dd>
     * <dt>ON_DEMAND</dt>
     * <dd>
     * <p>
     * Provide users with access to applications after they connect, which takes one to two minutes. You are charged for
     * instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return The fleet type.</p>
     *         <dl>
     *         <dt>ALWAYS_ON</dt>
     *         <dd>
     *         <p>
     *         Provides users with instant-on access to their apps. You are charged for all running instances in your
     *         fleet, even if no users are streaming apps.
     *         </p>
     *         </dd>
     *         <dt>ON_DEMAND</dt>
     *         <dd>
     *         <p>
     *         Provide users with access to applications after they connect, which takes one to two minutes. You are
     *         charged for instance streaming when users are connected and a small hourly fee for instances that are not
     *         streaming apps.
     *         </p>
     *         </dd>
     * @see FleetType
     */
    public final FleetType fleetType() {
        return FleetType.fromValue(fleetType);
    }

    /**
     * <p>
     * The fleet type.
     * </p>
     * <dl>
     * <dt>ALWAYS_ON</dt>
     * <dd>
     * <p>
     * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
     * even if no users are streaming apps.
     * </p>
     * </dd>
     * <dt>ON_DEMAND</dt>
     * <dd>
     * <p>
     * Provide users with access to applications after they connect, which takes one to two minutes. You are charged for
     * instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return The fleet type.</p>
     *         <dl>
     *         <dt>ALWAYS_ON</dt>
     *         <dd>
     *         <p>
     *         Provides users with instant-on access to their apps. You are charged for all running instances in your
     *         fleet, even if no users are streaming apps.
     *         </p>
     *         </dd>
     *         <dt>ON_DEMAND</dt>
     *         <dd>
     *         <p>
     *         Provide users with access to applications after they connect, which takes one to two minutes. You are
     *         charged for instance streaming when users are connected and a small hourly fee for instances that are not
     *         streaming apps.
     *         </p>
     *         </dd>
     * @see FleetType
     */
    public final String fleetTypeAsString() {
        return fleetType;
    }

    /**
     * <p>
     * The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify
     * MaxConcurrentSessions instead.
     * </p>
     * 
     * @return The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify
     *         MaxConcurrentSessions instead.
     */
    public final ComputeCapacity computeCapacity() {
        return computeCapacity;
    }

    /**
     * <p>
     * The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types.
     * Elastic fleets require that you specify at least two subnets in different availability zones.
     * </p>
     * 
     * @return The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other
     *         fleet types. Elastic fleets require that you specify at least two subnets in different availability
     *         zones.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected
     * to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents
     * before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.
     * </p>
     * <p>
     * Specify a value between 600 and 432000.
     * </p>
     * 
     * @return The maximum amount of time that a streaming session can remain active, in seconds. If users are still
     *         connected to a streaming instance five minutes before this limit is reached, they are prompted to save
     *         any open documents before being disconnected. After this time elapses, the instance is terminated and
     *         replaced by a new instance.</p>
     *         <p>
     *         Specify a value between 600 and 432000.
     */
    public final Integer maxUserDurationInSeconds() {
        return maxUserDurationInSeconds;
    }

    /**
     * <p>
     * The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to
     * the streaming session after a disconnection or network interruption within this time interval, they are connected
     * to their previous session. Otherwise, they are connected to a new session with a new streaming instance.
     * </p>
     * <p>
     * Specify a value between 60 and 36000.
     * </p>
     * 
     * @return The amount of time that a streaming session remains active after users disconnect. If users try to
     *         reconnect to the streaming session after a disconnection or network interruption within this time
     *         interval, they are connected to their previous session. Otherwise, they are connected to a new session
     *         with a new streaming instance. </p>
     *         <p>
     *         Specify a value between 60 and 36000.
     */
    public final Integer disconnectTimeoutInSeconds() {
        return disconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * The description to display.
     * </p>
     * 
     * @return The description to display.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The fleet name to display.
     * </p>
     * 
     * @return The fleet name to display.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Enables or disables default internet access for the fleet.
     * </p>
     * 
     * @return Enables or disables default internet access for the fleet.
     */
    public final Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * <p>
     * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory
     * domain. This is not allowed for Elastic fleets.
     * </p>
     * 
     * @return The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active
     *         Directory domain. This is not allowed for Elastic fleets.
     */
    public final DomainJoinInfo domainJoinInfo() {
        return domainJoinInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example,
     * Environment=Test. If you do not specify a value, Environment=.
     * </p>
     * <p>
     * If you do not specify a value, the value is set to an empty string.
     * </p>
     * <p>
     * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special
     * characters:
     * </p>
     * <p>
     * _ . : / = + \ - @
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example,
     *         Environment=Test. If you do not specify a value, Environment=. </p>
     *         <p>
     *         If you do not specify a value, the value is set to an empty string.
     *         </p>
     *         <p>
     *         Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following
     *         special characters:
     *         </p>
     *         <p>
     *         _ . : / = + \ - @
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
     *         Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session
     * and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are
     * disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval
     * specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users
     * are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads
     * and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be
     * idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.
     * </p>
     * <p>
     * To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value
     * between 60 and 36000. The default value is 0.
     * </p>
     * <note>
     * <p>
     * If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of
     * minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For
     * example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a
     * value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify
     * a value of 90, users are disconnected after 2 minutes of inactivity.
     * </p>
     * </note>
     * 
     * @return The amount of time that users can be idle (inactive) before they are disconnected from their streaming
     *         session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before
     *         they are disconnected due to inactivity. If they try to reconnect to the streaming session before the
     *         time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
     *         previous session. Users are considered idle when they stop providing keyboard or mouse input during their
     *         streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as
     *         user activity. If users continue to be idle after the time interval in
     *         <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
     *         <p>
     *         To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a
     *         value between 60 and 36000. The default value is 0.
     *         </p>
     *         <note>
     *         <p>
     *         If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole
     *         number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the
     *         nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of
     *         inactivity. If you specify a value that is at the midpoint between two different minutes, the value is
     *         rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of
     *         inactivity.
     *         </p>
     */
    public final Integer idleDisconnectTimeoutInSeconds() {
        return idleDisconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls
     * the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use.
     * The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials
     * and creates the <b>appstream_machine_role</b> credential profile on the instance.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
     * >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
     * Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance
     *         calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of
     *         the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves
     *         the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the
     *         instance.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
     *         >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
     *         Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is
     * specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the
     * standard desktop that is provided by the operating system displays.
     * </p>
     * <p>
     * The default value is <code>APP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamView} will
     * return {@link StreamView#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamViewAsString}.
     * </p>
     * 
     * @return The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When
     *         <code>APP</code> is specified, only the windows of applications opened by users display. When
     *         <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system
     *         displays.</p>
     *         <p>
     *         The default value is <code>APP</code>.
     * @see StreamView
     */
    public final StreamView streamView() {
        return StreamView.fromValue(streamView);
    }

    /**
     * <p>
     * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is
     * specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the
     * standard desktop that is provided by the operating system displays.
     * </p>
     * <p>
     * The default value is <code>APP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamView} will
     * return {@link StreamView#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamViewAsString}.
     * </p>
     * 
     * @return The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When
     *         <code>APP</code> is specified, only the windows of applications opened by users display. When
     *         <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system
     *         displays.</p>
     *         <p>
     *         The default value is <code>APP</code>.
     * @see StreamView
     */
    public final String streamViewAsString() {
        return streamView;
    }

    /**
     * <p>
     * The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
     * @see PlatformType
     */
    public final PlatformType platform() {
        return PlatformType.fromValue(platform);
    }

    /**
     * <p>
     * The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
     * @see PlatformType
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed for
     * other fleet types.
     * </p>
     * 
     * @return The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not
     *         allowed for other fleet types.
     */
    public final Integer maxConcurrentSessions() {
        return maxConcurrentSessions;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsbDeviceFilterStrings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUsbDeviceFilterStrings() {
        return usbDeviceFilterStrings != null && !(usbDeviceFilterStrings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session,
     * when using the Windows native client. This is allowed but not required for Elastic fleets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsbDeviceFilterStrings} method.
     * </p>
     * 
     * @return The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming
     *         session, when using the Windows native client. This is allowed but not required for Elastic fleets.
     */
    public final List<String> usbDeviceFilterStrings() {
        return usbDeviceFilterStrings;
    }

    /**
     * <p>
     * The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
     * </p>
     * 
     * @return The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
     */
    public final S3Location sessionScriptS3Location() {
        return sessionScriptS3Location;
    }

    /**
     * <p>
     * The maximum number of user sessions on an instance. This only applies to multi-session fleets.
     * </p>
     * 
     * @return The maximum number of user sessions on an instance. This only applies to multi-session fleets.
     */
    public final Integer maxSessionsPerInstance() {
        return maxSessionsPerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computeCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxUserDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idleDisconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamViewAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentSessions());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsbDeviceFilterStrings() ? usbDeviceFilterStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionScriptS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(maxSessionsPerInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(imageName(), other.imageName())
                && Objects.equals(imageArn(), other.imageArn()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(fleetTypeAsString(), other.fleetTypeAsString())
                && Objects.equals(computeCapacity(), other.computeCapacity()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(maxUserDurationInSeconds(), other.maxUserDurationInSeconds())
                && Objects.equals(disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(enableDefaultInternetAccess(), other.enableDefaultInternetAccess())
                && Objects.equals(domainJoinInfo(), other.domainJoinInfo()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(idleDisconnectTimeoutInSeconds(), other.idleDisconnectTimeoutInSeconds())
                && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(streamViewAsString(), other.streamViewAsString())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(maxConcurrentSessions(), other.maxConcurrentSessions())
                && hasUsbDeviceFilterStrings() == other.hasUsbDeviceFilterStrings()
                && Objects.equals(usbDeviceFilterStrings(), other.usbDeviceFilterStrings())
                && Objects.equals(sessionScriptS3Location(), other.sessionScriptS3Location())
                && Objects.equals(maxSessionsPerInstance(), other.maxSessionsPerInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetRequest").add("Name", name()).add("ImageName", imageName())
                .add("ImageArn", imageArn()).add("InstanceType", instanceType()).add("FleetType", fleetTypeAsString())
                .add("ComputeCapacity", computeCapacity()).add("VpcConfig", vpcConfig())
                .add("MaxUserDurationInSeconds", maxUserDurationInSeconds())
                .add("DisconnectTimeoutInSeconds", disconnectTimeoutInSeconds()).add("Description", description())
                .add("DisplayName", displayName()).add("EnableDefaultInternetAccess", enableDefaultInternetAccess())
                .add("DomainJoinInfo", domainJoinInfo()).add("Tags", hasTags() ? tags() : null)
                .add("IdleDisconnectTimeoutInSeconds", idleDisconnectTimeoutInSeconds()).add("IamRoleArn", iamRoleArn())
                .add("StreamView", streamViewAsString()).add("Platform", platformAsString())
                .add("MaxConcurrentSessions", maxConcurrentSessions())
                .add("UsbDeviceFilterStrings", hasUsbDeviceFilterStrings() ? usbDeviceFilterStrings() : null)
                .add("SessionScriptS3Location", sessionScriptS3Location())
                .add("MaxSessionsPerInstance", maxSessionsPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "FleetType":
            return Optional.ofNullable(clazz.cast(fleetTypeAsString()));
        case "ComputeCapacity":
            return Optional.ofNullable(clazz.cast(computeCapacity()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "MaxUserDurationInSeconds":
            return Optional.ofNullable(clazz.cast(maxUserDurationInSeconds()));
        case "DisconnectTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(disconnectTimeoutInSeconds()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "EnableDefaultInternetAccess":
            return Optional.ofNullable(clazz.cast(enableDefaultInternetAccess()));
        case "DomainJoinInfo":
            return Optional.ofNullable(clazz.cast(domainJoinInfo()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "IdleDisconnectTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(idleDisconnectTimeoutInSeconds()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "StreamView":
            return Optional.ofNullable(clazz.cast(streamViewAsString()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "MaxConcurrentSessions":
            return Optional.ofNullable(clazz.cast(maxConcurrentSessions()));
        case "UsbDeviceFilterStrings":
            return Optional.ofNullable(clazz.cast(usbDeviceFilterStrings()));
        case "SessionScriptS3Location":
            return Optional.ofNullable(clazz.cast(sessionScriptS3Location()));
        case "MaxSessionsPerInstance":
            return Optional.ofNullable(clazz.cast(maxSessionsPerInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ImageName", IMAGE_NAME_FIELD);
        map.put("ImageArn", IMAGE_ARN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("FleetType", FLEET_TYPE_FIELD);
        map.put("ComputeCapacity", COMPUTE_CAPACITY_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("MaxUserDurationInSeconds", MAX_USER_DURATION_IN_SECONDS_FIELD);
        map.put("DisconnectTimeoutInSeconds", DISCONNECT_TIMEOUT_IN_SECONDS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("EnableDefaultInternetAccess", ENABLE_DEFAULT_INTERNET_ACCESS_FIELD);
        map.put("DomainJoinInfo", DOMAIN_JOIN_INFO_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("IdleDisconnectTimeoutInSeconds", IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("StreamView", STREAM_VIEW_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("MaxConcurrentSessions", MAX_CONCURRENT_SESSIONS_FIELD);
        map.put("UsbDeviceFilterStrings", USB_DEVICE_FILTER_STRINGS_FIELD);
        map.put("SessionScriptS3Location", SESSION_SCRIPT_S3_LOCATION_FIELD);
        map.put("MaxSessionsPerInstance", MAX_SESSIONS_PER_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetRequest> {
        /**
         * <p>
         * A unique name for the fleet.
         * </p>
         * 
         * @param name
         *        A unique name for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the image used to create the fleet.
         * </p>
         * 
         * @param imageName
         *        The name of the image used to create the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The ARN of the public, private, or shared image to use.
         * </p>
         * 
         * @param imageArn
         *        The ARN of the public, private, or shared image to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The instance type to use when launching fleet instances. The following instance types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * stream.standard.small
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.medium
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.3xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.6xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-desktop.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.24xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.24xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.gr6.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.gr6.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6f.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6f.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6f.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6f.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.gr6f.4xlarge
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following instance types are available for Elastic fleets:
         * </p>
         * <ul>
         * <li>
         * <p>
         * stream.standard.small
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.medium
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.2xlarge
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceType
         *        The instance type to use when launching fleet instances. The following instance types are
         *        available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        stream.standard.small
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.3xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.6xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-desktop.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.24xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.24xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.gr6.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.gr6.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6f.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6f.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6f.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6f.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.gr6f.4xlarge
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following instance types are available for Elastic fleets:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        stream.standard.small
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.2xlarge
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The fleet type.
         * </p>
         * <dl>
         * <dt>ALWAYS_ON</dt>
         * <dd>
         * <p>
         * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
         * even if no users are streaming apps.
         * </p>
         * </dd>
         * <dt>ON_DEMAND</dt>
         * <dd>
         * <p>
         * Provide users with access to applications after they connect, which takes one to two minutes. You are charged
         * for instance streaming when users are connected and a small hourly fee for instances that are not streaming
         * apps.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param fleetType
         *        The fleet type.</p>
         *        <dl>
         *        <dt>ALWAYS_ON</dt>
         *        <dd>
         *        <p>
         *        Provides users with instant-on access to their apps. You are charged for all running instances in your
         *        fleet, even if no users are streaming apps.
         *        </p>
         *        </dd>
         *        <dt>ON_DEMAND</dt>
         *        <dd>
         *        <p>
         *        Provide users with access to applications after they connect, which takes one to two minutes. You are
         *        charged for instance streaming when users are connected and a small hourly fee for instances that are
         *        not streaming apps.
         *        </p>
         *        </dd>
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * The fleet type.
         * </p>
         * <dl>
         * <dt>ALWAYS_ON</dt>
         * <dd>
         * <p>
         * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
         * even if no users are streaming apps.
         * </p>
         * </dd>
         * <dt>ON_DEMAND</dt>
         * <dd>
         * <p>
         * Provide users with access to applications after they connect, which takes one to two minutes. You are charged
         * for instance streaming when users are connected and a small hourly fee for instances that are not streaming
         * apps.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param fleetType
         *        The fleet type.</p>
         *        <dl>
         *        <dt>ALWAYS_ON</dt>
         *        <dd>
         *        <p>
         *        Provides users with instant-on access to their apps. You are charged for all running instances in your
         *        fleet, even if no users are streaming apps.
         *        </p>
         *        </dd>
         *        <dt>ON_DEMAND</dt>
         *        <dd>
         *        <p>
         *        Provide users with access to applications after they connect, which takes one to two minutes. You are
         *        charged for instance streaming when users are connected and a small hourly fee for instances that are
         *        not streaming apps.
         *        </p>
         *        </dd>
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(FleetType fleetType);

        /**
         * <p>
         * The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify
         * MaxConcurrentSessions instead.
         * </p>
         * 
         * @param computeCapacity
         *        The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets,
         *        specify MaxConcurrentSessions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeCapacity(ComputeCapacity computeCapacity);

        /**
         * <p>
         * The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify
         * MaxConcurrentSessions instead.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeCapacity.Builder} avoiding the
         * need to create one manually via {@link ComputeCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #computeCapacity(ComputeCapacity)}.
         * 
         * @param computeCapacity
         *        a consumer that will call methods on {@link ComputeCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeCapacity(ComputeCapacity)
         */
        default Builder computeCapacity(Consumer<ComputeCapacity.Builder> computeCapacity) {
            return computeCapacity(ComputeCapacity.builder().applyMutation(computeCapacity).build());
        }

        /**
         * <p>
         * The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet
         * types. Elastic fleets require that you specify at least two subnets in different availability zones.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other
         *        fleet types. Elastic fleets require that you specify at least two subnets in different availability
         *        zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet
         * types. Elastic fleets require that you specify at least two subnets in different availability zones.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The maximum amount of time that a streaming session can remain active, in seconds. If users are still
         * connected to a streaming instance five minutes before this limit is reached, they are prompted to save any
         * open documents before being disconnected. After this time elapses, the instance is terminated and replaced by
         * a new instance.
         * </p>
         * <p>
         * Specify a value between 600 and 432000.
         * </p>
         * 
         * @param maxUserDurationInSeconds
         *        The maximum amount of time that a streaming session can remain active, in seconds. If users are still
         *        connected to a streaming instance five minutes before this limit is reached, they are prompted to save
         *        any open documents before being disconnected. After this time elapses, the instance is terminated and
         *        replaced by a new instance.</p>
         *        <p>
         *        Specify a value between 600 and 432000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds);

        /**
         * <p>
         * The amount of time that a streaming session remains active after users disconnect. If users try to reconnect
         * to the streaming session after a disconnection or network interruption within this time interval, they are
         * connected to their previous session. Otherwise, they are connected to a new session with a new streaming
         * instance.
         * </p>
         * <p>
         * Specify a value between 60 and 36000.
         * </p>
         * 
         * @param disconnectTimeoutInSeconds
         *        The amount of time that a streaming session remains active after users disconnect. If users try to
         *        reconnect to the streaming session after a disconnection or network interruption within this time
         *        interval, they are connected to their previous session. Otherwise, they are connected to a new session
         *        with a new streaming instance. </p>
         *        <p>
         *        Specify a value between 60 and 36000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds);

        /**
         * <p>
         * The description to display.
         * </p>
         * 
         * @param description
         *        The description to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The fleet name to display.
         * </p>
         * 
         * @param displayName
         *        The fleet name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Enables or disables default internet access for the fleet.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Enables or disables default internet access for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * <p>
         * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active
         * Directory domain. This is not allowed for Elastic fleets.
         * </p>
         * 
         * @param domainJoinInfo
         *        The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active
         *        Directory domain. This is not allowed for Elastic fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainJoinInfo(DomainJoinInfo domainJoinInfo);

        /**
         * <p>
         * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active
         * Directory domain. This is not allowed for Elastic fleets.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainJoinInfo.Builder} avoiding the need
         * to create one manually via {@link DomainJoinInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainJoinInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #domainJoinInfo(DomainJoinInfo)}.
         * 
         * @param domainJoinInfo
         *        a consumer that will call methods on {@link DomainJoinInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainJoinInfo(DomainJoinInfo)
         */
        default Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return domainJoinInfo(DomainJoinInfo.builder().applyMutation(domainJoinInfo).build());
        }

        /**
         * <p>
         * The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example,
         * Environment=Test. If you do not specify a value, Environment=.
         * </p>
         * <p>
         * If you do not specify a value, the value is set to an empty string.
         * </p>
         * <p>
         * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following
         * special characters:
         * </p>
         * <p>
         * _ . : / = + \ - @
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         * Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param tags
         *        The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For
         *        example, Environment=Test. If you do not specify a value, Environment=. </p>
         *        <p>
         *        If you do not specify a value, the value is set to an empty string.
         *        </p>
         *        <p>
         *        Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the
         *        following special characters:
         *        </p>
         *        <p>
         *        _ . : / = + \ - @
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         *        Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The amount of time that users can be idle (inactive) before they are disconnected from their streaming
         * session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they
         * are disconnected due to inactivity. If they try to reconnect to the streaming session before the time
         * interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous
         * session. Users are considered idle when they stop providing keyboard or mouse input during their streaming
         * session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user
         * activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code>
         * elapses, they are disconnected.
         * </p>
         * <p>
         * To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value
         * between 60 and 36000. The default value is 0.
         * </p>
         * <note>
         * <p>
         * If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number
         * of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute.
         * For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you
         * specify a value that is at the midpoint between two different minutes, the value is rounded up. For example,
         * if you specify a value of 90, users are disconnected after 2 minutes of inactivity.
         * </p>
         * </note>
         * 
         * @param idleDisconnectTimeoutInSeconds
         *        The amount of time that users can be idle (inactive) before they are disconnected from their streaming
         *        session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified
         *        before they are disconnected due to inactivity. If they try to reconnect to the streaming session
         *        before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are
         *        connected to their previous session. Users are considered idle when they stop providing keyboard or
         *        mouse input during their streaming session. File uploads and downloads, audio in, audio out, and
         *        pixels changing do not qualify as user activity. If users continue to be idle after the time interval
         *        in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
         *        <p>
         *        To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a
         *        value between 60 and 36000. The default value is 0.
         *        </p>
         *        <note>
         *        <p>
         *        If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole
         *        number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the
         *        nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of
         *        inactivity. If you specify a value that is at the midpoint between two different minutes, the value is
         *        rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of
         *        inactivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance
         * calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the
         * role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the
         * temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
         * >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
         * Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet
         *        instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes
         *        the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream
         *        2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential
         *        profile on the instance.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
         *        >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
         *        Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code>
         * is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is
         * specified, the standard desktop that is provided by the operating system displays.
         * </p>
         * <p>
         * The default value is <code>APP</code>.
         * </p>
         * 
         * @param streamView
         *        The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When
         *        <code>APP</code> is specified, only the windows of applications opened by users display. When
         *        <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system
         *        displays.</p>
         *        <p>
         *        The default value is <code>APP</code>.
         * @see StreamView
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamView
         */
        Builder streamView(String streamView);

        /**
         * <p>
         * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code>
         * is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is
         * specified, the standard desktop that is provided by the operating system displays.
         * </p>
         * <p>
         * The default value is <code>APP</code>.
         * </p>
         * 
         * @param streamView
         *        The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When
         *        <code>APP</code> is specified, only the windows of applications opened by users display. When
         *        <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system
         *        displays.</p>
         *        <p>
         *        The default value is <code>APP</code>.
         * @see StreamView
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamView
         */
        Builder streamView(StreamView streamView);

        /**
         * <p>
         * The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
         * </p>
         * 
         * @param platform
         *        The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(String platform);

        /**
         * <p>
         * The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
         * </p>
         * 
         * @param platform
         *        The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(PlatformType platform);

        /**
         * <p>
         * The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed
         * for other fleet types.
         * </p>
         * 
         * @param maxConcurrentSessions
         *        The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not
         *        allowed for other fleet types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentSessions(Integer maxConcurrentSessions);

        /**
         * <p>
         * The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming
         * session, when using the Windows native client. This is allowed but not required for Elastic fleets.
         * </p>
         * 
         * @param usbDeviceFilterStrings
         *        The USB device filter strings that specify which USB devices a user can redirect to the fleet
         *        streaming session, when using the Windows native client. This is allowed but not required for Elastic
         *        fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usbDeviceFilterStrings(Collection<String> usbDeviceFilterStrings);

        /**
         * <p>
         * The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming
         * session, when using the Windows native client. This is allowed but not required for Elastic fleets.
         * </p>
         * 
         * @param usbDeviceFilterStrings
         *        The USB device filter strings that specify which USB devices a user can redirect to the fleet
         *        streaming session, when using the Windows native client. This is allowed but not required for Elastic
         *        fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usbDeviceFilterStrings(String... usbDeviceFilterStrings);

        /**
         * <p>
         * The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
         * </p>
         * 
         * @param sessionScriptS3Location
         *        The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionScriptS3Location(S3Location sessionScriptS3Location);

        /**
         * <p>
         * The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #sessionScriptS3Location(S3Location)}.
         * 
         * @param sessionScriptS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionScriptS3Location(S3Location)
         */
        default Builder sessionScriptS3Location(Consumer<S3Location.Builder> sessionScriptS3Location) {
            return sessionScriptS3Location(S3Location.builder().applyMutation(sessionScriptS3Location).build());
        }

        /**
         * <p>
         * The maximum number of user sessions on an instance. This only applies to multi-session fleets.
         * </p>
         * 
         * @param maxSessionsPerInstance
         *        The maximum number of user sessions on an instance. This only applies to multi-session fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSessionsPerInstance(Integer maxSessionsPerInstance);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String imageName;

        private String imageArn;

        private String instanceType;

        private String fleetType;

        private ComputeCapacity computeCapacity;

        private VpcConfig vpcConfig;

        private Integer maxUserDurationInSeconds;

        private Integer disconnectTimeoutInSeconds;

        private String description;

        private String displayName;

        private Boolean enableDefaultInternetAccess;

        private DomainJoinInfo domainJoinInfo;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer idleDisconnectTimeoutInSeconds;

        private String iamRoleArn;

        private String streamView;

        private String platform;

        private Integer maxConcurrentSessions;

        private List<String> usbDeviceFilterStrings = DefaultSdkAutoConstructList.getInstance();

        private S3Location sessionScriptS3Location;

        private Integer maxSessionsPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            name(model.name);
            imageName(model.imageName);
            imageArn(model.imageArn);
            instanceType(model.instanceType);
            fleetType(model.fleetType);
            computeCapacity(model.computeCapacity);
            vpcConfig(model.vpcConfig);
            maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            description(model.description);
            displayName(model.displayName);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            domainJoinInfo(model.domainJoinInfo);
            tags(model.tags);
            idleDisconnectTimeoutInSeconds(model.idleDisconnectTimeoutInSeconds);
            iamRoleArn(model.iamRoleArn);
            streamView(model.streamView);
            platform(model.platform);
            maxConcurrentSessions(model.maxConcurrentSessions);
            usbDeviceFilterStrings(model.usbDeviceFilterStrings);
            sessionScriptS3Location(model.sessionScriptS3Location);
            maxSessionsPerInstance(model.maxSessionsPerInstance);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getImageArn() {
            return imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getFleetType() {
            return fleetType;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final ComputeCapacity.Builder getComputeCapacity() {
            return computeCapacity != null ? computeCapacity.toBuilder() : null;
        }

        public final void setComputeCapacity(ComputeCapacity.BuilderImpl computeCapacity) {
            this.computeCapacity = computeCapacity != null ? computeCapacity.build() : null;
        }

        @Override
        public final Builder computeCapacity(ComputeCapacity computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return maxUserDurationInSeconds;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return disconnectTimeoutInSeconds;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return domainJoinInfo != null ? domainJoinInfo.toBuilder() : null;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Integer getIdleDisconnectTimeoutInSeconds() {
            return idleDisconnectTimeoutInSeconds;
        }

        public final void setIdleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
        }

        @Override
        public final Builder idleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getStreamView() {
            return streamView;
        }

        public final void setStreamView(String streamView) {
            this.streamView = streamView;
        }

        @Override
        public final Builder streamView(String streamView) {
            this.streamView = streamView;
            return this;
        }

        @Override
        public final Builder streamView(StreamView streamView) {
            this.streamView(streamView == null ? null : streamView.toString());
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Integer getMaxConcurrentSessions() {
            return maxConcurrentSessions;
        }

        public final void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
        }

        @Override
        public final Builder maxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public final Collection<String> getUsbDeviceFilterStrings() {
            if (usbDeviceFilterStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return usbDeviceFilterStrings;
        }

        public final void setUsbDeviceFilterStrings(Collection<String> usbDeviceFilterStrings) {
            this.usbDeviceFilterStrings = UsbDeviceFilterStringsCopier.copy(usbDeviceFilterStrings);
        }

        @Override
        public final Builder usbDeviceFilterStrings(Collection<String> usbDeviceFilterStrings) {
            this.usbDeviceFilterStrings = UsbDeviceFilterStringsCopier.copy(usbDeviceFilterStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usbDeviceFilterStrings(String... usbDeviceFilterStrings) {
            usbDeviceFilterStrings(Arrays.asList(usbDeviceFilterStrings));
            return this;
        }

        public final S3Location.Builder getSessionScriptS3Location() {
            return sessionScriptS3Location != null ? sessionScriptS3Location.toBuilder() : null;
        }

        public final void setSessionScriptS3Location(S3Location.BuilderImpl sessionScriptS3Location) {
            this.sessionScriptS3Location = sessionScriptS3Location != null ? sessionScriptS3Location.build() : null;
        }

        @Override
        public final Builder sessionScriptS3Location(S3Location sessionScriptS3Location) {
            this.sessionScriptS3Location = sessionScriptS3Location;
            return this;
        }

        public final Integer getMaxSessionsPerInstance() {
            return maxSessionsPerInstance;
        }

        public final void setMaxSessionsPerInstance(Integer maxSessionsPerInstance) {
            this.maxSessionsPerInstance = maxSessionsPerInstance;
        }

        @Override
        public final Builder maxSessionsPerInstance(Integer maxSessionsPerInstance) {
            this.maxSessionsPerInstance = maxSessionsPerInstance;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
