/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the Transport Layer Security (TLS) properties for a listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayListenerTls implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayListenerTls.Builder, VirtualGatewayListenerTls> {
    private static final SdkField<VirtualGatewayListenerTlsCertificate> CERTIFICATE_FIELD = SdkField
            .<VirtualGatewayListenerTlsCertificate> builder(MarshallingType.SDK_POJO).memberName("certificate")
            .getter(getter(VirtualGatewayListenerTls::certificate)).setter(setter(Builder::certificate))
            .constructor(VirtualGatewayListenerTlsCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(VirtualGatewayListenerTls::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<VirtualGatewayListenerTlsValidationContext> VALIDATION_FIELD = SdkField
            .<VirtualGatewayListenerTlsValidationContext> builder(MarshallingType.SDK_POJO).memberName("validation")
            .getter(getter(VirtualGatewayListenerTls::validation)).setter(setter(Builder::validation))
            .constructor(VirtualGatewayListenerTlsValidationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, MODE_FIELD,
            VALIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayListenerTlsCertificate certificate;

    private final String mode;

    private final VirtualGatewayListenerTlsValidationContext validation;

    private VirtualGatewayListenerTls(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.mode = builder.mode;
        this.validation = builder.validation;
    }

    /**
     * <p>
     * An object that represents a Transport Layer Security (TLS) certificate.
     * </p>
     * 
     * @return An object that represents a Transport Layer Security (TLS) certificate.
     */
    public final VirtualGatewayListenerTlsCertificate certificate() {
        return certificate;
    }

    /**
     * <p>
     * Specify one of the following modes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b/>STRICT – Listener only accepts connections with TLS enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b/>DISABLED – Listener only accepts connections without TLS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link VirtualGatewayListenerTlsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modeAsString}.
     * </p>
     * 
     * @return Specify one of the following modes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b/>STRICT – Listener only accepts connections with TLS enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b/>DISABLED – Listener only accepts connections without TLS.
     *         </p>
     *         </li>
     * @see VirtualGatewayListenerTlsMode
     */
    public final VirtualGatewayListenerTlsMode mode() {
        return VirtualGatewayListenerTlsMode.fromValue(mode);
    }

    /**
     * <p>
     * Specify one of the following modes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b/>STRICT – Listener only accepts connections with TLS enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b/>DISABLED – Listener only accepts connections without TLS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link VirtualGatewayListenerTlsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modeAsString}.
     * </p>
     * 
     * @return Specify one of the following modes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b/>STRICT – Listener only accepts connections with TLS enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b/>DISABLED – Listener only accepts connections without TLS.
     *         </p>
     *         </li>
     * @see VirtualGatewayListenerTlsMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
     * context.
     * </p>
     * 
     * @return A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS)
     *         validation context.
     */
    public final VirtualGatewayListenerTlsValidationContext validation() {
        return validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayListenerTls)) {
            return false;
        }
        VirtualGatewayListenerTls other = (VirtualGatewayListenerTls) obj;
        return Objects.equals(certificate(), other.certificate()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(validation(), other.validation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayListenerTls").add("Certificate", certificate()).add("Mode", modeAsString())
                .add("Validation", validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "validation":
            return Optional.ofNullable(clazz.cast(validation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificate", CERTIFICATE_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("validation", VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayListenerTls, T> g) {
        return obj -> g.apply((VirtualGatewayListenerTls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayListenerTls> {
        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) certificate.
         * </p>
         * 
         * @param certificate
         *        An object that represents a Transport Layer Security (TLS) certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(VirtualGatewayListenerTlsCertificate certificate);

        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) certificate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VirtualGatewayListenerTlsCertificate.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayListenerTlsCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTlsCertificate.Builder#build()} is called
         * immediately and its result is passed to {@link #certificate(VirtualGatewayListenerTlsCertificate)}.
         * 
         * @param certificate
         *        a consumer that will call methods on {@link VirtualGatewayListenerTlsCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificate(VirtualGatewayListenerTlsCertificate)
         */
        default Builder certificate(Consumer<VirtualGatewayListenerTlsCertificate.Builder> certificate) {
            return certificate(VirtualGatewayListenerTlsCertificate.builder().applyMutation(certificate).build());
        }

        /**
         * <p>
         * Specify one of the following modes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b/>STRICT – Listener only accepts connections with TLS enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b/>DISABLED – Listener only accepts connections without TLS.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        Specify one of the following modes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b/>STRICT – Listener only accepts connections with TLS enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b/>DISABLED – Listener only accepts connections without TLS.
         *        </p>
         *        </li>
         * @see VirtualGatewayListenerTlsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualGatewayListenerTlsMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Specify one of the following modes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b/>STRICT – Listener only accepts connections with TLS enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b/>DISABLED – Listener only accepts connections without TLS.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        Specify one of the following modes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b/>STRICT – Listener only accepts connections with TLS enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b/>DISABLED – Listener only accepts connections without TLS.
         *        </p>
         *        </li>
         * @see VirtualGatewayListenerTlsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualGatewayListenerTlsMode
         */
        Builder mode(VirtualGatewayListenerTlsMode mode);

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS)
         * validation context.
         * </p>
         * 
         * @param validation
         *        A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS)
         *        validation context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validation(VirtualGatewayListenerTlsValidationContext validation);

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS)
         * validation context.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VirtualGatewayListenerTlsValidationContext.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayListenerTlsValidationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTlsValidationContext.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #validation(VirtualGatewayListenerTlsValidationContext)}.
         * 
         * @param validation
         *        a consumer that will call methods on {@link VirtualGatewayListenerTlsValidationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validation(VirtualGatewayListenerTlsValidationContext)
         */
        default Builder validation(Consumer<VirtualGatewayListenerTlsValidationContext.Builder> validation) {
            return validation(VirtualGatewayListenerTlsValidationContext.builder().applyMutation(validation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayListenerTlsCertificate certificate;

        private String mode;

        private VirtualGatewayListenerTlsValidationContext validation;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayListenerTls model) {
            certificate(model.certificate);
            mode(model.mode);
            validation(model.validation);
        }

        public final VirtualGatewayListenerTlsCertificate.Builder getCertificate() {
            return certificate != null ? certificate.toBuilder() : null;
        }

        public final void setCertificate(VirtualGatewayListenerTlsCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(VirtualGatewayListenerTlsCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(VirtualGatewayListenerTlsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final VirtualGatewayListenerTlsValidationContext.Builder getValidation() {
            return validation != null ? validation.toBuilder() : null;
        }

        public final void setValidation(VirtualGatewayListenerTlsValidationContext.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public final Builder validation(VirtualGatewayListenerTlsValidationContext validation) {
            this.validation = validation;
            return this;
        }

        @Override
        public VirtualGatewayListenerTls build() {
            return new VirtualGatewayListenerTls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
