/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the health check policy for a virtual node's listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthCheckPolicy.Builder, HealthCheckPolicy> {
    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthyThreshold").getter(getter(HealthCheckPolicy::healthyThreshold))
            .setter(setter(Builder::healthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyThreshold").build()).build();

    private static final SdkField<Long> INTERVAL_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("intervalMillis").getter(getter(HealthCheckPolicy::intervalMillis))
            .setter(setter(Builder::intervalMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intervalMillis").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(HealthCheckPolicy::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(HealthCheckPolicy::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(HealthCheckPolicy::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<Long> TIMEOUT_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("timeoutMillis").getter(getter(HealthCheckPolicy::timeoutMillis)).setter(setter(Builder::timeoutMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMillis").build()).build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unhealthyThreshold").getter(getter(HealthCheckPolicy::unhealthyThreshold))
            .setter(setter(Builder::unhealthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyThreshold").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTHY_THRESHOLD_FIELD,
            INTERVAL_MILLIS_FIELD, PATH_FIELD, PORT_FIELD, PROTOCOL_FIELD, TIMEOUT_MILLIS_FIELD, UNHEALTHY_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer healthyThreshold;

    private final Long intervalMillis;

    private final String path;

    private final Integer port;

    private final String protocol;

    private final Long timeoutMillis;

    private final Integer unhealthyThreshold;

    private HealthCheckPolicy(BuilderImpl builder) {
        this.healthyThreshold = builder.healthyThreshold;
        this.intervalMillis = builder.intervalMillis;
        this.path = builder.path;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.timeoutMillis = builder.timeoutMillis;
        this.unhealthyThreshold = builder.unhealthyThreshold;
    }

    /**
     * <p>
     * The number of consecutive successful health checks that must occur before declaring listener healthy.
     * </p>
     * 
     * @return The number of consecutive successful health checks that must occur before declaring listener healthy.
     */
    public final Integer healthyThreshold() {
        return healthyThreshold;
    }

    /**
     * <p>
     * The time period in milliseconds between each health check execution.
     * </p>
     * 
     * @return The time period in milliseconds between each health check execution.
     */
    public final Long intervalMillis() {
        return intervalMillis;
    }

    /**
     * <p>
     * The destination path for the health check request. This value is only used if the specified protocol is HTTP or
     * HTTP/2. For any other protocol, this value is ignored.
     * </p>
     * 
     * @return The destination path for the health check request. This value is only used if the specified protocol is
     *         HTTP or HTTP/2. For any other protocol, this value is ignored.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The destination port for the health check request. This port must match the port defined in the
     * <a>PortMapping</a> for the listener.
     * </p>
     * 
     * @return The destination port for the health check request. This port must match the port defined in the
     *         <a>PortMapping</a> for the listener.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The protocol for the health check request. If you specify <code>grpc</code>, then your service must conform to
     * the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking Protocol</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link PortProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for the health check request. If you specify <code>grpc</code>, then your service must
     *         conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
     *         Checking Protocol</a>.
     * @see PortProtocol
     */
    public final PortProtocol protocol() {
        return PortProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol for the health check request. If you specify <code>grpc</code>, then your service must conform to
     * the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking Protocol</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link PortProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for the health check request. If you specify <code>grpc</code>, then your service must
     *         conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
     *         Checking Protocol</a>.
     * @see PortProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The amount of time to wait when receiving a response from the health check, in milliseconds.
     * </p>
     * 
     * @return The amount of time to wait when receiving a response from the health check, in milliseconds.
     */
    public final Long timeoutMillis() {
        return timeoutMillis;
    }

    /**
     * <p>
     * The number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
     * </p>
     * 
     * @return The number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
     */
    public final Integer unhealthyThreshold() {
        return unhealthyThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(intervalMillis());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMillis());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckPolicy)) {
            return false;
        }
        HealthCheckPolicy other = (HealthCheckPolicy) obj;
        return Objects.equals(healthyThreshold(), other.healthyThreshold())
                && Objects.equals(intervalMillis(), other.intervalMillis()) && Objects.equals(path(), other.path())
                && Objects.equals(port(), other.port()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(timeoutMillis(), other.timeoutMillis())
                && Objects.equals(unhealthyThreshold(), other.unhealthyThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthCheckPolicy").add("HealthyThreshold", healthyThreshold())
                .add("IntervalMillis", intervalMillis()).add("Path", path()).add("Port", port())
                .add("Protocol", protocolAsString()).add("TimeoutMillis", timeoutMillis())
                .add("UnhealthyThreshold", unhealthyThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthyThreshold":
            return Optional.ofNullable(clazz.cast(healthyThreshold()));
        case "intervalMillis":
            return Optional.ofNullable(clazz.cast(intervalMillis()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "timeoutMillis":
            return Optional.ofNullable(clazz.cast(timeoutMillis()));
        case "unhealthyThreshold":
            return Optional.ofNullable(clazz.cast(unhealthyThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("healthyThreshold", HEALTHY_THRESHOLD_FIELD);
        map.put("intervalMillis", INTERVAL_MILLIS_FIELD);
        map.put("path", PATH_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("timeoutMillis", TIMEOUT_MILLIS_FIELD);
        map.put("unhealthyThreshold", UNHEALTHY_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckPolicy, T> g) {
        return obj -> g.apply((HealthCheckPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheckPolicy> {
        /**
         * <p>
         * The number of consecutive successful health checks that must occur before declaring listener healthy.
         * </p>
         * 
         * @param healthyThreshold
         *        The number of consecutive successful health checks that must occur before declaring listener healthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThreshold(Integer healthyThreshold);

        /**
         * <p>
         * The time period in milliseconds between each health check execution.
         * </p>
         * 
         * @param intervalMillis
         *        The time period in milliseconds between each health check execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalMillis(Long intervalMillis);

        /**
         * <p>
         * The destination path for the health check request. This value is only used if the specified protocol is HTTP
         * or HTTP/2. For any other protocol, this value is ignored.
         * </p>
         * 
         * @param path
         *        The destination path for the health check request. This value is only used if the specified protocol
         *        is HTTP or HTTP/2. For any other protocol, this value is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The destination port for the health check request. This port must match the port defined in the
         * <a>PortMapping</a> for the listener.
         * </p>
         * 
         * @param port
         *        The destination port for the health check request. This port must match the port defined in the
         *        <a>PortMapping</a> for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The protocol for the health check request. If you specify <code>grpc</code>, then your service must conform
         * to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking
         * Protocol</a>.
         * </p>
         * 
         * @param protocol
         *        The protocol for the health check request. If you specify <code>grpc</code>, then your service must
         *        conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
         *        Checking Protocol</a>.
         * @see PortProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol for the health check request. If you specify <code>grpc</code>, then your service must conform
         * to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking
         * Protocol</a>.
         * </p>
         * 
         * @param protocol
         *        The protocol for the health check request. If you specify <code>grpc</code>, then your service must
         *        conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
         *        Checking Protocol</a>.
         * @see PortProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortProtocol
         */
        Builder protocol(PortProtocol protocol);

        /**
         * <p>
         * The amount of time to wait when receiving a response from the health check, in milliseconds.
         * </p>
         * 
         * @param timeoutMillis
         *        The amount of time to wait when receiving a response from the health check, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMillis(Long timeoutMillis);

        /**
         * <p>
         * The number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
         * </p>
         * 
         * @param unhealthyThreshold
         *        The number of consecutive failed health checks that must occur before declaring a virtual node
         *        unhealthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThreshold(Integer unhealthyThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Integer healthyThreshold;

        private Long intervalMillis;

        private String path;

        private Integer port;

        private String protocol;

        private Long timeoutMillis;

        private Integer unhealthyThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckPolicy model) {
            healthyThreshold(model.healthyThreshold);
            intervalMillis(model.intervalMillis);
            path(model.path);
            port(model.port);
            protocol(model.protocol);
            timeoutMillis(model.timeoutMillis);
            unhealthyThreshold(model.unhealthyThreshold);
        }

        public final Integer getHealthyThreshold() {
            return healthyThreshold;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final Long getIntervalMillis() {
            return intervalMillis;
        }

        public final void setIntervalMillis(Long intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        @Override
        public final Builder intervalMillis(Long intervalMillis) {
            this.intervalMillis = intervalMillis;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(PortProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Long getTimeoutMillis() {
            return timeoutMillis;
        }

        public final void setTimeoutMillis(Long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        @Override
        public final Builder timeoutMillis(Long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public final Integer getUnhealthyThreshold() {
            return unhealthyThreshold;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        @Override
        public HealthCheckPolicy build() {
            return new HealthCheckPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
