/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the agent or data collector to be deleted along with the optional configurations for error
 * handling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAgent implements SdkPojo, Serializable, ToCopyableBuilder<DeleteAgent.Builder, DeleteAgent> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(DeleteAgent::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("force")
            .getter(getter(DeleteAgent::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, FORCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final Boolean force;

    private DeleteAgent(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.force = builder.force;
    }

    /**
     * <p>
     * The ID of the agent or data collector to delete.
     * </p>
     * 
     * @return The ID of the agent or data collector to delete.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Optional flag used to force delete an agent or data collector. It is needed to delete any agent in
     * HEALTHY/UNHEALTHY/RUNNING status. Note that deleting an agent that is actively reporting health causes it to be
     * re-registered with a different agent ID after data collector re-connects with Amazon Web Services.
     * </p>
     * 
     * @return Optional flag used to force delete an agent or data collector. It is needed to delete any agent in
     *         HEALTHY/UNHEALTHY/RUNNING status. Note that deleting an agent that is actively reporting health causes it
     *         to be re-registered with a different agent ID after data collector re-connects with Amazon Web Services.
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgent)) {
            return false;
        }
        DeleteAgent other = (DeleteAgent) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAgent").add("AgentId", agentId()).add("Force", force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("force", FORCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgent, T> g) {
        return obj -> g.apply((DeleteAgent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteAgent> {
        /**
         * <p>
         * The ID of the agent or data collector to delete.
         * </p>
         * 
         * @param agentId
         *        The ID of the agent or data collector to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Optional flag used to force delete an agent or data collector. It is needed to delete any agent in
         * HEALTHY/UNHEALTHY/RUNNING status. Note that deleting an agent that is actively reporting health causes it to
         * be re-registered with a different agent ID after data collector re-connects with Amazon Web Services.
         * </p>
         * 
         * @param force
         *        Optional flag used to force delete an agent or data collector. It is needed to delete any agent in
         *        HEALTHY/UNHEALTHY/RUNNING status. Note that deleting an agent that is actively reporting health causes
         *        it to be re-registered with a different agent ID after data collector re-connects with Amazon Web
         *        Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgent model) {
            agentId(model.agentId);
            force(model.force);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public DeleteAgent build() {
            return new DeleteAgent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
