/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a metric pair for a predictive scaling policy.
 * </p>
 * <p>
 * The following predefined metrics are available for predictive scaling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>ECSServiceAverageCPUUtilization</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ECSServiceAverageMemoryUtilization</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ECSServiceCPUUtilization</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ECSServiceMemoryUtilization</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ECSServiceTotalCPUUtilization</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ECSServiceTotalMemoryUtilization</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ALBRequestCount</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ALBRequestCountPerTarget</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TotalALBRequestCount</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictiveScalingPredefinedMetricPairSpecification
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<PredictiveScalingPredefinedMetricPairSpecification.Builder, PredictiveScalingPredefinedMetricPairSpecification> {
    private static final SdkField<String> PREDEFINED_METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredefinedMetricType")
            .getter(getter(PredictiveScalingPredefinedMetricPairSpecification::predefinedMetricType))
            .setter(setter(Builder::predefinedMetricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricType").build())
            .build();

    private static final SdkField<String> RESOURCE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceLabel").getter(getter(PredictiveScalingPredefinedMetricPairSpecification::resourceLabel))
            .setter(setter(Builder::resourceLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_METRIC_TYPE_FIELD,
            RESOURCE_LABEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String predefinedMetricType;

    private final String resourceLabel;

    private PredictiveScalingPredefinedMetricPairSpecification(BuilderImpl builder) {
        this.predefinedMetricType = builder.predefinedMetricType;
        this.resourceLabel = builder.resourceLabel;
    }

    /**
     * <p>
     * Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load
     * metric and one is a scaling metric.
     * </p>
     * 
     * @return Indicates which metrics to use. There are two different types of metrics for each metric type: one is a
     *         load metric and one is a scaling metric.
     */
    public final String predefinedMetricType() {
        return predefinedMetricType;
    }

    /**
     * <p>
     * A label that uniquely identifies a specific target group from which to determine the total and average request
     * count.
     * </p>
     * 
     * @return A label that uniquely identifies a specific target group from which to determine the total and average
     *         request count.
     */
    public final String resourceLabel() {
        return resourceLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingPredefinedMetricPairSpecification)) {
            return false;
        }
        PredictiveScalingPredefinedMetricPairSpecification other = (PredictiveScalingPredefinedMetricPairSpecification) obj;
        return Objects.equals(predefinedMetricType(), other.predefinedMetricType())
                && Objects.equals(resourceLabel(), other.resourceLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictiveScalingPredefinedMetricPairSpecification")
                .add("PredefinedMetricType", predefinedMetricType()).add("ResourceLabel", resourceLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedMetricType":
            return Optional.ofNullable(clazz.cast(predefinedMetricType()));
        case "ResourceLabel":
            return Optional.ofNullable(clazz.cast(resourceLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PredefinedMetricType", PREDEFINED_METRIC_TYPE_FIELD);
        map.put("ResourceLabel", RESOURCE_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingPredefinedMetricPairSpecification, T> g) {
        return obj -> g.apply((PredictiveScalingPredefinedMetricPairSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictiveScalingPredefinedMetricPairSpecification> {
        /**
         * <p>
         * Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load
         * metric and one is a scaling metric.
         * </p>
         * 
         * @param predefinedMetricType
         *        Indicates which metrics to use. There are two different types of metrics for each metric type: one is
         *        a load metric and one is a scaling metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedMetricType(String predefinedMetricType);

        /**
         * <p>
         * A label that uniquely identifies a specific target group from which to determine the total and average
         * request count.
         * </p>
         * 
         * @param resourceLabel
         *        A label that uniquely identifies a specific target group from which to determine the total and average
         *        request count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLabel(String resourceLabel);
    }

    static final class BuilderImpl implements Builder {
        private String predefinedMetricType;

        private String resourceLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingPredefinedMetricPairSpecification model) {
            predefinedMetricType(model.predefinedMetricType);
            resourceLabel(model.resourceLabel);
        }

        public final String getPredefinedMetricType() {
            return predefinedMetricType;
        }

        public final void setPredefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
        }

        @Override
        public final Builder predefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
            return this;
        }

        public final String getResourceLabel() {
            return resourceLabel;
        }

        public final void setResourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
        }

        @Override
        public final Builder resourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        @Override
        public PredictiveScalingPredefinedMetricPairSpecification build() {
            return new PredictiveScalingPredefinedMetricPairSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
