/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a MatchHeaderValue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingRuleMatchHeaderValue implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingRuleMatchHeaderValue.Builder, RoutingRuleMatchHeaderValue> {
    private static final SdkField<String> HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Header")
            .getter(getter(RoutingRuleMatchHeaderValue::header)).setter(setter(Builder::header))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("header").build()).build();

    private static final SdkField<String> VALUE_GLOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueGlob").getter(getter(RoutingRuleMatchHeaderValue::valueGlob)).setter(setter(Builder::valueGlob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueGlob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HEADER_FIELD, VALUE_GLOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String header;

    private final String valueGlob;

    private RoutingRuleMatchHeaderValue(BuilderImpl builder) {
        this.header = builder.header;
        this.valueGlob = builder.valueGlob;
    }

    /**
     * Returns the value of the Header property for this object.
     * 
     * @return The value of the Header property for this object.
     */
    public final String header() {
        return header;
    }

    /**
     * Returns the value of the ValueGlob property for this object.
     * 
     * @return The value of the ValueGlob property for this object.
     */
    public final String valueGlob() {
        return valueGlob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(header());
        hashCode = 31 * hashCode + Objects.hashCode(valueGlob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingRuleMatchHeaderValue)) {
            return false;
        }
        RoutingRuleMatchHeaderValue other = (RoutingRuleMatchHeaderValue) obj;
        return Objects.equals(header(), other.header()) && Objects.equals(valueGlob(), other.valueGlob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingRuleMatchHeaderValue").add("Header", header()).add("ValueGlob", valueGlob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        case "ValueGlob":
            return Optional.ofNullable(clazz.cast(valueGlob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("header", HEADER_FIELD);
        map.put("valueGlob", VALUE_GLOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingRuleMatchHeaderValue, T> g) {
        return obj -> g.apply((RoutingRuleMatchHeaderValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingRuleMatchHeaderValue> {
        /**
         * Sets the value of the Header property for this object.
         *
         * @param header
         *        The new value for the Header property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(String header);

        /**
         * Sets the value of the ValueGlob property for this object.
         *
         * @param valueGlob
         *        The new value for the ValueGlob property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueGlob(String valueGlob);
    }

    static final class BuilderImpl implements Builder {
        private String header;

        private String valueGlob;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingRuleMatchHeaderValue model) {
            header(model.header);
            valueGlob(model.valueGlob);
        }

        public final String getHeader() {
            return header;
        }

        public final void setHeader(String header) {
            this.header = header;
        }

        @Override
        public final Builder header(String header) {
            this.header = header;
            return this;
        }

        public final String getValueGlob() {
            return valueGlob;
        }

        public final void setValueGlob(String valueGlob) {
            this.valueGlob = valueGlob;
        }

        @Override
        public final Builder valueGlob(String valueGlob) {
            this.valueGlob = valueGlob;
            return this;
        }

        @Override
        public RoutingRuleMatchHeaderValue build() {
            return new RoutingRuleMatchHeaderValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
