/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The routing rule action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingRuleAction implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingRuleAction.Builder, RoutingRuleAction> {
    private static final SdkField<RoutingRuleActionInvokeApi> INVOKE_API_FIELD = SdkField
            .<RoutingRuleActionInvokeApi> builder(MarshallingType.SDK_POJO).memberName("InvokeApi")
            .getter(getter(RoutingRuleAction::invokeApi)).setter(setter(Builder::invokeApi))
            .constructor(RoutingRuleActionInvokeApi::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokeApi").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOKE_API_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RoutingRuleActionInvokeApi invokeApi;

    private RoutingRuleAction(BuilderImpl builder) {
        this.invokeApi = builder.invokeApi;
    }

    /**
     * Returns the value of the InvokeApi property for this object.
     * 
     * @return The value of the InvokeApi property for this object.
     */
    public final RoutingRuleActionInvokeApi invokeApi() {
        return invokeApi;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invokeApi());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingRuleAction)) {
            return false;
        }
        RoutingRuleAction other = (RoutingRuleAction) obj;
        return Objects.equals(invokeApi(), other.invokeApi());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingRuleAction").add("InvokeApi", invokeApi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvokeApi":
            return Optional.ofNullable(clazz.cast(invokeApi()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invokeApi", INVOKE_API_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingRuleAction, T> g) {
        return obj -> g.apply((RoutingRuleAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingRuleAction> {
        /**
         * Sets the value of the InvokeApi property for this object.
         *
         * @param invokeApi
         *        The new value for the InvokeApi property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokeApi(RoutingRuleActionInvokeApi invokeApi);

        /**
         * Sets the value of the InvokeApi property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RoutingRuleActionInvokeApi.Builder}
         * avoiding the need to create one manually via {@link RoutingRuleActionInvokeApi#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingRuleActionInvokeApi.Builder#build()} is called immediately
         * and its result is passed to {@link #invokeApi(RoutingRuleActionInvokeApi)}.
         * 
         * @param invokeApi
         *        a consumer that will call methods on {@link RoutingRuleActionInvokeApi.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invokeApi(RoutingRuleActionInvokeApi)
         */
        default Builder invokeApi(Consumer<RoutingRuleActionInvokeApi.Builder> invokeApi) {
            return invokeApi(RoutingRuleActionInvokeApi.builder().applyMutation(invokeApi).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RoutingRuleActionInvokeApi invokeApi;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingRuleAction model) {
            invokeApi(model.invokeApi);
        }

        public final RoutingRuleActionInvokeApi.Builder getInvokeApi() {
            return invokeApi != null ? invokeApi.toBuilder() : null;
        }

        public final void setInvokeApi(RoutingRuleActionInvokeApi.BuilderImpl invokeApi) {
            this.invokeApi = invokeApi != null ? invokeApi.build() : null;
        }

        @Override
        public final Builder invokeApi(RoutingRuleActionInvokeApi invokeApi) {
            this.invokeApi = invokeApi;
            return this;
        }

        @Override
        public RoutingRuleAction build() {
            return new RoutingRuleAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
