/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRouteSettingsRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<DeleteRouteSettingsRequest.Builder, DeleteRouteSettingsRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(DeleteRouteSettingsRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> ROUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteKey").getter(getter(DeleteRouteSettingsRequest::routeKey)).setter(setter(Builder::routeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeKey").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(DeleteRouteSettingsRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("stageName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, ROUTE_KEY_FIELD,
            STAGE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String apiId;

    private final String routeKey;

    private final String stageName;

    private DeleteRouteSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.routeKey = builder.routeKey;
        this.stageName = builder.stageName;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The route key.
     * </p>
     * 
     * @return The route key.
     */
    public final String routeKey() {
        return routeKey;
    }

    /**
     * <p>
     * The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is
     * 128 characters.
     * </p>
     * 
     * @return The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum
     *         length is 128 characters.
     */
    public final String stageName() {
        return stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(routeKey());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteSettingsRequest)) {
            return false;
        }
        DeleteRouteSettingsRequest other = (DeleteRouteSettingsRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(routeKey(), other.routeKey())
                && Objects.equals(stageName(), other.stageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRouteSettingsRequest").add("ApiId", apiId()).add("RouteKey", routeKey())
                .add("StageName", stageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "RouteKey":
            return Optional.ofNullable(clazz.cast(routeKey()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiId", API_ID_FIELD);
        map.put("routeKey", ROUTE_KEY_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRouteSettingsRequest, T> g) {
        return obj -> g.apply((DeleteRouteSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRouteSettingsRequest> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The route key.
         * </p>
         * 
         * @param routeKey
         *        The route key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeKey(String routeKey);

        /**
         * <p>
         * The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum
         * length is 128 characters.
         * </p>
         * 
         * @param stageName
         *        The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores.
         *        Maximum length is 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String routeKey;

        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteSettingsRequest model) {
            super(model);
            apiId(model.apiId);
            routeKey(model.routeKey);
            stageName(model.stageName);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getRouteKey() {
            return routeKey;
        }

        public final void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        @Override
        public final Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRouteSettingsRequest build() {
            return new DeleteRouteSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
