/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a summary of a Method resource, given a particular date and time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MethodSnapshot implements SdkPojo, Serializable, ToCopyableBuilder<MethodSnapshot.Builder, MethodSnapshot> {
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationType").getter(getter(MethodSnapshot::authorizationType))
            .setter(setter(Builder::authorizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()).build();

    private static final SdkField<Boolean> API_KEY_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("apiKeyRequired").getter(getter(MethodSnapshot::apiKeyRequired)).setter(setter(Builder::apiKeyRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyRequired").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_TYPE_FIELD,
            API_KEY_REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authorizationType;

    private final Boolean apiKeyRequired;

    private MethodSnapshot(BuilderImpl builder) {
        this.authorizationType = builder.authorizationType;
        this.apiKeyRequired = builder.apiKeyRequired;
    }

    /**
     * <p>
     * The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for
     * using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code>
     * for using a Cognito user pool.
     * </p>
     * 
     * @return The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code>
     *         for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or
     *         <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
     */
    public final String authorizationType() {
        return authorizationType;
    }

    /**
     * <p>
     * Specifies whether the method requires a valid ApiKey.
     * </p>
     * 
     * @return Specifies whether the method requires a valid ApiKey.
     */
    public final Boolean apiKeyRequired() {
        return apiKeyRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodSnapshot)) {
            return false;
        }
        MethodSnapshot other = (MethodSnapshot) obj;
        return Objects.equals(authorizationType(), other.authorizationType())
                && Objects.equals(apiKeyRequired(), other.apiKeyRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MethodSnapshot").add("AuthorizationType", authorizationType())
                .add("ApiKeyRequired", apiKeyRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationType":
            return Optional.ofNullable(clazz.cast(authorizationType()));
        case "apiKeyRequired":
            return Optional.ofNullable(clazz.cast(apiKeyRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorizationType", AUTHORIZATION_TYPE_FIELD);
        map.put("apiKeyRequired", API_KEY_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MethodSnapshot, T> g) {
        return obj -> g.apply((MethodSnapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MethodSnapshot> {
        /**
         * <p>
         * The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for
         * using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or
         * <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
         * </p>
         * 
         * @param authorizationType
         *        The method's authorization type. Valid values are <code>NONE</code> for open access,
         *        <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer,
         *        or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * Specifies whether the method requires a valid ApiKey.
         * </p>
         * 
         * @param apiKeyRequired
         *        Specifies whether the method requires a valid ApiKey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyRequired(Boolean apiKeyRequired);
    }

    static final class BuilderImpl implements Builder {
        private String authorizationType;

        private Boolean apiKeyRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(MethodSnapshot model) {
            authorizationType(model.authorizationType);
            apiKeyRequired(model.apiKeyRequired);
        }

        public final String getAuthorizationType() {
            return authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final Boolean getApiKeyRequired() {
            return apiKeyRequired;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        @Override
        public MethodSnapshot build() {
            return new MethodSnapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
