/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsagePlanKeysRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetUsagePlanKeysRequest.Builder, GetUsagePlanKeysRequest> {
    private static final SdkField<String> USAGE_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usagePlanId").getter(getter(GetUsagePlanKeysRequest::usagePlanId)).setter(setter(Builder::usagePlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("usageplanId").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(GetUsagePlanKeysRequest::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("position").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(GetUsagePlanKeysRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> NAME_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nameQuery").getter(getter(GetUsagePlanKeysRequest::nameQuery)).setter(setter(Builder::nameQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_PLAN_ID_FIELD,
            POSITION_FIELD, LIMIT_FIELD, NAME_QUERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String usagePlanId;

    private final String position;

    private final Integer limit;

    private final String nameQuery;

    private GetUsagePlanKeysRequest(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.position = builder.position;
        this.limit = builder.limit;
        this.nameQuery = builder.nameQuery;
    }

    /**
     * <p>
     * The Id of the UsagePlan resource representing the usage plan containing the to-be-retrieved UsagePlanKey resource
     * representing a plan customer.
     * </p>
     * 
     * @return The Id of the UsagePlan resource representing the usage plan containing the to-be-retrieved UsagePlanKey
     *         resource representing a plan customer.
     */
    public final String usagePlanId() {
        return usagePlanId;
    }

    /**
     * <p>
     * The current pagination position in the paged result set.
     * </p>
     * 
     * @return The current pagination position in the paged result set.
     */
    public final String position() {
        return position;
    }

    /**
     * <p>
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     * </p>
     * 
     * @return The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A query parameter specifying the name of the to-be-returned usage plan keys.
     * </p>
     * 
     * @return A query parameter specifying the name of the to-be-returned usage plan keys.
     */
    public final String nameQuery() {
        return nameQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nameQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsagePlanKeysRequest)) {
            return false;
        }
        GetUsagePlanKeysRequest other = (GetUsagePlanKeysRequest) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId()) && Objects.equals(position(), other.position())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nameQuery(), other.nameQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsagePlanKeysRequest").add("UsagePlanId", usagePlanId()).add("Position", position())
                .add("Limit", limit()).add("NameQuery", nameQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nameQuery":
            return Optional.ofNullable(clazz.cast(nameQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("usageplanId", USAGE_PLAN_ID_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("name", NAME_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUsagePlanKeysRequest, T> g) {
        return obj -> g.apply((GetUsagePlanKeysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetUsagePlanKeysRequest> {
        /**
         * <p>
         * The Id of the UsagePlan resource representing the usage plan containing the to-be-retrieved UsagePlanKey
         * resource representing a plan customer.
         * </p>
         * 
         * @param usagePlanId
         *        The Id of the UsagePlan resource representing the usage plan containing the to-be-retrieved
         *        UsagePlanKey resource representing a plan customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        /**
         * <p>
         * The current pagination position in the paged result set.
         * </p>
         * 
         * @param position
         *        The current pagination position in the paged result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * </p>
         * 
         * @param limit
         *        The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A query parameter specifying the name of the to-be-returned usage plan keys.
         * </p>
         * 
         * @param nameQuery
         *        A query parameter specifying the name of the to-be-returned usage plan keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameQuery(String nameQuery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String usagePlanId;

        private String position;

        private Integer limit;

        private String nameQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsagePlanKeysRequest model) {
            super(model);
            usagePlanId(model.usagePlanId);
            position(model.position);
            limit(model.limit);
            nameQuery(model.nameQuery);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNameQuery() {
            return nameQuery;
        }

        public final void setNameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
        }

        @Override
        public final Builder nameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsagePlanKeysRequest build() {
            return new GetUsagePlanKeysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
