/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a client certificate used to configure client-side SSL authentication while sending requests to the
 * integration endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClientCertificateResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetClientCertificateResponse.Builder, GetClientCertificateResponse> {
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientCertificateId").getter(getter(GetClientCertificateResponse::clientCertificateId))
            .setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetClientCertificateResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PEM_ENCODED_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pemEncodedCertificate").getter(getter(GetClientCertificateResponse::pemEncodedCertificate))
            .setter(setter(Builder::pemEncodedCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pemEncodedCertificate").build())
            .build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(GetClientCertificateResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationDate").getter(getter(GetClientCertificateResponse::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetClientCertificateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CERTIFICATE_ID_FIELD,
            DESCRIPTION_FIELD, PEM_ENCODED_CERTIFICATE_FIELD, CREATED_DATE_FIELD, EXPIRATION_DATE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientCertificateId;

    private final String description;

    private final String pemEncodedCertificate;

    private final Instant createdDate;

    private final Instant expirationDate;

    private final Map<String, String> tags;

    private GetClientCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.clientCertificateId = builder.clientCertificateId;
        this.description = builder.description;
        this.pemEncodedCertificate = builder.pemEncodedCertificate;
        this.createdDate = builder.createdDate;
        this.expirationDate = builder.expirationDate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the client certificate.
     * </p>
     * 
     * @return The identifier of the client certificate.
     */
    public final String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * The description of the client certificate.
     * </p>
     * 
     * @return The description of the client certificate.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication
     * in the integration endpoint .
     * </p>
     * 
     * @return The PEM-encoded public key of the client certificate, which can be used to configure certificate
     *         authentication in the integration endpoint .
     */
    public final String pemEncodedCertificate() {
        return pemEncodedCertificate;
    }

    /**
     * <p>
     * The timestamp when the client certificate was created.
     * </p>
     * 
     * @return The timestamp when the client certificate was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp when the client certificate will expire.
     * </p>
     * 
     * @return The timestamp when the client certificate will expire.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags. Each tag element is associated with a given resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The collection of tags. Each tag element is associated with a given resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pemEncodedCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClientCertificateResponse)) {
            return false;
        }
        GetClientCertificateResponse other = (GetClientCertificateResponse) obj;
        return Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(description(), other.description())
                && Objects.equals(pemEncodedCertificate(), other.pemEncodedCertificate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(expirationDate(), other.expirationDate())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClientCertificateResponse").add("ClientCertificateId", clientCertificateId())
                .add("Description", description()).add("PemEncodedCertificate", pemEncodedCertificate())
                .add("CreatedDate", createdDate()).add("ExpirationDate", expirationDate()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "pemEncodedCertificate":
            return Optional.ofNullable(clazz.cast(pemEncodedCertificate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "expirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientCertificateId", CLIENT_CERTIFICATE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("pemEncodedCertificate", PEM_ENCODED_CERTIFICATE_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("expirationDate", EXPIRATION_DATE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClientCertificateResponse, T> g) {
        return obj -> g.apply((GetClientCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetClientCertificateResponse> {
        /**
         * <p>
         * The identifier of the client certificate.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of the client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * The description of the client certificate.
         * </p>
         * 
         * @param description
         *        The description of the client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The PEM-encoded public key of the client certificate, which can be used to configure certificate
         * authentication in the integration endpoint .
         * </p>
         * 
         * @param pemEncodedCertificate
         *        The PEM-encoded public key of the client certificate, which can be used to configure certificate
         *        authentication in the integration endpoint .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pemEncodedCertificate(String pemEncodedCertificate);

        /**
         * <p>
         * The timestamp when the client certificate was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the client certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The timestamp when the client certificate will expire.
         * </p>
         * 
         * @param expirationDate
         *        The timestamp when the client certificate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * The collection of tags. Each tag element is associated with a given resource.
         * </p>
         * 
         * @param tags
         *        The collection of tags. Each tag element is associated with a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String clientCertificateId;

        private String description;

        private String pemEncodedCertificate;

        private Instant createdDate;

        private Instant expirationDate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetClientCertificateResponse model) {
            super(model);
            clientCertificateId(model.clientCertificateId);
            description(model.description);
            pemEncodedCertificate(model.pemEncodedCertificate);
            createdDate(model.createdDate);
            expirationDate(model.expirationDate);
            tags(model.tags);
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPemEncodedCertificate() {
            return pemEncodedCertificate;
        }

        public final void setPemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
        }

        @Override
        public final Builder pemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public GetClientCertificateResponse build() {
            return new GetClientCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
